/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import javax.xml.transform.TransformerConfigurationException;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.instruct.CopyOf;
import net.sf.saxon.instruct.Instruction;
import net.sf.saxon.om.Validation;
import net.sf.saxon.style.StandardNames;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.tree.AttributeCollection;

public final class XSLCopyOf
extends StyleElement {
    private Expression select;
    private boolean copyNamespaces;
    private boolean copyAnnotations;

    public boolean isInstruction() {
        return true;
    }

    public void prepareAttributes() throws TransformerConfigurationException {
        int n;
        StandardNames standardNames = this.getStandardNames();
        AttributeCollection attributeCollection = this.getAttributeList();
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        int n2 = 0;
        while (n2 < attributeCollection.getLength()) {
            n = attributeCollection.getNameCode(n2);
            int n3 = n & 0xFFFFF;
            if (n3 == standardNames.SELECT) {
                string = attributeCollection.getValue(n2);
            } else if (n3 == standardNames.COPY_NAMESPACES) {
                string2 = attributeCollection.getValue(n2).trim();
            } else if (n3 == standardNames.VALIDATION) {
                string3 = attributeCollection.getValue(n2).trim();
            } else if (n3 == standardNames.TYPE) {
                string4 = attributeCollection.getValue(n2).trim();
            } else {
                this.checkUnknownAttribute(n);
            }
            ++n2;
        }
        if (string != null) {
            this.select = this.makeExpression(string);
        } else {
            this.reportAbsence("select");
        }
        if (string2 == null) {
            this.copyNamespaces = true;
        } else if (string2.equals("yes")) {
            this.copyNamespaces = true;
        } else if (string2.equals("no")) {
            this.copyNamespaces = false;
        } else {
            this.compileError("Value of copy-namespaces must be 'yes' or 'no'");
        }
        if (string3 != null) {
            n = Validation.getCode(string3);
            if (n == 1) {
                this.compileError("validation=strict is not yet supported");
            }
            if (n == 2) {
                this.compileError("validation=lax is not yet supported");
            }
            if (n == 3) {
                this.copyAnnotations = true;
            }
            if (n == 4) {
                this.copyAnnotations = false;
            }
            if (n == -1) {
                this.compileError("invalid value of validation attribute");
            }
        }
        if (string4 != null) {
            n = this.getTypeAnnotationCode(string4);
            this.compileError("type attribute on xsl:copy-of is not yet supported");
        }
        if (string4 != null && string3 != null) {
            this.compileError("validation and type attributes are mutually exclusive");
        }
    }

    public void validate() throws TransformerConfigurationException {
        this.checkWithinTemplate();
        this.checkEmpty();
        this.select = this.typeCheck("select", this.select);
    }

    public Instruction compile() throws TransformerConfigurationException {
        return new CopyOf(this.select, this.copyNamespaces, this.copyAnnotations);
    }
}

