/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import javax.xml.transform.TransformerConfigurationException;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.instruct.Attribute;
import net.sf.saxon.instruct.Instruction;
import net.sf.saxon.instruct.NamespaceContext;
import net.sf.saxon.instruct.SimpleNodeConstructor;
import net.sf.saxon.om.Name;
import net.sf.saxon.om.NamespaceException;
import net.sf.saxon.om.QNameException;
import net.sf.saxon.om.Validation;
import net.sf.saxon.style.StandardNames;
import net.sf.saxon.style.XSLAttributeSet;
import net.sf.saxon.style.XSLStringConstructor;
import net.sf.saxon.tree.AttributeCollection;
import net.sf.saxon.value.StringValue;

public final class XSLAttribute
extends XSLStringConstructor {
    private Expression attributeName;
    private Expression namespace = null;
    private int validationAction = 3;
    private int annotation = 92;
    private boolean disable = false;

    public void prepareAttributes() throws TransformerConfigurationException {
        StandardNames standardNames = this.getStandardNames();
        AttributeCollection attributeCollection = this.getAttributeList();
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        int n = 0;
        while (n < attributeCollection.getLength()) {
            int n2 = attributeCollection.getNameCode(n);
            int n3 = n2 & 0xFFFFF;
            if (n3 == standardNames.NAME) {
                string = attributeCollection.getValue(n).trim();
            } else if (n3 == standardNames.NAMESPACE) {
                string2 = attributeCollection.getValue(n).trim();
            } else if (n3 == standardNames.VALIDATION) {
                string3 = attributeCollection.getValue(n).trim();
            } else if (n3 == standardNames.TYPE) {
                string4 = attributeCollection.getValue(n).trim();
            } else if (n3 == standardNames.DISABLE_OUTPUT_ESCAPING) {
                string5 = attributeCollection.getValue(n).trim();
            } else {
                this.checkUnknownAttribute(n2);
            }
            ++n;
        }
        if (string == null) {
            this.reportAbsence("name");
            return;
        }
        this.attributeName = this.makeAttributeValueTemplate(string);
        if (this.attributeName instanceof StringValue && !Name.isQName(string)) {
            this.compileError("Attribute name is not a valid QName");
            this.attributeName = new StringValue("saxon-error-attribute");
        }
        if (string2 != null) {
            this.namespace = this.makeAttributeValueTemplate(string2);
        }
        if (string3 != null) {
            this.validationAction = Validation.getCode(string3);
            if (this.validationAction == 1) {
                this.compileError("validation=strict is not yet supported");
            }
            if (this.validationAction == 2) {
                this.compileError("validation=lax is not yet supported");
            }
            if (this.validationAction == 3) {
                this.compileError("validation=preserve is not yet supported");
            }
            if (this.validationAction == 4) {
                this.compileError("validation=strip is not yet supported");
            }
            if (this.validationAction == -1) {
                this.compileError("invalid value of validation attribute");
            }
        }
        if (string4 != null) {
            this.annotation = this.getTypeAnnotationCode(string4);
        }
        if (string4 != null && string3 != null) {
            this.compileError("validation and type attributes are mutually exclusive");
        }
        if (string5 != null) {
            if (string5.equals("yes")) {
                this.disable = true;
            } else if (!string5.equals("no")) {
                this.compileError("disable-output-escaping must be 'yes' or 'no'");
            }
        }
    }

    public void validate() throws TransformerConfigurationException {
        if (!(this.getParentNode() instanceof XSLAttributeSet)) {
            this.checkWithinTemplate();
        }
        this.optimize();
        this.attributeName = this.typeCheck("name", this.attributeName);
        this.namespace = this.typeCheck("namespace", this.namespace);
    }

    public Instruction compile() throws TransformerConfigurationException {
        Object object;
        NamespaceContext namespaceContext = null;
        if (this.attributeName instanceof StringValue) {
            String[] stringArray;
            object = ((StringValue)this.attributeName).getStringValue().trim();
            try {
                stringArray = Name.getQNameParts((String)object);
            }
            catch (QNameException qNameException) {
                this.compileError("Invalid attribute name: " + (String)object);
                return null;
            }
            if (this.namespace == null) {
                try {
                    this.namespace = new StringValue(this.getURIForPrefix(stringArray[0], false));
                }
                catch (NamespaceException namespaceException) {
                    this.compileError(namespaceException.getMessage());
                    return null;
                }
            }
        } else if (this.namespace == null) {
            namespaceContext = this.makeNamespaceContext();
        }
        object = new Attribute(this.attributeName, this.namespace, namespaceContext, this.annotation, this.disable);
        this.compileContent((SimpleNodeConstructor)object);
        return object;
    }
}

