/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.xml.transform.TransformerConfigurationException;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.RoleLocator;
import net.sf.saxon.expr.TypeChecker;
import net.sf.saxon.functions.Matches;
import net.sf.saxon.instruct.AnalyzeString;
import net.sf.saxon.instruct.Block;
import net.sf.saxon.instruct.Instruction;
import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.style.StandardNames;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.style.XSLMatchingSubstring;
import net.sf.saxon.style.XSLStyleSheet;
import net.sf.saxon.tree.AttributeCollection;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.xpath.XPathException;

public class XSLAnalyzeString
extends StyleElement {
    private Expression select;
    private Expression regex;
    private Expression flags;
    private StyleElement matching;
    private StyleElement nonMatching;
    private Pattern pattern;

    public boolean isInstruction() {
        return true;
    }

    protected int getReturnedItemType() {
        return this.getCommonChildItemType();
    }

    public void prepareAttributes() throws TransformerConfigurationException {
        block14: {
            int n;
            String string = null;
            String string2 = null;
            String string3 = null;
            StandardNames standardNames = this.getStandardNames();
            AttributeCollection attributeCollection = this.getAttributeList();
            int n2 = 0;
            while (n2 < attributeCollection.getLength()) {
                n = attributeCollection.getNameCode(n2);
                int n3 = n & 0xFFFFF;
                if (n3 == standardNames.REGEX) {
                    string2 = attributeCollection.getValue(n2);
                } else if (n3 == standardNames.SELECT) {
                    string = attributeCollection.getValue(n2);
                } else if (n3 == standardNames.FLAGS) {
                    string3 = attributeCollection.getValue(n2).trim();
                } else {
                    this.checkUnknownAttribute(n);
                }
                ++n2;
            }
            if (string == null) {
                this.reportAbsence("select");
                string = ".";
            }
            this.select = this.makeExpression(string);
            if (string2 == null) {
                this.reportAbsence("regex");
                string2 = "xxx";
            }
            this.regex = this.makeAttributeValueTemplate(string2);
            if (string3 == null) {
                string3 = "";
            }
            this.flags = this.makeAttributeValueTemplate(string3);
            if (!(this.regex instanceof StringValue) || !(this.flags instanceof StringValue)) break block14;
            n = 0;
            try {
                n = Matches.setFlags(((StringValue)this.flags).getStringValue());
            }
            catch (XPathException xPathException) {
                this.compileError("Invalid value of flags attribute: " + xPathException);
            }
            try {
                this.pattern = Pattern.compile(((StringValue)this.regex).getStringValue(), n);
            }
            catch (PatternSyntaxException patternSyntaxException) {
                this.compileError("Error in regular expression: " + patternSyntaxException);
            }
        }
    }

    public void validate() throws TransformerConfigurationException {
        Object object;
        this.checkWithinTemplate();
        AxisIterator axisIterator = this.iterateAxis((byte)3);
        while (axisIterator.hasNext()) {
            object = (NodeInfo)axisIterator.next();
            if (object instanceof XSLMatchingSubstring) {
                boolean bl = object.getLocalName().equals("matching-substring");
                if (bl) {
                    if (this.matching != null) {
                        this.compileError("xsl:matching-substring element must only appear once");
                    }
                    this.matching = (StyleElement)object;
                    continue;
                }
                if (this.nonMatching != null) {
                    this.compileError("xsl:non-matching-substring element must only appear once");
                }
                this.nonMatching = (StyleElement)object;
                continue;
            }
            this.compileError("Only xsl:matching-substring and xsl:non-matching-substring are allowed here");
        }
        this.select = this.typeCheck("select", this.select);
        this.regex = this.typeCheck("regex", this.regex);
        this.flags = this.typeCheck("flags", this.flags);
        try {
            object = new RoleLocator(4, "xsl:analyze-string/select", 0);
            this.select = TypeChecker.staticTypeCheck(this.select, SequenceType.SINGLE_STRING, false, (RoleLocator)object);
            object = new RoleLocator(4, "xsl:analyze-string/regex", 0);
            this.regex = TypeChecker.staticTypeCheck(this.regex, SequenceType.SINGLE_STRING, false, (RoleLocator)object);
            object = new RoleLocator(4, "xsl:analyze-string/flags", 0);
            this.flags = TypeChecker.staticTypeCheck(this.flags, SequenceType.SINGLE_STRING, false, (RoleLocator)object);
        }
        catch (XPathException xPathException) {
            this.compileError(xPathException);
        }
    }

    public Instruction compile() throws TransformerConfigurationException {
        XSLStyleSheet xSLStyleSheet = this.getPrincipalStyleSheet();
        Block block = null;
        if (this.matching != null) {
            block = new Block();
            block.setSourceLocation(xSLStyleSheet.putModuleNumber(this.matching.getSystemId()), this.matching.getLineNumber());
            block.setInstructionName((byte)3);
            this.matching.compileChildren(block);
        }
        Block block2 = null;
        if (this.nonMatching != null) {
            block2 = new Block();
            block2.setSourceLocation(xSLStyleSheet.putModuleNumber(this.nonMatching.getSystemId()), this.nonMatching.getLineNumber());
            block2.setInstructionName((byte)4);
            this.nonMatching.compileChildren(block2);
        }
        AnalyzeString analyzeString = new AnalyzeString(this.select, this.regex, this.flags, block, block2, this.pattern);
        return analyzeString;
    }
}

