/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import net.sf.saxon.PreparedStyleSheet;
import net.sf.saxon.expr.ErrorExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionLocation;
import net.sf.saxon.expr.ExpressionParser;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.instruct.AttributeSet;
import net.sf.saxon.instruct.Block;
import net.sf.saxon.instruct.DeferredError;
import net.sf.saxon.instruct.Instruction;
import net.sf.saxon.instruct.NamespaceContext;
import net.sf.saxon.instruct.SimpleNodeConstructor;
import net.sf.saxon.instruct.Text;
import net.sf.saxon.instruct.WithParam;
import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.Name;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NamespaceException;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.QNameException;
import net.sf.saxon.pattern.LocationPathPattern;
import net.sf.saxon.pattern.NoNodeTest;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.sort.SortKeyDefinition;
import net.sf.saxon.style.AttributeValueTemplate;
import net.sf.saxon.style.ExpressionContext;
import net.sf.saxon.style.Procedure;
import net.sf.saxon.style.StandardNames;
import net.sf.saxon.style.StyleNodeFactory;
import net.sf.saxon.style.XSLAttributeSet;
import net.sf.saxon.style.XSLFallback;
import net.sf.saxon.style.XSLFunction;
import net.sf.saxon.style.XSLGeneralVariable;
import net.sf.saxon.style.XSLSort;
import net.sf.saxon.style.XSLStyleSheet;
import net.sf.saxon.style.XSLTemplate;
import net.sf.saxon.style.XSLVariable;
import net.sf.saxon.style.XSLVariableDeclaration;
import net.sf.saxon.style.XSLWithParam;
import net.sf.saxon.tree.DocumentImpl;
import net.sf.saxon.tree.ElementImpl;
import net.sf.saxon.tree.ElementWithAttributes;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.Type;
import net.sf.saxon.xpath.XPathException;
import org.xml.sax.Locator;

public abstract class StyleElement
extends ElementWithAttributes
implements Locator {
    protected short[] extensionNamespaces = null;
    private short[] excludedNamespaces = null;
    protected Double version = null;
    protected StaticContext staticContext = null;
    protected TransformerConfigurationException validationError = null;
    protected int reportingCircumstances = 1;
    protected String defaultXPathNamespace = null;
    private int lineNumber;
    public static final int REPORT_ALWAYS = 1;
    public static final int REPORT_UNLESS_FORWARDS_COMPATIBLE = 2;
    public static final int REPORT_IF_INSTANTIATED = 3;

    public NamePool getTargetNamePool() {
        return this.getPrincipalStyleSheet().getTargetNamePool();
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public void setLineNumber(int n) {
        this.lineNumber = n;
    }

    public void substituteFor(StyleElement styleElement) {
        this.parent = styleElement.parent;
        this.attributeList = styleElement.attributeList;
        this.namespaceList = styleElement.namespaceList;
        this.nameCode = styleElement.nameCode;
        this.sequence = styleElement.sequence;
        this.extensionNamespaces = styleElement.extensionNamespaces;
        this.excludedNamespaces = styleElement.excludedNamespaces;
        this.version = styleElement.version;
        this.root = styleElement.root;
        this.staticContext = styleElement.staticContext;
        this.validationError = styleElement.validationError;
        this.reportingCircumstances = styleElement.reportingCircumstances;
        this.lineNumber = styleElement.lineNumber;
    }

    protected void setValidationError(TransformerException transformerException, int n) {
        this.validationError = transformerException instanceof TransformerConfigurationException ? (TransformerConfigurationException)transformerException : new TransformerConfigurationException(transformerException);
        this.reportingCircumstances = n;
    }

    public boolean isInstruction() {
        return false;
    }

    protected int getReturnedItemType() {
        return 88;
    }

    protected int getCommonChildItemType() {
        int n = 15;
        AxisIterator axisIterator = this.iterateAxis((byte)3);
        while (axisIterator.hasNext()) {
            NodeInfo nodeInfo = (NodeInfo)axisIterator.next();
            n = nodeInfo instanceof StyleElement ? Type.getCommonSuperType(n, ((StyleElement)nodeInfo).getReturnedItemType()) : Type.getCommonSuperType(n, 3);
            if (n != 88) continue;
            return n;
        }
        return n;
    }

    public void markTailCalls() {
    }

    public boolean mayContainTemplateBody() {
        return false;
    }

    public XSLStyleSheet getContainingStyleSheet() {
        NodeInfo nodeInfo = this;
        while (!(nodeInfo instanceof XSLStyleSheet)) {
            nodeInfo = nodeInfo.getParent();
        }
        return (XSLStyleSheet)nodeInfo;
    }

    public int getPrecedence() {
        return this.getContainingStyleSheet().getPrecedence();
    }

    public final StandardNames getStandardNames() {
        DocumentImpl documentImpl = (DocumentImpl)this.getDocumentRoot();
        return ((StyleNodeFactory)documentImpl.getNodeFactory()).getStandardNames();
    }

    public String getURIForPrefix(String string, boolean bl) throws NamespaceException {
        if (string.equals("") && !bl) {
            return "";
        }
        short s = this.getURICodeForPrefix(string);
        return this.getNamePool().getURIFromURICode(s);
    }

    public final int makeNameCode(String string, boolean bl) throws XPathException, NamespaceException {
        String[] stringArray;
        NamePool namePool = this.getTargetNamePool();
        try {
            stringArray = Name.getQNameParts(string);
        }
        catch (QNameException qNameException) {
            throw new XPathException.Static(qNameException.getMessage());
        }
        String string2 = stringArray[0];
        if (string2.equals("")) {
            short s = 0;
            if (bl) {
                s = this.getURICodeForPrefix(string2);
            }
            return namePool.allocate(string2, s, string);
        }
        String string3 = this.getURIForPrefix(string2, false);
        return namePool.allocate(string2, string3, stringArray[1]);
    }

    public NamespaceContext makeNamespaceContext() {
        int[] nArray = this.getNamespaceCodes();
        int[] nArray2 = new int[nArray.length];
        NamePool namePool = this.getNamePool();
        NamePool namePool2 = this.getTargetNamePool();
        int n = 0;
        while (n < nArray.length) {
            String string = namePool.getPrefixFromNamespaceCode(nArray[n]);
            String string2 = namePool.getURIFromNamespaceCode(nArray[n]);
            nArray2[n] = namePool2.allocateNamespaceCode(string, string2);
            ++n;
        }
        return new NamespaceContext(nArray2);
    }

    public void processAllAttributes() throws TransformerConfigurationException {
        this.staticContext = new ExpressionContext(this);
        this.processAttributes();
        AxisIterator axisIterator = this.iterateAxis((byte)3);
        while (axisIterator.hasNext()) {
            NodeInfo nodeInfo = (NodeInfo)axisIterator.next();
            if (!(nodeInfo instanceof StyleElement)) continue;
            ((StyleElement)nodeInfo).processAllAttributes();
        }
    }

    public final void processAttributes() throws TransformerConfigurationException {
        block3: {
            try {
                this.prepareAttributes();
            }
            catch (TransformerConfigurationException transformerConfigurationException) {
                if (this.forwardsCompatibleModeIsEnabled()) {
                    this.setValidationError(transformerConfigurationException, 3);
                    break block3;
                }
                this.compileError(transformerConfigurationException);
            }
        }
    }

    protected void checkUnknownAttribute(int n) throws TransformerConfigurationException {
        if (this.forwardsCompatibleModeIsEnabled()) {
            return;
        }
        String string = this.getNamePool().getURI(n);
        String string2 = this.getURI();
        int n2 = n & 0xFFFFF;
        StandardNames standardNames = this.getStandardNames();
        if (this.isInstruction() && string.equals("http://www.w3.org/1999/XSL/Transform") && !string2.equals("http://www.w3.org/1999/XSL/Transform") && (n2 == standardNames.XSL_XPATH_DEFAULT_NAMESPACE || n2 == standardNames.XSL_EXTENSION_ELEMENT_PREFIXES || n2 == standardNames.XSL_EXCLUDE_RESULT_PREFIXES || n2 == standardNames.XSL_VERSION)) {
            return;
        }
        if (string2.equals("http://www.w3.org/1999/XSL/Transform") && (n2 == standardNames.XPATH_DEFAULT_NAMESPACE || n2 == standardNames.EXTENSION_ELEMENT_PREFIXES || n2 == standardNames.EXCLUDE_RESULT_PREFIXES || n2 == standardNames.VERSION)) {
            return;
        }
        if (string.equals("") || string.equals("http://www.w3.org/1999/XSL/Transform")) {
            this.compileError("Attribute " + this.getNamePool().getDisplayName(n) + " is not allowed on this element");
        }
    }

    public abstract void prepareAttributes() throws TransformerConfigurationException;

    protected StyleElement getLastChildInstruction() {
        StyleElement styleElement = null;
        AxisIterator axisIterator = this.iterateAxis((byte)3);
        while (axisIterator.hasNext()) {
            NodeInfo nodeInfo = (NodeInfo)axisIterator.next();
            styleElement = nodeInfo instanceof StyleElement ? (StyleElement)nodeInfo : null;
        }
        return styleElement;
    }

    public Expression makeExpression(String string) throws TransformerConfigurationException {
        try {
            return ExpressionTool.make(string, this.staticContext);
        }
        catch (XPathException xPathException) {
            if (!this.forwardsCompatibleModeIsEnabled()) {
                this.compileError(xPathException);
            }
            return new ErrorExpression(xPathException);
        }
    }

    public Pattern makePattern(String string) throws TransformerConfigurationException {
        try {
            return Pattern.make(string, this.staticContext);
        }
        catch (XPathException xPathException) {
            this.compileError(xPathException);
            return NoNodeTest.getInstance();
        }
    }

    public Expression makeAttributeValueTemplate(String string) throws TransformerConfigurationException {
        try {
            return AttributeValueTemplate.make(string, this.staticContext);
        }
        catch (XPathException xPathException) {
            this.compileError(xPathException);
            return new StringValue(string);
        }
    }

    public SequenceType makeSequenceType(String string) throws TransformerConfigurationException {
        if (this.staticContext == null) {
            this.staticContext = new ExpressionContext(this);
        }
        try {
            ExpressionParser expressionParser = new ExpressionParser();
            return expressionParser.parseSequenceType(string, this.staticContext);
        }
        catch (XPathException xPathException) {
            this.compileError(xPathException);
            return SequenceType.ANY_SEQUENCE;
        }
    }

    protected void processExtensionElementAttribute(int n) throws TransformerConfigurationException {
        String string = this.getAttributeValue(n & 0xFFFFF);
        if (string != null) {
            int n2 = 0;
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            while (stringTokenizer.hasMoreTokens()) {
                stringTokenizer.nextToken();
                ++n2;
            }
            this.extensionNamespaces = new short[n2];
            n2 = 0;
            StringTokenizer stringTokenizer2 = new StringTokenizer(string);
            while (stringTokenizer2.hasMoreTokens()) {
                String string2 = stringTokenizer2.nextToken();
                if (string2.equals("#default")) {
                    string2 = "";
                }
                try {
                    short s = this.getURICodeForPrefix(string2);
                    this.extensionNamespaces[n2++] = s;
                }
                catch (NamespaceException namespaceException) {
                    this.extensionNamespaces = null;
                    this.compileError(namespaceException.getMessage());
                }
            }
        }
    }

    protected void processExcludedNamespaces(int n) throws TransformerConfigurationException {
        block10: {
            String string = this.getAttributeValue(n & 0xFFFFF);
            if (string == null) break block10;
            if (string.trim().equals("#all")) {
                int[] nArray = this.getNamespaceCodes();
                this.excludedNamespaces = new short[nArray.length];
                int n2 = 0;
                while (n2 < nArray.length) {
                    this.excludedNamespaces[n2] = (short)(nArray[n2] & 0xFFFF);
                    ++n2;
                }
            } else {
                int n3 = 0;
                StringTokenizer stringTokenizer = new StringTokenizer(string);
                while (stringTokenizer.hasMoreTokens()) {
                    stringTokenizer.nextToken();
                    ++n3;
                }
                this.excludedNamespaces = new short[n3];
                n3 = 0;
                StringTokenizer stringTokenizer2 = new StringTokenizer(string);
                while (stringTokenizer2.hasMoreTokens()) {
                    String string2 = stringTokenizer2.nextToken();
                    if (string2.equals("#default")) {
                        string2 = "";
                    } else if (string2.equals("#all")) {
                        this.compileError("In exclude-result-prefixes, cannot mix #all with other values");
                    }
                    try {
                        short s = this.getURICodeForPrefix(string2);
                        this.excludedNamespaces[n3++] = s;
                    }
                    catch (NamespaceException namespaceException) {
                        this.excludedNamespaces = null;
                        this.compileError(namespaceException.getMessage());
                    }
                }
            }
        }
    }

    protected void processVersionAttribute(int n) throws TransformerConfigurationException {
        String string = this.getAttributeValue(n & 0xFFFFF);
        if (string != null) {
            double d = new DoubleValue(string.trim()).getValue();
            if (Double.isNaN(d)) {
                throw new TransformerConfigurationException("The version attribute must be numeric");
            }
            this.version = new Double(d);
        }
    }

    public double getVersion() {
        if (this.version == null) {
            NodeInfo nodeInfo = (NodeInfo)((Object)this.getParentNode());
            this.version = nodeInfo instanceof StyleElement ? new Double(((StyleElement)nodeInfo).getVersion()) : new Double(1.0);
        }
        return this.version;
    }

    public boolean forwardsCompatibleModeIsEnabled() {
        return this.getVersion() > 2.0;
    }

    public boolean backwardsCompatibleModeIsEnabled() {
        return this.getVersion() == 1.0;
    }

    protected boolean definesExtensionElement(short s) {
        if (this.extensionNamespaces == null) {
            return false;
        }
        int n = 0;
        while (n < this.extensionNamespaces.length) {
            if (this.extensionNamespaces[n] == s) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public boolean isExtensionNamespace(short s) {
        NodeInfo nodeInfo = this;
        while (nodeInfo instanceof StyleElement) {
            if (nodeInfo.definesExtensionElement(s)) {
                return true;
            }
            nodeInfo = nodeInfo.getParent();
        }
        return false;
    }

    protected boolean definesExcludedNamespace(short s) {
        if (this.excludedNamespaces == null) {
            return false;
        }
        int n = 0;
        while (n < this.excludedNamespaces.length) {
            if (this.excludedNamespaces[n] == s) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public boolean isExcludedNamespace(short s) {
        if (s == 2) {
            return true;
        }
        if (this.isExtensionNamespace(s)) {
            return true;
        }
        NodeInfo nodeInfo = this;
        while (nodeInfo instanceof StyleElement) {
            if (nodeInfo.definesExcludedNamespace(s)) {
                return true;
            }
            nodeInfo = nodeInfo.getParent();
        }
        return false;
    }

    protected void processDefaultXPathNamespaceAttribute(int n) throws TransformerConfigurationException {
        String string = this.getAttributeValue(n & 0xFFFFF);
        if (string != null) {
            this.defaultXPathNamespace = string;
        }
    }

    protected short getDefaultXPathNamespace() {
        NodeInfo nodeInfo = this;
        while (nodeInfo instanceof StyleElement) {
            String string = nodeInfo.defaultXPathNamespace;
            if (string != null) {
                return this.getTargetNamePool().allocateCodeForURI(string);
            }
            nodeInfo = nodeInfo.getParent();
        }
        return 0;
    }

    public int getTypeAnnotationCode(String string) throws TransformerConfigurationException {
        if (!Name.isQName(string)) {
            this.compileError("Type name is not a valid QName");
        } else {
            try {
                String[] stringArray = Name.getQNameParts(string);
                String string2 = this.getURIForPrefix(stringArray[0], false);
                return Type.getNamedType(string2, stringArray[1]);
            }
            catch (NamespaceException namespaceException) {
                this.compileError("Namespace prefix for type annotation is undeclared");
            }
            catch (QNameException qNameException) {
                this.compileError("Invalid type name. " + qNameException.getMessage());
            }
            catch (XPathException xPathException) {
                this.compileError(xPathException);
            }
        }
        return 0;
    }

    public void validate() throws TransformerConfigurationException {
    }

    public Expression typeCheck(String string, Expression expression) throws TransformerConfigurationException {
        if (expression == null) {
            return null;
        }
        try {
            expression = expression.analyze(this.staticContext);
            if (this.isExplaining()) {
                System.err.println("Attribute '" + string + "' of element '" + this.getDisplayName() + "' at line " + this.getLineNumber() + ":");
                System.err.println("Static type: " + new SequenceType(expression.getItemType(), 88, expression.getCardinality()));
                System.err.println("Optimized expression tree:");
                expression.display(10);
            }
            this.allocateSlots(expression);
            return expression;
        }
        catch (XPathException.Dynamic dynamic) {
            return new ErrorExpression(dynamic);
        }
        catch (XPathException xPathException) {
            this.compileError(xPathException);
            return expression;
        }
    }

    public void allocateSlots(Expression expression) {
        Procedure procedure = this.getOwningProcedure();
        if (procedure == null || this instanceof XSLTemplate) {
            int n = ExpressionTool.allocateSlots(expression, 0);
            this.getContainingStyleSheet().allocateLocalSlots(n);
        } else {
            int n = procedure.getNumberOfVariables();
            int n2 = ExpressionTool.allocateSlots(expression, n);
            if (n2 > n) {
                this.getContainingStyleSheet().allocateLocalSlots(n2);
                procedure.setNumberOfVariables(n2);
            }
        }
    }

    private boolean isExplaining() {
        StandardNames standardNames = this.getStandardNames();
        String string = this.getAttributeValue(standardNames.SAXON_EXPLAIN);
        return "yes".equals(string);
    }

    public Pattern typeCheck(String string, Pattern pattern) throws TransformerConfigurationException {
        if (pattern == null) {
            return null;
        }
        try {
            return pattern.typeCheck(this.staticContext);
        }
        catch (XPathException.Dynamic dynamic) {
            LocationPathPattern locationPathPattern = new LocationPathPattern();
            locationPathPattern.addFilter(new ErrorExpression(dynamic));
            return locationPathPattern;
        }
        catch (XPathException xPathException) {
            throw new TransformerConfigurationException("Error in " + string + " pattern", xPathException);
        }
    }

    public void fixupReferences() throws TransformerConfigurationException {
        AxisIterator axisIterator = this.iterateAxis((byte)3);
        while (axisIterator.hasNext()) {
            NodeInfo nodeInfo = (NodeInfo)axisIterator.next();
            if (!(nodeInfo instanceof StyleElement)) continue;
            ((StyleElement)nodeInfo).fixupReferences();
        }
    }

    public Procedure getOwningProcedure() {
        NodeInfo nodeInfo = this;
        while (true) {
            NodeInfo nodeInfo2;
            if ((nodeInfo2 = nodeInfo.getParent()) instanceof XSLStyleSheet) {
                if (nodeInfo instanceof XSLTemplate) {
                    return ((XSLTemplate)nodeInfo).getProcedure();
                }
                if (nodeInfo instanceof XSLGeneralVariable) {
                    return ((XSLGeneralVariable)nodeInfo).getProcedure();
                }
                if (nodeInfo instanceof XSLFunction) {
                    return ((XSLFunction)nodeInfo).getProcedure();
                }
                if (nodeInfo instanceof XSLAttributeSet) {
                    return ((XSLAttributeSet)nodeInfo).getProcedure();
                }
                return null;
            }
            nodeInfo = nodeInfo2;
        }
    }

    public void validateSubtree() throws TransformerConfigurationException {
        if (this.validationError != null) {
            if (this.reportingCircumstances == 1) {
                this.compileError(this.validationError);
            } else if (this.reportingCircumstances == 2 && !this.forwardsCompatibleModeIsEnabled()) {
                this.compileError(this.validationError);
            }
        } else {
            try {
                this.validate();
            }
            catch (TransformerConfigurationException transformerConfigurationException) {
                if (this.forwardsCompatibleModeIsEnabled()) {
                    this.setValidationError(transformerConfigurationException, 3);
                }
                this.compileError(transformerConfigurationException);
            }
            this.validateChildren();
        }
    }

    protected void validateChildren() throws TransformerConfigurationException {
        AxisIterator axisIterator = this.iterateAxis((byte)3);
        StyleElement styleElement = null;
        while (axisIterator.hasNext()) {
            NodeInfo nodeInfo = (NodeInfo)axisIterator.next();
            if (!(nodeInfo instanceof StyleElement)) continue;
            ((StyleElement)nodeInfo).validateSubtree();
            styleElement = (StyleElement)nodeInfo;
        }
        if (styleElement instanceof XSLVariable && !(this instanceof XSLStyleSheet)) {
            styleElement.compileWarning("A variable with no following sibling instructions has no effect");
        }
    }

    public void preprocess() throws TransformerConfigurationException {
    }

    protected XSLStyleSheet getPrincipalStyleSheet() {
        XSLStyleSheet xSLStyleSheet = this.getContainingStyleSheet();
        XSLStyleSheet xSLStyleSheet2;
        while ((xSLStyleSheet2 = xSLStyleSheet.getImporter()) != null) {
            xSLStyleSheet = xSLStyleSheet2;
        }
        return xSLStyleSheet;
    }

    public PreparedStyleSheet getPreparedStyleSheet() {
        return this.getPrincipalStyleSheet().getPreparedStyleSheet();
    }

    public void checkWithinTemplate() throws TransformerConfigurationException {
        StyleElement styleElement = (StyleElement)this.getParentNode();
        if (!styleElement.mayContainTemplateBody()) {
            this.compileError("Element must only be used within a template body");
        }
    }

    public void checkTopLevel() throws TransformerConfigurationException {
        if (!(this.getParentNode() instanceof XSLStyleSheet)) {
            this.compileError("Element must only be used at top level of stylesheet");
        }
    }

    public void checkEmpty() throws TransformerConfigurationException {
        if (this.hasChildNodes()) {
            this.compileError("Element must be empty");
        }
    }

    public void reportAbsence(String string) throws TransformerConfigurationException {
        this.compileError("Element must have a \"" + string + "\" attribute");
    }

    public Pattern getContextNodePattern() {
        if (this.isTopLevel()) {
            return new NodeKindTest(9);
        }
        return ((StyleElement)this.getParent()).getContextNodePattern();
    }

    public abstract Instruction compile() throws TransformerConfigurationException;

    public void compileChildren(Instruction instruction) throws TransformerConfigurationException {
        Object object;
        XSLStyleSheet xSLStyleSheet = this.getPrincipalStyleSheet();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        AxisIterator axisIterator = this.iterateAxis((byte)3);
        while (axisIterator.hasNext()) {
            Object object2;
            object = (NodeInfo)axisIterator.next();
            if (object.getItemType() == 3) {
                object2 = new Text(false);
                ((SimpleNodeConstructor)object2).setContent(object.getStringValue());
                arrayList.add(object2);
                continue;
            }
            if (!(object instanceof StyleElement)) continue;
            object2 = (StyleElement)object;
            if (((StyleElement)object2).validationError != null) {
                this.fallbackProcessing((StyleElement)object2, arrayList);
                continue;
            }
            Instruction instruction2 = ((StyleElement)object2).compile();
            if (instruction2 == null) continue;
            if (instruction2 instanceof Block) {
                Instruction[] instructionArray = instruction2.getChildren();
                int n = 0;
                while (n < instructionArray.length) {
                    arrayList.add(instructionArray[n]);
                    ++n;
                }
                continue;
            }
            arrayList.add(instruction2);
            instruction2.setSourceLocation(xSLStyleSheet.putModuleNumber(((ElementImpl)object2).getSystemId()), ((StyleElement)object2).getLineNumber());
        }
        object = new Instruction[arrayList.size()];
        int n = 0;
        while (n < arrayList.size()) {
            object[n] = (Instruction)arrayList.get(n);
            ++n;
        }
        instruction.setChildren((Instruction[])object);
    }

    protected void fallbackProcessing(StyleElement styleElement, List list) throws TransformerConfigurationException {
        boolean bl = false;
        AxisIterator axisIterator = styleElement.iterateAxis((byte)3);
        while (axisIterator.hasNext()) {
            NodeInfo nodeInfo = (NodeInfo)axisIterator.next();
            if (!(nodeInfo instanceof XSLFallback)) continue;
            bl = true;
            XSLStyleSheet xSLStyleSheet = this.getPrincipalStyleSheet();
            Block block = new Block();
            block.setSourceLocation(xSLStyleSheet.putModuleNumber(nodeInfo.getSystemId()), nodeInfo.getLineNumber());
            block.setInstructionName((byte)2);
            ((XSLFallback)nodeInfo).compileChildren(block);
            list.add(block);
        }
        if (!bl) {
            list.add(new DeferredError(styleElement.validationError, styleElement.getDisplayName()));
        }
    }

    protected SortKeyDefinition[] makeSortKeys() {
        int n = 0;
        AxisIterator axisIterator = this.iterateAxis((byte)3);
        while (axisIterator.hasNext()) {
            if (!(axisIterator.next() instanceof XSLSort)) continue;
            ++n;
        }
        if (n > 0) {
            SortKeyDefinition[] sortKeyDefinitionArray = new SortKeyDefinition[n];
            axisIterator = this.iterateAxis((byte)3);
            int n2 = 0;
            while (axisIterator.hasNext()) {
                NodeInfo nodeInfo = (NodeInfo)axisIterator.next();
                if (!(nodeInfo instanceof XSLSort)) continue;
                sortKeyDefinitionArray[n2++] = ((XSLSort)nodeInfo).getSortKeyDefinition();
            }
            return sortKeyDefinitionArray;
        }
        return null;
    }

    protected AttributeSet[] getAttributeSets(String string, List arrayList) throws TransformerConfigurationException {
        int n;
        AttributeSet[] attributeSetArray;
        if (arrayList == null) {
            arrayList = new ArrayList<XSLAttributeSet>();
        }
        XSLStyleSheet xSLStyleSheet = this.getPrincipalStyleSheet();
        List list = xSLStyleSheet.getTopLevel();
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        while (stringTokenizer.hasMoreTokens()) {
            attributeSetArray = stringTokenizer.nextToken();
            try {
                n = this.makeNameCode((String)attributeSetArray, false) & 0xFFFFF;
            }
            catch (NamespaceException namespaceException) {
                this.compileError(namespaceException.getMessage());
                n = -1;
            }
            catch (XPathException xPathException) {
                this.compileError(xPathException.getMessage());
                n = -1;
            }
            boolean bl = false;
            int n2 = 0;
            while (n2 < list.size()) {
                XSLAttributeSet xSLAttributeSet;
                if (list.get(n2) instanceof XSLAttributeSet && (xSLAttributeSet = (XSLAttributeSet)list.get(n2)).getAttributeSetFingerprint() == n) {
                    arrayList.add(xSLAttributeSet);
                    bl = true;
                }
                ++n2;
            }
            if (bl) continue;
            this.compileError("No attribute-set exists named " + (String)attributeSetArray);
        }
        attributeSetArray = new AttributeSet[arrayList.size()];
        n = 0;
        while (n < arrayList.size()) {
            XSLAttributeSet xSLAttributeSet = (XSLAttributeSet)arrayList.get(n);
            xSLAttributeSet.incrementReferenceCount();
            attributeSetArray[n] = xSLAttributeSet.getInstruction();
            ++n;
        }
        return attributeSetArray;
    }

    protected WithParam[] getWithParamInstructions() throws TransformerConfigurationException {
        int n = 0;
        AxisIterator axisIterator = this.iterateAxis((byte)3);
        while (axisIterator.hasNext()) {
            if (!(axisIterator.next() instanceof XSLWithParam)) continue;
            ++n;
        }
        WithParam[] withParamArray = new WithParam[n];
        n = 0;
        axisIterator = this.iterateAxis((byte)3);
        while (axisIterator.hasNext()) {
            NodeInfo nodeInfo = (NodeInfo)axisIterator.next();
            if (!(nodeInfo instanceof XSLWithParam)) continue;
            WithParam withParam = (WithParam)((XSLWithParam)nodeInfo).compile();
            withParamArray[n++] = withParam;
        }
        return withParamArray;
    }

    protected void compileError(TransformerException transformerException) throws TransformerConfigurationException {
        if (transformerException.getLocator() == null || transformerException.getLocator() instanceof ExpressionLocation) {
            transformerException.setLocator(this);
        }
        PreparedStyleSheet preparedStyleSheet = this.getPreparedStyleSheet();
        try {
            if (preparedStyleSheet == null) {
                throw transformerException;
            }
            preparedStyleSheet.reportError(transformerException);
        }
        catch (TransformerException transformerException2) {
            if (transformerException2 instanceof TransformerConfigurationException) {
                throw (TransformerConfigurationException)transformerException2;
            }
            if (transformerException2.getException() instanceof TransformerConfigurationException) {
                throw (TransformerConfigurationException)transformerException2.getException();
            }
            TransformerConfigurationException transformerConfigurationException = new TransformerConfigurationException(transformerException);
            transformerConfigurationException.setLocator(this);
            throw transformerConfigurationException;
        }
    }

    protected void compileError(String string) throws TransformerConfigurationException {
        TransformerConfigurationException transformerConfigurationException = new TransformerConfigurationException(string);
        transformerConfigurationException.setLocator(this);
        this.compileError(transformerConfigurationException);
    }

    protected void compileWarning(String string) throws TransformerConfigurationException {
        TransformerConfigurationException transformerConfigurationException = new TransformerConfigurationException(string);
        transformerConfigurationException.setLocator(this);
        PreparedStyleSheet preparedStyleSheet = this.getPreparedStyleSheet();
        if (preparedStyleSheet != null) {
            preparedStyleSheet.reportWarning(transformerConfigurationException);
        }
    }

    protected void issueWarning(TransformerException transformerException) {
        PreparedStyleSheet preparedStyleSheet;
        if (transformerException.getLocator() == null) {
            transformerException.setLocator(this);
        }
        if ((preparedStyleSheet = this.getPreparedStyleSheet()) != null) {
            preparedStyleSheet.reportWarning(transformerException);
        }
    }

    protected void issueWarning(String string) {
        TransformerConfigurationException transformerConfigurationException = new TransformerConfigurationException(string);
        transformerConfigurationException.setLocator(this);
        this.issueWarning(transformerConfigurationException);
    }

    public boolean isTopLevel() {
        return this.getParentNode() instanceof XSLStyleSheet;
    }

    public XSLVariableDeclaration bindVariable(int n) throws XPathException {
        XSLVariableDeclaration xSLVariableDeclaration = this.getVariableBinding(n);
        if (xSLVariableDeclaration == null) {
            throw new XPathException.Static("Variable " + this.getTargetNamePool().getDisplayName(n) + " has not been declared");
        }
        return xSLVariableDeclaration;
    }

    public XSLVariableDeclaration getVariableBinding(int n) {
        XSLVariableDeclaration xSLVariableDeclaration;
        Object object;
        block3: {
            NodeInfo nodeInfo = this;
            NodeInfo nodeInfo2 = this;
            if (!this.isTopLevel()) {
                object = nodeInfo.iterateAxis((byte)11);
                do {
                    nodeInfo = object.hasNext() ? (NodeInfo)object.next() : null;
                    while (nodeInfo == null) {
                        nodeInfo = nodeInfo2.getParent();
                        nodeInfo2 = nodeInfo;
                        if (nodeInfo.getParent() instanceof XSLStyleSheet) break;
                        object = nodeInfo.iterateAxis((byte)11);
                        nodeInfo = object.hasNext() ? (NodeInfo)object.next() : null;
                    }
                    if (nodeInfo.getParent() instanceof XSLStyleSheet) break block3;
                } while (!(nodeInfo instanceof XSLVariableDeclaration) || (xSLVariableDeclaration = (XSLVariableDeclaration)nodeInfo).getVariableFingerprint() != n);
                return xSLVariableDeclaration;
            }
        }
        object = this.getPrincipalStyleSheet();
        xSLVariableDeclaration = ((XSLStyleSheet)object).getGlobalVariable(n);
        return xSLVariableDeclaration;
    }

    public XSLFunction getStyleSheetFunction(int n, int n2) {
        XSLStyleSheet xSLStyleSheet = this.getPrincipalStyleSheet();
        List list = xSLStyleSheet.getTopLevel();
        int n3 = list.size() - 1;
        while (n3 >= 0) {
            Object e = list.get(n3);
            if (e instanceof XSLFunction && ((XSLFunction)e).getFunctionFingerprint() == n && (n2 == -1 || ((XSLFunction)e).getNumberOfArguments() == n2)) {
                XSLFunction xSLFunction = (XSLFunction)e;
                return xSLFunction;
            }
            --n3;
        }
        return null;
    }
}

