/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.StringTokenizer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import net.sf.saxon.Loader;
import net.sf.saxon.instruct.Instruction;
import net.sf.saxon.om.NamespaceException;
import net.sf.saxon.style.StandardNames;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.tree.AttributeCollection;

public class SAXONScript
extends StyleElement {
    private Class javaClass = null;
    private String implementsURI = null;
    private String language = null;

    public void prepareAttributes() throws TransformerConfigurationException {
        int n;
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        StandardNames standardNames = this.getStandardNames();
        AttributeCollection attributeCollection = this.getAttributeList();
        int n2 = 0;
        while (n2 < attributeCollection.getLength()) {
            n = attributeCollection.getNameCode(n2);
            int n3 = n & 0xFFFFF;
            if (n3 == standardNames.LANGUAGE) {
                string = attributeCollection.getValue(n2).trim();
            } else if (n3 == standardNames.IMPLEMENTS_PREFIX) {
                string2 = attributeCollection.getValue(n2).trim();
            } else if (n3 == standardNames.SRC) {
                string3 = attributeCollection.getValue(n2).trim();
            } else if (n3 == standardNames.ARCHIVE) {
                string4 = attributeCollection.getValue(n2).trim();
            } else {
                this.checkUnknownAttribute(n);
            }
            ++n2;
        }
        if (string2 == null) {
            this.reportAbsence("implements-prefix");
            return;
        }
        try {
            n = this.getURICodeForPrefix(string2);
            this.implementsURI = this.getNamePool().getURIFromURICode((short)n);
        }
        catch (NamespaceException namespaceException) {
            this.compileError(namespaceException.getMessage());
        }
        if (string == null) {
            this.reportAbsence("language");
            return;
        }
        this.language = string;
        if (this.language.equals("java")) {
            URL uRL;
            if (string3 == null) {
                this.compileError("For java, the src attribute is mandatory");
                return;
            }
            if (!string3.startsWith("java:")) {
                this.compileError("The src attribute must be a URI of the form java:full.class.Name");
                return;
            }
            String string5 = string3.substring(5);
            if (string4 == null) {
                try {
                    this.javaClass = Loader.getClass(string5);
                }
                catch (TransformerException transformerException) {
                    this.compileError(transformerException);
                    return;
                }
            }
            try {
                uRL = new URL(this.getBaseURI());
            }
            catch (MalformedURLException malformedURLException) {
                this.compileError("Invalid base URI " + this.getBaseURI());
                return;
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string4);
            int n4 = 0;
            while (stringTokenizer.hasMoreTokens()) {
                ++n4;
                stringTokenizer.nextToken();
            }
            URL[] uRLArray = new URL[n4];
            n4 = 0;
            stringTokenizer = new StringTokenizer(string4);
            while (stringTokenizer.hasMoreTokens()) {
                String string6 = stringTokenizer.nextToken();
                try {
                    uRLArray[n4++] = new URL(uRL, string6);
                }
                catch (MalformedURLException malformedURLException) {
                    this.compileError("Invalid URL " + string6);
                    return;
                }
            }
            try {
                this.javaClass = new URLClassLoader(uRLArray).loadClass(string5);
            }
            catch (ClassNotFoundException classNotFoundException) {
                this.compileError("Cannot find class " + string5 + " in the specified archive" + (n4 > 1 ? "s" : ""));
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                this.compileError("Cannot use the archive attribute with this Java VM");
            }
        } else {
            this.compileError("The only language supported for Saxon extension functions is 'java'");
        }
    }

    public void validate() throws TransformerConfigurationException {
        this.checkTopLevel();
    }

    public Instruction compile() throws TransformerConfigurationException {
        return null;
    }

    public Class getJavaClass(String string) {
        if (this.language == null) {
            try {
                this.prepareAttributes();
            }
            catch (TransformerConfigurationException transformerConfigurationException) {
                return null;
            }
        }
        if (this.language.equals("java") && this.implementsURI.equals(string)) {
            return this.javaClass;
        }
        return null;
    }
}

