/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import net.sf.saxon.PreparedStyleSheet;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.instruct.AttributeSet;
import net.sf.saxon.instruct.Instruction;
import net.sf.saxon.instruct.LiteralElement;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.style.StandardNames;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.style.XSLStyleSheet;
import net.sf.saxon.tree.DocumentImpl;
import net.sf.saxon.tree.TreeBuilder;
import net.sf.saxon.value.StringValue;

public class LiteralResultElement
extends StyleElement {
    private int resultNameCode;
    private int[] attributeNames;
    private Expression[] attributeValues;
    private boolean[] attributeChecked;
    private int numberOfAttributes;
    private boolean toplevel;
    private int[] namespaceCodes;
    private AttributeSet[] attributeSets;
    private int annotation = 0;

    public boolean mayContainTemplateBody() {
        return true;
    }

    public void prepareAttributes() throws TransformerConfigurationException {
        int n = this.attributeList.getLength();
        if (n == 0) {
            this.numberOfAttributes = 0;
        } else {
            NamePool namePool = this.getNamePool();
            this.attributeNames = new int[n];
            this.attributeValues = new Expression[n];
            this.attributeChecked = new boolean[n];
            this.numberOfAttributes = 0;
            int n2 = 0;
            while (n2 < n) {
                int n3 = this.attributeList.getNameCode(n2);
                short s = namePool.getURICode(n3);
                if (s == 2) {
                    int n4 = n3 & 0xFFFFF;
                    StandardNames standardNames = this.getStandardNames();
                    if (n4 != standardNames.XSL_USE_ATTRIBUTE_SETS && n4 != standardNames.XSL_EXTENSION_ELEMENT_PREFIXES && n4 != standardNames.XSL_EXCLUDE_RESULT_PREFIXES && n4 != standardNames.XSL_VERSION && n4 != standardNames.XSL_XPATH_DEFAULT_NAMESPACE && n4 != standardNames.XSL_TYPE && n4 != standardNames.XSL_VALIDATION) {
                        this.compileError("Unknown XSL attribute " + namePool.getDisplayName(n3));
                    }
                } else {
                    Expression expression;
                    this.attributeNames[this.numberOfAttributes] = n3;
                    this.attributeValues[this.numberOfAttributes] = expression = this.makeAttributeValueTemplate(this.attributeList.getValue(n2));
                    this.attributeChecked[this.numberOfAttributes] = false;
                    boolean bl = false;
                    if (expression instanceof StringValue) {
                        String string = ((StringValue)expression).getStringValue();
                        int n5 = 0;
                        while (n5 < string.length()) {
                            char c = string.charAt(n5);
                            if (c < '!' || c > '~' || c == '<' || c == '>' || c == '&' || c == '\"') {
                                bl = true;
                                break;
                            }
                            ++n5;
                        }
                        this.attributeChecked[this.numberOfAttributes] = !bl;
                    }
                    ++this.numberOfAttributes;
                }
                ++n2;
            }
            if (this.numberOfAttributes < this.attributeNames.length) {
                int[] nArray = new int[this.numberOfAttributes];
                System.arraycopy(this.attributeNames, 0, nArray, 0, this.numberOfAttributes);
                this.attributeNames = nArray;
                Expression[] expressionArray = new Expression[this.numberOfAttributes];
                System.arraycopy(this.attributeValues, 0, expressionArray, 0, this.numberOfAttributes);
                this.attributeValues = expressionArray;
                boolean[] blArray = new boolean[this.numberOfAttributes];
                System.arraycopy(this.attributeChecked, 0, blArray, 0, this.numberOfAttributes);
                this.attributeChecked = blArray;
            }
        }
    }

    public void validate() throws TransformerConfigurationException {
        this.toplevel = this.getParentNode() instanceof XSLStyleSheet;
        StandardNames standardNames = this.getStandardNames();
        this.resultNameCode = this.getNameCode();
        NamePool namePool = this.getNamePool();
        short s = namePool.getURICode(this.resultNameCode);
        if (this.toplevel) {
            if (s == 0) {
                this.compileError("Top level elements must have a non-null namespace URI");
            }
        } else {
            short s2;
            int n;
            int n2;
            int n3;
            String string;
            String string2;
            String string3;
            boolean bl = false;
            if (this.getParent() instanceof LiteralResultElement && (this.namespaceList == null || this.namespaceList.length == 0) && s == namePool.getURICode(this.getParent().getFingerprint())) {
                bl = true;
            }
            if (bl) {
                int n4 = 0;
                while (n4 < this.attributeList.getLength()) {
                    if ((this.attributeList.getNameCode(n4) >> 20 & 0xFF) != 0) {
                        bl = false;
                        break;
                    }
                    ++n4;
                }
            }
            this.namespaceCodes = bl ? new int[0] : this.getNamespaceCodes();
            XSLStyleSheet xSLStyleSheet = this.getPrincipalStyleSheet();
            if (xSLStyleSheet.hasNamespaceAliases()) {
                int n5;
                int n6 = 0;
                while (n6 < this.namespaceCodes.length) {
                    n5 = (short)(this.namespaceCodes[n6] & 0xFFFF);
                    int n7 = xSLStyleSheet.getNamespaceAlias((short)n5);
                    if (n7 != -1 && (n7 & 0xFFFF) != n5) {
                        this.namespaceCodes[n6] = n7;
                    }
                    ++n6;
                }
                n5 = xSLStyleSheet.getNamespaceAlias(s);
                if ((n5 & 0xFFFF) != s) {
                    s = (short)(n5 & 0xFFFF);
                    this.resultNameCode = namePool.allocate(namePool.getPrefixFromNamespaceCode(n5), namePool.getURIFromNamespaceCode(n5), this.getLocalName());
                }
            }
            if ((string3 = this.getAttributeValue(standardNames.XSL_USE_ATTRIBUTE_SETS)) != null) {
                this.attributeSets = this.getAttributeSets(string3, null);
            }
            if ((string2 = this.getAttributeValue(standardNames.XSL_TYPE)) != null) {
                this.annotation = this.getTypeAnnotationCode(string2);
            }
            if ((string = this.getAttributeValue(standardNames.XSL_VALIDATION)) != null) {
                this.compileError("xsl:validation attribute is not yet supported");
            }
            short[] sArray = new short[this.numberOfAttributes];
            if (this.numberOfAttributes > 0) {
                n3 = 0;
                while (n3 < this.numberOfAttributes) {
                    int n8;
                    n = n2 = this.attributeNames[n3];
                    s2 = namePool.getURICode(n2);
                    if (s2 != 0 && ((n8 = xSLStyleSheet.getNamespaceAlias(s2)) & 0xFFFF) != s2) {
                        s2 = (short)(n8 & 0xFFFF);
                        n = namePool.allocate(namePool.getPrefixFromNamespaceCode(n8), namePool.getURIFromNamespaceCode(n8), this.attributeList.getLocalName(n3));
                    }
                    this.attributeNames[n3] = this.translate(n);
                    sArray[n3] = s2;
                    this.attributeValues[n3] = this.typeCheck(namePool.getDisplayName(n), this.attributeValues[n3]);
                    ++n3;
                }
            }
            n3 = 0;
            n2 = 0;
            while (n2 < this.namespaceCodes.length) {
                n = (short)(this.namespaceCodes[n2] & 0xFFFF);
                if (this.isExcludedNamespace((short)n) && (s2 = 1) != 0) {
                    this.namespaceCodes[n2] = -1;
                    ++n3;
                }
                ++n2;
            }
            n = this.namespaceCodes.length - n3;
            NamePool namePool2 = this.getNamePool();
            NamePool namePool3 = this.getTargetNamePool();
            int[] nArray = new int[n];
            n = 0;
            int n9 = 0;
            while (n9 < this.namespaceCodes.length) {
                if (this.namespaceCodes[n9] != -1) {
                    String string4 = namePool2.getPrefixFromNamespaceCode(this.namespaceCodes[n9]);
                    String string5 = namePool2.getURIFromNamespaceCode(this.namespaceCodes[n9]);
                    nArray[n++] = namePool3.allocateNamespaceCode(string4, string5);
                }
                ++n9;
            }
            this.namespaceCodes = nArray;
        }
    }

    protected void validateChildren() throws TransformerConfigurationException {
        if (!this.toplevel) {
            super.validateChildren();
        }
    }

    private int translate(int n) {
        NamePool namePool = this.getNamePool();
        NamePool namePool2 = this.getTargetNamePool();
        String string = namePool.getPrefix(n);
        String string2 = namePool.getURI(n);
        String string3 = namePool.getLocalName(n);
        return namePool2.allocate(string, string2, string3);
    }

    public Instruction compile() throws TransformerConfigurationException {
        if (this.toplevel) {
            return null;
        }
        LiteralElement literalElement = new LiteralElement(this.translate(this.resultNameCode), this.attributeNames, this.attributeValues, this.attributeChecked, this.attributeSets, this.namespaceCodes, this.annotation);
        this.compileChildren(literalElement);
        return literalElement;
    }

    public DocumentImpl makeStyleSheet(PreparedStyleSheet preparedStyleSheet) throws TransformerConfigurationException {
        NamePool namePool = this.getNamePool();
        StandardNames standardNames = this.getStandardNames();
        String string = this.getPrefixForURI("http://www.w3.org/1999/XSL/Transform");
        if (string == null) {
            String string2 = this.getLocalName().equals("stylesheet") || this.getLocalName().equals("transform") ? (this.getPrefixForURI("http://www.w3.org/TR/WD-xsl") != null ? "Saxon is not able to process Microsoft's WD-xsl dialect" : "Namespace for stylesheet element should be http://www.w3.org/1999/XSL/Transform") : "The supplied file does not appear to be a stylesheet";
            TransformerConfigurationException transformerConfigurationException = new TransformerConfigurationException(string2);
            try {
                preparedStyleSheet.reportError(transformerConfigurationException);
            }
            catch (TransformerException transformerException) {
                // empty catch block
            }
            throw transformerConfigurationException;
        }
        String string3 = this.getAttributeValue(standardNames.XSL_VERSION);
        if (string3 == null) {
            TransformerConfigurationException transformerConfigurationException = new TransformerConfigurationException("Literal Result Element As Stylesheet: xsl:version attribute is missing");
            try {
                preparedStyleSheet.reportError(transformerConfigurationException);
            }
            catch (TransformerException transformerException) {
                // empty catch block
            }
            throw transformerConfigurationException;
        }
        try {
            TreeBuilder treeBuilder = new TreeBuilder();
            treeBuilder.setDocumentLocator(null);
            treeBuilder.setNamePool(namePool);
            treeBuilder.setNodeFactory(((DocumentImpl)this.getParentNode()).getNodeFactory());
            treeBuilder.setSystemId(this.getSystemId());
            treeBuilder.startDocument();
            int n = namePool.allocate("xsl", "http://www.w3.org/1999/XSL/Transform", "stylesheet");
            treeBuilder.startElement(n, 0, 0);
            treeBuilder.namespace(namePool.getNamespaceCode("xsl", "http://www.w3.org/1999/XSL/Transform"), 0);
            treeBuilder.attribute(namePool.allocate("", "", "version"), 0, string3, 0);
            treeBuilder.startContent();
            int n2 = namePool.allocate("xsl", "http://www.w3.org/1999/XSL/Transform", "template");
            treeBuilder.startElement(n2, 0, 0);
            treeBuilder.attribute(namePool.allocate("", "", "match"), 0, "/", 0);
            treeBuilder.startContent();
            treeBuilder.graftElement(this);
            treeBuilder.endElement();
            treeBuilder.endElement();
            treeBuilder.endDocument();
            return (DocumentImpl)treeBuilder.getCurrentDocument();
        }
        catch (TransformerException transformerException) {
            throw new TransformerConfigurationException(transformerException);
        }
    }
}

