/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import net.sf.saxon.expr.AtomicSequenceConverter;
import net.sf.saxon.expr.Atomizer;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.FunctionCall;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.functions.Concat;
import net.sf.saxon.functions.StringJoin;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.xpath.XPathException;

public abstract class AttributeValueTemplate {
    private AttributeValueTemplate() {
    }

    public static Expression make(String string, StaticContext staticContext) throws XPathException {
        Object object;
        Object object2;
        if (string.indexOf("{") < 0 && string.indexOf("}") < 0) {
            return new StringValue(string);
        }
        int n = 0;
        Expression[] expressionArray = new Expression[string.length()];
        char c = ' ';
        int n2 = 0;
        int n3 = string.length();
        while (n2 < n3) {
            int n4 = string.indexOf("{", n2);
            int n5 = string.indexOf("{{", n2);
            int n6 = string.indexOf("}", n2);
            int n7 = string.indexOf("}}", n2);
            if (n6 >= 0 && (n4 < 0 || n6 < n4)) {
                if (n6 != n7) {
                    throw new XPathException.Static("Closing curly brace in attribute value template \"" + string + "\" must be doubled");
                }
                expressionArray[n++] = new StringValue(string.substring(n2, n6 + 1));
                n2 = n6 + 2;
                continue;
            }
            if (n5 >= 0 && n5 == n4) {
                expressionArray[n++] = new StringValue(string.substring(n2, n5 + 1));
                n2 = n5 + 2;
                continue;
            }
            if (n4 >= 0) {
                if (n4 > n2) {
                    expressionArray[n++] = new StringValue(string.substring(n2, n4));
                }
                int n8 = n4 + 1;
                while (n8 < n3) {
                    if (string.charAt(n8) == '\"') {
                        c = '\"';
                    }
                    if (string.charAt(n8) == '\'') {
                        c = '\'';
                    }
                    if (c != ' ') {
                        ++n8;
                        while (n8 < n3 && string.charAt(n8) != c) {
                            ++n8;
                        }
                        c = ' ';
                    } else if (string.charAt(n8) == '}') break;
                    ++n8;
                }
                if (n8 >= n3) {
                    throw new XPathException.Static("No closing \"}\" in attribute value template " + string);
                }
                object2 = string.substring(n4 + 1, n8);
                object = AttributeValueTemplate.makeStringJoin((String)object2, staticContext);
                expressionArray[n++] = object;
                n2 = n8 + 1;
                continue;
            }
            expressionArray[n++] = new StringValue(string.substring(n2));
            n2 = n3;
        }
        if (n == 0) {
            return StringValue.EMPTY_STRING;
        }
        if (n == 1) {
            return expressionArray[0].simplify();
        }
        object2 = (Concat)SystemFunction.makeSystemFunction("concat");
        object = new Expression[n];
        System.arraycopy(expressionArray, 0, object, 0, n);
        ((FunctionCall)object2).setArguments((Expression[])object);
        return ((FunctionCall)object2).simplify();
    }

    private static Expression makeStringJoin(String string, StaticContext staticContext) throws XPathException {
        Expression expression = ExpressionTool.make(string, staticContext);
        expression = new Atomizer(expression);
        expression = new AtomicSequenceConverter(expression, 101);
        StringJoin stringJoin = (StringJoin)SystemFunction.makeSystemFunction("string-join");
        Expression[] expressionArray = new Expression[]{expression, new StringValue(" ")};
        stringJoin.setArguments(expressionArray);
        return stringJoin;
    }
}

