/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.sort;

import java.io.Serializable;
import java.util.Comparator;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.sort.FixedSortKeyDefinition;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.xpath.XPathException;

public class SortKeyDefinition
implements Serializable {
    private static StringValue defaultOrder = new StringValue("ascending");
    private static StringValue defaultCaseOrder = new StringValue("#default");
    private static StringValue defaultLanguage = StringValue.EMPTY_STRING;
    protected Expression sortKey;
    protected Expression order = defaultOrder;
    protected Expression dataTypeExpression = EmptySequence.getInstance();
    protected Expression caseOrder = defaultCaseOrder;
    protected Expression language = defaultLanguage;
    protected Comparator collation;
    protected boolean emptyFirst = true;

    public void setSortKey(Expression expression) {
        this.sortKey = expression;
    }

    public Expression getSortKey() {
        return this.sortKey;
    }

    public void setOrder(Expression expression) {
        this.order = expression;
    }

    public void setDataTypeExpression(Expression expression) {
        this.dataTypeExpression = expression;
    }

    public void setCaseOrder(Expression expression) {
        this.caseOrder = expression;
    }

    public void setLanguage(Expression expression) {
        this.language = expression;
    }

    public void setCollation(Comparator comparator) {
        this.collation = comparator;
    }

    public void setEmptyFirst(boolean bl) {
        this.emptyFirst = bl;
    }

    public SortKeyDefinition simplify() throws XPathException {
        if (this.order instanceof StringValue && this.dataTypeExpression == null && this.caseOrder instanceof StringValue && this.language instanceof StringValue) {
            FixedSortKeyDefinition fixedSortKeyDefinition = new FixedSortKeyDefinition();
            fixedSortKeyDefinition.setSortKey(this.sortKey);
            fixedSortKeyDefinition.setOrder(this.order);
            fixedSortKeyDefinition.setDataTypeExpression(this.dataTypeExpression);
            fixedSortKeyDefinition.setCaseOrder(this.caseOrder);
            fixedSortKeyDefinition.setLanguage(this.language);
            return fixedSortKeyDefinition.simplify();
        }
        return this;
    }

    public int getDependencies() {
        int n = this.sortKey.getDependencies() & 0x21;
        n |= this.order.getDependencies();
        if (this.dataTypeExpression != null) {
            n |= this.dataTypeExpression.getDependencies();
        }
        n |= this.caseOrder.getDependencies();
        return n |= this.language.getDependencies();
    }

    public FixedSortKeyDefinition reduce(XPathContext xPathContext) throws XPathException {
        FixedSortKeyDefinition fixedSortKeyDefinition = new FixedSortKeyDefinition();
        Expression expression = this.sortKey;
        fixedSortKeyDefinition.setSortKey(expression);
        fixedSortKeyDefinition.setOrder((StringValue)this.order.evaluateItem(xPathContext));
        fixedSortKeyDefinition.setDataTypeExpression((StringValue)this.dataTypeExpression.evaluateItem(xPathContext));
        fixedSortKeyDefinition.setCaseOrder((StringValue)this.caseOrder.evaluateItem(xPathContext));
        fixedSortKeyDefinition.setLanguage((StringValue)this.language.evaluateItem(xPathContext));
        fixedSortKeyDefinition.setCollation(this.collation);
        return (FixedSortKeyDefinition)fixedSortKeyDefinition.simplify();
    }
}

