/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.sort;

import java.util.ArrayList;
import java.util.List;
import net.sf.saxon.Controller;
import net.sf.saxon.om.ArrayListIterator;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.sort.GroupIterator;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.xpath.XPathException;

public class GroupEndingIterator
implements GroupIterator {
    private SequenceIterator population;
    private Pattern endPattern;
    private Controller controller;
    private List currentMembers;
    private Item next = null;
    private Item current = null;
    private int position = 0;

    public GroupEndingIterator(SequenceIterator sequenceIterator, Pattern pattern, Controller controller) throws XPathException {
        this.population = sequenceIterator;
        this.endPattern = pattern;
        this.controller = controller;
        if (sequenceIterator.hasNext()) {
            this.next = sequenceIterator.next();
        }
    }

    private void advance() throws XPathException {
        this.currentMembers = new ArrayList();
        this.currentMembers.add(this.current);
        this.next = this.current;
        while (this.next != null) {
            if (this.endPattern.matches((NodeInfo)this.next, this.controller)) {
                if (this.population.hasNext()) {
                    this.next = this.population.next();
                    break;
                }
                this.next = null;
                continue;
            }
            if (this.population.hasNext()) {
                this.next = this.population.next();
                this.currentMembers.add(this.next);
                continue;
            }
            this.next = null;
        }
    }

    public AtomicValue getCurrentGroupingKey() {
        return null;
    }

    public SequenceIterator iterateCurrentGroup() {
        return new ArrayListIterator(this.currentMembers);
    }

    public boolean hasNext() throws XPathException {
        return this.next != null;
    }

    public Item next() throws XPathException {
        this.current = this.next;
        ++this.position;
        this.advance();
        return this.current;
    }

    public Item current() {
        return this.current;
    }

    public int position() {
        return this.position;
    }

    public SequenceIterator getAnother() throws XPathException {
        return new GroupEndingIterator(this.population, this.endPattern, this.controller);
    }
}

