/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.sort;

import java.text.Collator;
import java.util.ArrayList;
import java.util.List;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.ArrayListIterator;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.sort.AtomicSortComparer;
import net.sf.saxon.sort.GroupIterator;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Type;
import net.sf.saxon.xpath.XPathException;

public class GroupAdjacentIterator
implements GroupIterator {
    private SequenceIterator population;
    private Expression keyExpression;
    private Collator collator;
    private AtomicSortComparer comparer;
    private XPathContext keyContext;
    private AtomicValue currentKey = null;
    private List currentMembers;
    private AtomicValue nextKey = null;
    private Item next = null;
    private Item current = null;
    private int position = 0;

    public GroupAdjacentIterator(SequenceIterator sequenceIterator, Expression expression, XPathContext xPathContext, Collator collator) throws XPathException {
        this.population = sequenceIterator;
        this.keyExpression = expression;
        this.keyContext = xPathContext;
        this.collator = collator;
        this.comparer = new AtomicSortComparer(collator);
        if (sequenceIterator.hasNext()) {
            this.next = sequenceIterator.next();
            this.nextKey = (AtomicValue)expression.evaluateItem(xPathContext);
        }
    }

    private void advance() throws XPathException {
        this.currentMembers = new ArrayList();
        this.currentMembers.add(this.current);
        while (this.population.hasNext()) {
            Item item = this.population.next();
            AtomicValue atomicValue = (AtomicValue)this.keyExpression.evaluateItem(this.keyContext);
            try {
                if (this.comparer.comparesEqual(this.currentKey, atomicValue)) {
                    this.currentMembers.add(item);
                    continue;
                }
                this.next = item;
                this.nextKey = atomicValue;
                return;
            }
            catch (ClassCastException classCastException) {
                throw new XPathException.Type("Grouping key values are of non-comparable types (" + Type.getTypeName(this.currentKey.getItemType()) + " and " + Type.getTypeName(atomicValue.getItemType()) + ")");
            }
        }
        this.next = null;
        this.nextKey = null;
    }

    public AtomicValue getCurrentGroupingKey() {
        return this.currentKey;
    }

    public SequenceIterator iterateCurrentGroup() {
        return new ArrayListIterator(this.currentMembers);
    }

    public boolean hasNext() throws XPathException {
        return this.next != null;
    }

    public Item next() throws XPathException {
        this.current = this.next;
        this.currentKey = this.nextKey;
        ++this.position;
        this.advance();
        return this.current;
    }

    public Item current() {
        return this.current;
    }

    public int position() {
        return this.position;
    }

    public SequenceIterator getAnother() throws XPathException {
        return new GroupAdjacentIterator(this.population, this.keyExpression, this.keyContext.newContext(), this.collator);
    }
}

