/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.sort;

import net.sf.saxon.expr.ComputedExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.sort.DocumentOrderIterator;
import net.sf.saxon.sort.GlobalOrderComparer;
import net.sf.saxon.sort.LocalOrderComparer;
import net.sf.saxon.sort.NodeOrderComparer;
import net.sf.saxon.xpath.XPathException;

public class DocumentSorter
extends ComputedExpression {
    private Expression base;
    private NodeOrderComparer comparer;

    public DocumentSorter(Expression expression) {
        this.base = expression;
        this.comparer = (expression.getSpecialProperties() & 0x10000) != 0 ? LocalOrderComparer.getInstance() : GlobalOrderComparer.getInstance();
    }

    public Expression getBaseExpression() {
        return this.base;
    }

    public Expression simplify() throws XPathException {
        this.base = this.base.simplify();
        return this;
    }

    public Expression analyze(StaticContext staticContext) throws XPathException {
        this.base = this.base.analyze(staticContext);
        return this;
    }

    public int getItemType() {
        return this.base.getItemType();
    }

    public int computeSpecialProperties() {
        return this.base.getSpecialProperties() | 0x20000;
    }

    public int computeCardinality() {
        return this.base.getCardinality();
    }

    public Expression[] getSubExpressions() {
        Expression[] expressionArray = new Expression[]{this.base};
        return expressionArray;
    }

    public Expression promote(PromotionOffer promotionOffer) throws XPathException {
        Expression expression = promotionOffer.accept(this);
        if (expression != null) {
            return expression;
        }
        this.base = this.base.promote(promotionOffer);
        return this;
    }

    public SequenceIterator iterate(XPathContext xPathContext) throws XPathException {
        return new DocumentOrderIterator(this.base.iterate(xPathContext), this.comparer);
    }

    public boolean effectiveBooleanValue(XPathContext xPathContext) throws XPathException {
        return this.base.effectiveBooleanValue(xPathContext);
    }

    public void display(int n) {
        System.err.println(ExpressionTool.indent(n) + "Sort into Document Order");
        this.base.display(n + 1);
    }
}

