/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.query;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.TransformerException;
import net.sf.saxon.Configuration;
import net.sf.saxon.Controller;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.instruct.Bindery;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.om.EmptyIterator;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.query.DynamicQueryContext;
import net.sf.saxon.query.StaticQueryContext;
import net.sf.saxon.xpath.XPathEvaluator;
import net.sf.saxon.xpath.XPathException;

public class XQueryExpression {
    private Expression expression;
    private Executable executable;

    protected XQueryExpression(Expression expression, StaticQueryContext staticQueryContext, Configuration configuration) {
        this.expression = expression;
        this.executable = new Executable();
        this.executable.setConfiguration(configuration);
        this.executable.setDefaultCollationName(staticQueryContext.getDefaultCollationName());
        this.executable.setCollationTable(staticQueryContext.getAllCollations());
        this.executable.setSlotSpace(staticQueryContext.getNumberOfGlobalVariables(), staticQueryContext.getNumberOfLocalVariables());
        String[] stringArray = new String[]{staticQueryContext.getSystemId()};
        this.executable.setModuleArray(stringArray);
    }

    public List evaluate(DynamicQueryContext dynamicQueryContext) throws TransformerException {
        SequenceIterator sequenceIterator = this.iterator(dynamicQueryContext);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        while (sequenceIterator.hasNext()) {
            Item item = sequenceIterator.next();
            arrayList.add(XPathEvaluator.convert(item));
        }
        return arrayList;
    }

    public Object evaluateSingle(DynamicQueryContext dynamicQueryContext) throws TransformerException {
        SequenceIterator sequenceIterator = this.iterator(dynamicQueryContext);
        if (sequenceIterator.hasNext()) {
            return XPathEvaluator.convert(sequenceIterator.next());
        }
        return null;
    }

    public SequenceIterator iterator(DynamicQueryContext dynamicQueryContext) throws TransformerException {
        Object object;
        Object object2;
        Object object3;
        Controller controller = new Controller(this.executable.getConfiguration());
        controller.setExecutable(this.executable);
        this.executable.initialiseBindery(controller.getBindery());
        HashMap hashMap = dynamicQueryContext.getParameters();
        if (hashMap != null) {
            object3 = hashMap.keySet().iterator();
            while (object3.hasNext()) {
                object2 = (String)object3.next();
                object = hashMap.get(object2);
                controller.setParameter((String)object2, object);
            }
        }
        controller.setURIResolver(dynamicQueryContext.getURIResolver());
        controller.setErrorListener(dynamicQueryContext.getErrorListener());
        try {
            object3 = dynamicQueryContext.getContextNode();
            if (object3 != null) {
                controller.makeContext((Item)object3);
                controller.setPrincipalSourceDocument(object3.getDocumentRoot());
            }
            object2 = controller.getBindery();
            ((Bindery)object2).openStackFrame();
            controller.defineGlobalParameters((Bindery)object2);
            object = controller.newXPathContext();
            SequenceIterator sequenceIterator = this.expression.iterate((XPathContext)object);
            return new ErrorReportingIterator(sequenceIterator, controller.getErrorListener());
        }
        catch (XPathException xPathException) {
            controller.getErrorListener().error(xPathException);
            return EmptyIterator.getInstance();
        }
    }

    public void explain() {
        System.err.println("============ Compiled Expression ============");
        this.expression.display(10);
        System.err.println("=============================================");
    }

    private static class ErrorReportingIterator
    implements SequenceIterator {
        private SequenceIterator base;
        private ErrorListener listener;

        public ErrorReportingIterator(SequenceIterator sequenceIterator, ErrorListener errorListener) {
            this.base = sequenceIterator;
            this.listener = errorListener;
        }

        public boolean hasNext() throws XPathException {
            try {
                return this.base.hasNext();
            }
            catch (XPathException xPathException) {
                try {
                    this.listener.error(xPathException);
                }
                catch (TransformerException transformerException) {}
                throw xPathException;
            }
        }

        public Item next() throws XPathException {
            try {
                return this.base.next();
            }
            catch (XPathException xPathException) {
                try {
                    this.listener.error(xPathException);
                }
                catch (TransformerException transformerException) {}
                throw xPathException;
            }
        }

        public Item current() {
            return this.base.current();
        }

        public int position() {
            return this.base.position();
        }

        public SequenceIterator getAnother() throws XPathException {
            return new ErrorReportingIterator(this.base.getAnother(), this.listener);
        }
    }
}

