/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.pattern;

import java.util.StringTokenizer;
import net.sf.saxon.Controller;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.xpath.XPathException;

public final class IDPattern
extends Pattern {
    private Expression idExpression;

    public IDPattern(Expression expression) {
        this.idExpression = expression;
    }

    public Pattern typeCheck(StaticContext staticContext) throws XPathException {
        this.idExpression = this.idExpression.analyze(staticContext);
        return this;
    }

    public boolean matches(NodeInfo nodeInfo, Controller controller) throws XPathException {
        if (nodeInfo.getItemType() != 1) {
            return false;
        }
        DocumentInfo documentInfo = nodeInfo.getDocumentRoot();
        if (documentInfo == null) {
            return false;
        }
        StringValue stringValue = (StringValue)this.idExpression.evaluateItem(controller.newXPathContext());
        if (stringValue == null) {
            return false;
        }
        String string = stringValue.getStringValue();
        if (string.indexOf(32) < 0 && string.indexOf(9) < 0 && string.indexOf(10) < 0 && string.indexOf(12) < 0) {
            NodeInfo nodeInfo2 = documentInfo.selectID(string);
            if (nodeInfo2 == null) {
                return false;
            }
            return nodeInfo2.isSameNode(nodeInfo);
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        while (stringTokenizer.hasMoreElements()) {
            String string2 = (String)stringTokenizer.nextElement();
            NodeInfo nodeInfo3 = documentInfo.selectID(string2);
            if (nodeInfo3 == null || !nodeInfo.isSameNode(nodeInfo3)) continue;
            return true;
        }
        return false;
    }

    public int getItemType() {
        return 1;
    }

    public NodeTest getNodeTest() {
        return new NodeKindTest(1);
    }
}

