/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.instruct;

import java.util.List;
import javax.xml.transform.TransformerException;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.RoleLocator;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.TypeChecker;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.instruct.ExprInstruction;
import net.sf.saxon.instruct.TailCall;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Orphan;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.xpath.XPathException;

public final class ValueOf
extends ExprInstruction {
    private Expression select;
    private int options;

    public ValueOf(Expression expression, boolean bl) {
        this.select = expression;
        this.options = bl ? 1 : 0;
    }

    public String getInstructionName() {
        return "xsl:value-of";
    }

    public Expression analyze(StaticContext staticContext) throws XPathException {
        this.select = this.select.analyze(staticContext);
        RoleLocator roleLocator = new RoleLocator(4, "xsl:value-of/select", 0);
        this.select = TypeChecker.staticTypeCheck(this.select, SequenceType.SINGLE_STRING, false, roleLocator);
        return this;
    }

    public int getDependencies() {
        return this.select.getDependencies();
    }

    public void getXPathExpressions(List list) {
        list.add(this.select);
    }

    public void promoteInst(PromotionOffer promotionOffer) throws XPathException {
        this.select = this.select.promote(promotionOffer);
    }

    public SequenceType getResultType() {
        return new SequenceType(3, 88, 512);
    }

    public TailCall processLeavingTail(XPathContext xPathContext) throws TransformerException {
        SequenceReceiver sequenceReceiver = xPathContext.getController().getReceiver();
        sequenceReceiver.characters(this.select.evaluateAsString(xPathContext), this.options);
        return null;
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        String string = this.select.evaluateAsString(xPathContext);
        Orphan orphan = new Orphan(xPathContext.getController().getNamePool());
        orphan.setNodeKind((short)3);
        orphan.setStringValue(string);
        return orphan;
    }

    public void display(int n) {
        System.err.println(ExpressionTool.indent(n) + "value-of");
        this.select.display(n + 1);
    }
}

