/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.instruct;

import javax.xml.transform.TransformerException;
import net.sf.saxon.Controller;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.instruct.Instruction;
import net.sf.saxon.instruct.InstructionDetails;
import net.sf.saxon.instruct.Sequence;
import net.sf.saxon.instruct.TailCall;
import net.sf.saxon.trace.TraceListener;

public class Template
extends Instruction {
    private Sequence body;
    private int precedence;
    private int minImportPrecedence;
    private boolean needsStackFrame;

    public void init(Sequence sequence, boolean bl, int n, int n2) {
        this.body = sequence;
        this.needsStackFrame = bl;
        this.precedence = n;
        this.minImportPrecedence = n2;
    }

    public String getInstructionName() {
        return "xsl:template";
    }

    public int getPrecedence() {
        return this.precedence;
    }

    public int getMinImportPrecedence() {
        return this.minImportPrecedence;
    }

    public boolean needsStackFrame() {
        return this.needsStackFrame;
    }

    public TailCall processLeavingTail(XPathContext xPathContext) throws TransformerException {
        Controller controller = xPathContext.getController();
        if (this.body == null) {
            return null;
        }
        Template template = controller.getCurrentTemplate();
        controller.setCurrentTemplate(this);
        TailCall tailCall = controller.isTracing() ? this.traceExpand(controller) : this.expand(controller);
        controller.setCurrentTemplate(template);
        return tailCall;
    }

    protected TailCall traceExpand(Controller controller) throws TransformerException {
        TraceListener traceListener = controller.getTraceListener();
        InstructionDetails instructionDetails = this.getInstructionDetails(controller);
        traceListener.enter(instructionDetails);
        TailCall tailCall = this.expand(controller);
        traceListener.leave(instructionDetails);
        return tailCall;
    }

    protected TailCall expand(Controller controller) throws TransformerException {
        if (this.body == null) {
            return null;
        }
        return this.body.processLeavingTail(controller.newXPathContext());
    }
}

