/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.instruct;

import java.util.List;
import javax.xml.transform.TransformerException;
import net.sf.saxon.Controller;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.RoleLocator;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.TypeChecker;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.instruct.ExprInstruction;
import net.sf.saxon.instruct.Instruction;
import net.sf.saxon.instruct.Sequence;
import net.sf.saxon.instruct.SimpleNodeConstructor;
import net.sf.saxon.instruct.TailCall;
import net.sf.saxon.om.XMLChar;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.xpath.XPathException;

public class ProcessingInstruction
extends SimpleNodeConstructor {
    private Expression name;

    public ProcessingInstruction(Expression expression) {
        this.name = expression;
    }

    public String getInstructionName() {
        return "xsl:processing-instruction";
    }

    public SequenceType getResultType() {
        return new SequenceType(7, 88, 512);
    }

    public void typeCheck(StaticContext staticContext) throws XPathException {
        this.name = this.name.analyze(staticContext);
        RoleLocator roleLocator = new RoleLocator(4, "processing-instruction:name", 0);
        this.name = TypeChecker.staticTypeCheck(this.name, SequenceType.SINGLE_STRING, false, roleLocator);
    }

    public int getDependencies() {
        return this.name.getDependencies() | super.getDependencies();
    }

    public void getXPathExpressions(List list) {
        list.add(this.name);
        super.getXPathExpressions(list);
    }

    public void promoteInst(PromotionOffer promotionOffer) throws XPathException {
        this.name = this.name.promote(promotionOffer);
        if (this.valueExpression != null) {
            this.valueExpression = this.valueExpression.promote(promotionOffer);
        }
        if (this.children != null) {
            int n = 0;
            while (n < this.children.length) {
                if (this.children[n] instanceof ExprInstruction) {
                    Expression expression = ((ExprInstruction)this.children[n]).promote(promotionOffer);
                    this.children[n] = expression instanceof Instruction ? (Instruction)((Object)expression) : new Sequence(expression, null);
                } else {
                    throw new IllegalStateException("Children of an ExprInstruction must themselves be ExprInstructions");
                }
                ++n;
            }
        }
    }

    public TailCall processLeavingTail(XPathContext xPathContext) throws TransformerException {
        Controller controller = xPathContext.getController();
        String string = this.name.evaluateAsString(xPathContext);
        if (!XMLChar.isValidNCName(string) || string.equalsIgnoreCase("xml")) {
            this.recoverableError("Processing instruction name is invalid: " + string, controller);
            return null;
        }
        String string2 = this.expandChildren(xPathContext).toString();
        int n = string2.indexOf("?>");
        if (n >= 0) {
            this.recoverableError("Invalid characters (?>) in processing instruction", controller);
            string2 = string2.substring(0, n + 1) + " " + string2.substring(n + 1);
        }
        controller.getReceiver().processingInstruction(string, string2, 0);
        return null;
    }

    protected int evaluateNameCode(XPathContext xPathContext) throws XPathException {
        String string = this.name.evaluateAsString(xPathContext);
        if (!XMLChar.isValidNCName(string) || string.equalsIgnoreCase("xml")) {
            throw new XPathException.Dynamic("Processing instruction name is invalid: " + string);
        }
        return xPathContext.getController().getNamePool().allocate("", "", string);
    }

    public void display(int n) {
        System.err.println(ExpressionTool.indent(n) + "processing-instruction");
        this.name.display(n + 1);
        super.display(n + 1);
    }
}

