/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.instruct;

import java.io.OutputStreamWriter;
import java.util.Properties;
import javax.xml.transform.TransformerException;
import net.sf.saxon.Controller;
import net.sf.saxon.event.Emitter;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.instruct.Instruction;
import net.sf.saxon.instruct.TailCall;
import net.sf.saxon.instruct.TerminationException;
import net.sf.saxon.value.SequenceType;

public class Message
extends Instruction {
    private Expression terminate;

    public Message(Expression expression) {
        this.terminate = expression;
    }

    public String getInstructionName() {
        return "xsl:message";
    }

    public SequenceType getResultType() {
        return new SequenceType(15, 88, 256);
    }

    public TailCall processLeavingTail(XPathContext xPathContext) throws TransformerException {
        String string;
        Controller controller = xPathContext.getController();
        Emitter emitter = controller.getMessageEmitter();
        if (emitter == null) {
            emitter = controller.makeMessageEmitter();
        }
        if (emitter.getWriter() == null) {
            emitter.setWriter(new OutputStreamWriter(System.err));
        }
        SequenceReceiver sequenceReceiver = controller.getReceiver();
        Properties properties = new Properties();
        properties.put("omit-xml-declaration", "yes");
        controller.changeOutputDestination(properties, emitter, false);
        this.processChildren(xPathContext);
        controller.resetOutputDestination(sequenceReceiver);
        if (this.terminate != null && !(string = this.terminate.evaluateAsString(xPathContext)).equals("no")) {
            if (string.equals("yes")) {
                throw new TerminationException("Processing terminated by xsl:message at line " + this.getLineNumber());
            }
            throw new TransformerException("The terminate attribute of xsl:message must be 'yes' or 'no'");
        }
        return null;
    }
}

