/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.instruct;

import java.util.List;
import javax.xml.transform.TransformerException;
import net.sf.saxon.Controller;
import net.sf.saxon.event.SequenceOutputter;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.RoleLocator;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.TypeChecker;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.instruct.AttributeSet;
import net.sf.saxon.instruct.ExprInstruction;
import net.sf.saxon.instruct.Instruction;
import net.sf.saxon.instruct.NamespaceContext;
import net.sf.saxon.instruct.Sequence;
import net.sf.saxon.instruct.TailCall;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Name;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.QNameException;
import net.sf.saxon.value.QNameValue;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.xpath.XPathException;

public class Element
extends ExprInstruction {
    private Expression elementName;
    private String fixedPrefix = null;
    private String fixedLocalName = null;
    private Expression namespace = null;
    private NamespaceContext nsContext;
    private AttributeSet[] useAttributeSets;
    private int annotation;

    public Element(Expression expression, Expression expression2, NamespaceContext namespaceContext, AttributeSet[] attributeSetArray, int n) throws XPathException {
        this.elementName = expression;
        this.namespace = expression2;
        this.nsContext = namespaceContext;
        this.useAttributeSets = attributeSetArray;
        this.annotation = n;
        if (expression instanceof StringValue) {
            String[] stringArray = new String[]{};
            try {
                stringArray = Name.getQNameParts(((StringValue)expression).getStringValue());
            }
            catch (QNameException qNameException) {
                throw new XPathException.Static("Invalid element name. " + qNameException.getMessage());
            }
            this.fixedPrefix = stringArray[0];
            this.fixedLocalName = stringArray[1];
        }
    }

    public SequenceType getResultType() {
        return new SequenceType(1, 88, 512);
    }

    public Expression simplify() throws XPathException {
        this.elementName = this.elementName.simplify();
        if (this.namespace != null) {
            this.namespace = this.namespace.simplify();
        }
        return super.simplify();
    }

    public Expression analyze(StaticContext staticContext) throws XPathException {
        this.elementName = this.elementName.analyze(staticContext);
        RoleLocator roleLocator = new RoleLocator(4, "element/name", 0);
        this.elementName = this.elementName.getItemType() == 118 ? TypeChecker.staticTypeCheck(this.elementName, SequenceType.SINGLE_ITEM, false, roleLocator) : TypeChecker.staticTypeCheck(this.elementName, SequenceType.SINGLE_STRING, false, roleLocator);
        if (this.namespace != null) {
            this.namespace = this.namespace.analyze(staticContext);
            roleLocator = new RoleLocator(4, "element/namespace", 0);
            this.namespace = TypeChecker.staticTypeCheck(this.namespace, SequenceType.SINGLE_STRING, false, roleLocator);
        }
        int n = 0;
        while (n < this.children.length) {
            if (!(this.children[n] instanceof ExprInstruction)) {
                throw new IllegalStateException("Children of an ExprInstruction must themselves be ExprInstructions");
            }
            this.children[n] = (ExprInstruction)((ExprInstruction)this.children[n]).analyze(staticContext);
            ++n;
        }
        return this;
    }

    public void getXPathExpressions(List list) {
        list.add(this.elementName);
        if (this.namespace != null) {
            list.add(this.namespace);
        }
    }

    public void promoteInst(PromotionOffer promotionOffer) throws XPathException {
        this.elementName = this.elementName.promote(promotionOffer);
        if (this.namespace != null) {
            this.namespace = this.namespace.promote(promotionOffer);
        }
        int n = 0;
        while (n < this.children.length) {
            if (this.children[n] instanceof ExprInstruction) {
                Expression expression = ((ExprInstruction)this.children[n]).promote(promotionOffer);
                this.children[n] = expression instanceof Instruction ? (Instruction)((Object)expression) : new Sequence(expression, null);
            } else {
                throw new IllegalStateException("Children of an ExprInstruction must themselves be ExprInstructions");
            }
            ++n;
        }
    }

    public TailCall processLeavingTail(XPathContext xPathContext) throws TransformerException {
        Controller controller = xPathContext.getController();
        int n = this.annotation;
        SequenceReceiver sequenceReceiver = controller.getReceiver();
        int n2 = this.evaluateNameCode(xPathContext);
        if (n2 == -1) {
            this.skipElement(xPathContext);
            return null;
        }
        sequenceReceiver.startElement(n2, n, 0);
        if (this.useAttributeSets != null) {
            AttributeSet.expand(this.useAttributeSets, xPathContext);
        }
        this.processChildren(xPathContext);
        sequenceReceiver.endElement();
        return null;
    }

    private int evaluateNameCode(XPathContext xPathContext) throws XPathException, TransformerException {
        String string;
        Controller controller = xPathContext.getController();
        NamePool namePool = controller.getNamePool();
        String string2 = this.fixedPrefix;
        String string3 = this.fixedLocalName;
        if (this.fixedLocalName == null) {
            Item item = this.elementName.evaluateItem(xPathContext);
            if (item instanceof StringValue) {
                String string4 = item.getStringValue();
                try {
                    String[] stringArray = Name.getQNameParts(string4);
                    string2 = stringArray[0];
                    string3 = stringArray[1];
                }
                catch (QNameException qNameException) {
                    this.recoverableError("Invalid element name. " + qNameException.getMessage(), controller);
                    return -1;
                }
            } else if (item instanceof QNameValue) {
                string3 = ((QNameValue)item).getLocalName();
                string = ((QNameValue)item).getNamespaceURI();
                this.namespace = new StringValue(string);
                string2 = namePool.suggestPrefixForURI(string);
                if (string2 == null) {
                    string2 = "nsq0";
                }
            }
        }
        if (this.namespace == null) {
            string = this.nsContext.getURIForPrefix(string2, true, namePool);
            if (string == null) {
                this.recoverableError("Undeclared prefix in element name: " + string2, controller);
                return -1;
            }
        } else {
            string = this.namespace.evaluateAsString(xPathContext);
            if (string.equals("")) {
                string2 = "";
            }
            if (string2.equals("xmlns")) {
                string2 = "x-xmlns";
            }
        }
        return namePool.allocate(string2, string, string3);
    }

    private void skipElement(XPathContext xPathContext) throws TransformerException {
        Controller controller = xPathContext.getController();
        controller.getReceiver().startElement(-1, 0, 0);
        this.processChildren(xPathContext);
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        try {
            Controller controller = xPathContext.getController();
            NamePool namePool = controller.getNamePool();
            SequenceReceiver sequenceReceiver = controller.getReceiver();
            SequenceOutputter sequenceOutputter = new SequenceOutputter();
            sequenceOutputter.setNamePool(namePool);
            sequenceOutputter.startDocument();
            sequenceOutputter.startElement(this.evaluateNameCode(xPathContext), 0, 0);
            controller.changeToSequenceOutputDestination(sequenceOutputter);
            this.processChildren(xPathContext);
            sequenceOutputter.endElement();
            sequenceOutputter.endDocument();
            controller.resetOutputDestination(sequenceReceiver);
            return sequenceOutputter.getFirstItem();
        }
        catch (TransformerException transformerException) {
            if (transformerException instanceof XPathException) {
                throw (XPathException)transformerException;
            }
            throw new XPathException.Dynamic(transformerException);
        }
    }

    public String getInstructionName() {
        return "xsl:element";
    }

    public void display(int n) {
        System.err.println(ExpressionTool.indent(n) + "element ");
        System.err.println(ExpressionTool.indent(n + 1) + "name");
        this.elementName.display(n + 2);
        if (this.children.length == 0) {
            System.err.println(ExpressionTool.indent(n + 1) + "empty content");
        } else {
            int n2 = 0;
            while (n2 < this.children.length) {
                if (this.children[n2] instanceof Expression) {
                    ((Expression)((Object)this.children[n2])).display(n + 1);
                } else {
                    System.err.println(ExpressionTool.indent(n + 1) + this.children[n2].getInstructionName());
                }
                ++n2;
            }
        }
    }
}

