/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.instruct;

import javax.xml.transform.TransformerException;
import net.sf.saxon.Controller;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.instruct.Instruction;
import net.sf.saxon.instruct.TailCall;
import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.tinytree.TinyBuilder;

public class Doctype
extends Instruction {
    public String getInstructionName() {
        return "saxon:doctype";
    }

    public TailCall processLeavingTail(XPathContext xPathContext) throws TransformerException {
        TinyBuilder tinyBuilder;
        Controller controller = xPathContext.getController();
        SequenceReceiver sequenceReceiver = controller.getReceiver();
        TinyBuilder tinyBuilder2 = tinyBuilder = new TinyBuilder();
        tinyBuilder2.setNamePool(controller.getNamePool());
        tinyBuilder2.startDocument();
        controller.changeOutputDestination(null, tinyBuilder2, false);
        this.processChildren(xPathContext);
        controller.resetOutputDestination(sequenceReceiver);
        tinyBuilder2.endDocument();
        DocumentInfo documentInfo = tinyBuilder.getCurrentDocument();
        AxisIterator axisIterator = documentInfo.iterateAxis((byte)3);
        NodeInfo nodeInfo = null;
        if (axisIterator.hasNext()) {
            nodeInfo = (NodeInfo)axisIterator.next();
        }
        if (nodeInfo == null || !nodeInfo.getLocalName().equals("doctype")) {
            throw new TransformerException("saxon:doctype instruction must contain dtd:doctype");
        }
        String string = nodeInfo.getAttributeValue("", "name");
        String string2 = nodeInfo.getAttributeValue("", "system");
        String string3 = nodeInfo.getAttributeValue("", "public");
        if (string == null) {
            throw new TransformerException("dtd:doctype must have a name attribute");
        }
        this.write(sequenceReceiver, "<!DOCTYPE " + string + " ");
        if (string2 != null) {
            if (string3 != null) {
                this.write(sequenceReceiver, "PUBLIC \"" + string3 + "\" \"" + string2 + "\"");
            } else {
                this.write(sequenceReceiver, "SYSTEM \"" + string2 + "\"");
            }
        }
        boolean bl = false;
        axisIterator = nodeInfo.iterateAxis((byte)3);
        if (axisIterator.hasNext()) {
            this.write(sequenceReceiver, " [");
            bl = true;
        }
        while (axisIterator.hasNext()) {
            Object object;
            String string4;
            String string5;
            Object object2;
            Object object3;
            String string6;
            NodeInfo nodeInfo2 = (NodeInfo)axisIterator.next();
            String string7 = nodeInfo2.getLocalName();
            if (string7.equals("element")) {
                string6 = nodeInfo2.getAttributeValue("", "name");
                object3 = nodeInfo2.getAttributeValue("", "content");
                if (string6 == null) {
                    throw new TransformerException("dtd:element must have a name attribute");
                }
                if (object3 == null) {
                    throw new TransformerException("dtd:element must have a content attribute");
                }
                this.write(sequenceReceiver, "\n  <!ELEMENT " + string6 + " " + (String)object3 + ">");
                continue;
            }
            if (string7.equals("attlist")) {
                string6 = nodeInfo2.getAttributeValue("", "element");
                if (string6 == null) {
                    throw new TransformerException("dtd:attlist must have an attribute named 'element'");
                }
                this.write(sequenceReceiver, "\n  <!ATTLIST " + string6 + " ");
                object3 = nodeInfo2.iterateAxis((byte)3);
                while (object3.hasNext()) {
                    object2 = (NodeInfo)object3.next();
                    if (object2.getLocalName().equals("attribute")) {
                        string5 = object2.getAttributeValue("", "name");
                        string4 = object2.getAttributeValue("", "type");
                        object = object2.getAttributeValue("", "value");
                        if (string5 == null) {
                            throw new TransformerException("dtd:attribute must have a name attribute");
                        }
                        if (string4 == null) {
                            throw new TransformerException("dtd:attribute must have a type attribute");
                        }
                        if (object == null) {
                            throw new TransformerException("dtd:attribute must have a value attribute");
                        }
                        this.write(sequenceReceiver, "\n    " + string5 + " " + string4 + " " + (String)object);
                        continue;
                    }
                    throw new TransformerException("Unrecognized element within dtd:attlist");
                }
                this.write(sequenceReceiver, ">");
                continue;
            }
            if (string7.equals("entity")) {
                string6 = nodeInfo2.getAttributeValue("", "name");
                object3 = nodeInfo2.getAttributeValue("", "parameter");
                object2 = nodeInfo2.getAttributeValue("", "system");
                string5 = nodeInfo2.getAttributeValue("", "public");
                string4 = nodeInfo2.getAttributeValue("", "notation");
                if (string6 == null) {
                    throw new TransformerException("dtd:entity must have a name attribute");
                }
                this.write(sequenceReceiver, "\n  <!ENTITY ");
                if ("yes".equals(object3)) {
                    this.write(sequenceReceiver, "% ");
                }
                this.write(sequenceReceiver, string6 + " ");
                if (object2 != null) {
                    if (string5 != null) {
                        this.write(sequenceReceiver, "PUBLIC \"" + string5 + "\" \"" + (String)object2 + "\" ");
                    } else {
                        this.write(sequenceReceiver, "SYSTEM \"" + (String)object2 + "\" ");
                    }
                }
                if (string4 != null) {
                    this.write(sequenceReceiver, "NDATA " + string4 + " ");
                }
                object = nodeInfo2.iterateAxis((byte)3);
                while (object.hasNext()) {
                    NodeInfo nodeInfo3 = (NodeInfo)object.next();
                    nodeInfo3.copy(sequenceReceiver, 0, false);
                }
                continue;
            }
            if (string7.equals("notation")) {
                string6 = nodeInfo2.getAttributeValue("", "name");
                object3 = nodeInfo2.getAttributeValue("", "system");
                object2 = nodeInfo2.getAttributeValue("", "public");
                if (string6 == null) {
                    throw new TransformerException("dtd:notation must have a name attribute");
                }
                if (object3 == null && object2 == null) {
                    throw new TransformerException("dtd:notation must have a system attribute or a public attribute");
                }
                this.write(sequenceReceiver, "\n  <!NOTATION " + string6);
                if (object2 != null) {
                    this.write(sequenceReceiver, " PUBLIC \"" + (String)object2 + "\" ");
                    if (object3 == null) continue;
                    this.write(sequenceReceiver, "\"" + (String)object3 + "\" ");
                    continue;
                }
                this.write(sequenceReceiver, " SYSTEM \"" + (String)object3 + "\" ");
                continue;
            }
            throw new TransformerException("Unrecognized element " + string7 + " in DTD output");
        }
        if (bl) {
            this.write(sequenceReceiver, "\n]");
            bl = false;
        }
        this.write(sequenceReceiver, ">\n");
        return null;
    }

    private void write(Receiver receiver, String string) throws TransformerException {
        receiver.characters(string, 1);
    }
}

