/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.instruct;

import java.util.HashMap;
import javax.xml.transform.TransformerException;
import net.sf.saxon.Controller;
import net.sf.saxon.ParameterSet;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.instruct.Bindery;
import net.sf.saxon.instruct.Instruction;
import net.sf.saxon.instruct.NamespaceContext;
import net.sf.saxon.instruct.TailCall;
import net.sf.saxon.instruct.Template;
import net.sf.saxon.instruct.WithParam;
import net.sf.saxon.om.Name;
import net.sf.saxon.om.QNameException;

public class CallTemplate
extends Instruction {
    private Template template = null;
    private WithParam[] actualParams = null;
    private boolean useTailRecursion = false;
    private Expression calledTemplateExpression;
    private NamespaceContext nsContext;

    public CallTemplate(Template template, WithParam[] withParamArray, boolean bl, Expression expression, NamespaceContext namespaceContext) {
        this.template = template;
        this.actualParams = withParamArray;
        this.useTailRecursion = bl;
        this.calledTemplateExpression = expression;
        this.nsContext = namespaceContext;
    }

    public String getInstructionName() {
        return "xsl:call-template";
    }

    public void process(XPathContext xPathContext) throws TransformerException {
        Controller controller = xPathContext.getController();
        Template template = this.getTargetTemplate(xPathContext);
        ParameterSet parameterSet = null;
        if (this.actualParams != null) {
            parameterSet = new ParameterSet();
            int n = 0;
            while (n < this.actualParams.length) {
                parameterSet.put(this.actualParams[n].getVariableFingerprint(), this.actualParams[n].getSelectValue(xPathContext));
                ++n;
            }
        }
        Bindery bindery = controller.getBindery();
        bindery.openStackFrame(parameterSet);
        TailCall tailCall = controller.isTracing() ? template.traceExpand(controller) : template.expand(controller);
        while (tailCall != null) {
            tailCall = tailCall.processLeavingTail(controller.newXPathContext());
        }
        bindery.closeStackFrame();
    }

    public TailCall processLeavingTail(XPathContext xPathContext) throws TransformerException {
        if (!this.useTailRecursion) {
            this.process(xPathContext);
            return null;
        }
        Template template = this.getTargetTemplate(xPathContext);
        ParameterSet parameterSet = null;
        if (this.actualParams != null) {
            parameterSet = new ParameterSet();
            int n = 0;
            while (n < this.actualParams.length) {
                parameterSet.put(this.actualParams[n].getVariableFingerprint(), this.actualParams[n].getSelectValue(xPathContext));
                ++n;
            }
        }
        if (parameterSet == null) {
            parameterSet = new ParameterSet();
        }
        return new CallTemplatePackage(template, parameterSet, xPathContext.getController().saveContext());
    }

    private Template getTargetTemplate(XPathContext xPathContext) throws TransformerException {
        if (this.calledTemplateExpression != null) {
            String string;
            String string2;
            Object object;
            Controller controller = xPathContext.getController();
            String string3 = this.calledTemplateExpression.evaluateAsString(xPathContext);
            try {
                object = Name.getQNameParts(string3);
                string2 = object[0];
                string = object[1];
            }
            catch (QNameException qNameException) {
                throw this.styleError("Invalid template name. " + qNameException.getMessage(), controller);
            }
            object = this.nsContext.getURIForPrefix(string2, false, controller.getNamePool());
            if (object == null) {
                throw this.styleError("Namespace prefix " + string2 + " has not been declared", controller);
            }
            int n = controller.getNamePool().getFingerprint((String)object, string);
            HashMap hashMap = controller.getExecutable().getNamedTemplateTable();
            Template template = (Template)hashMap.get(new Integer(n));
            if (template == null) {
                throw this.styleError("Template " + string3 + " has not been defined", controller);
            }
            return template;
        }
        return this.template;
    }

    private static class CallTemplatePackage
    implements TailCall {
        private Template target;
        private ParameterSet params;
        private Object[] executionContext;

        public CallTemplatePackage(Template template, ParameterSet parameterSet, Object[] objectArray) {
            this.target = template;
            this.params = parameterSet;
            this.executionContext = objectArray;
        }

        public TailCall processLeavingTail(XPathContext xPathContext) throws TransformerException {
            Controller controller = xPathContext.getController();
            Object[] objectArray = controller.saveContext();
            controller.restoreContext(this.executionContext);
            Bindery bindery = controller.getBindery();
            bindery.openStackFrame(this.params);
            TailCall tailCall = controller.isTracing() ? this.target.traceExpand(controller) : this.target.expand(controller);
            bindery.closeStackFrame();
            controller.restoreContext(objectArray);
            return tailCall;
        }
    }
}

