/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.instruct;

import javax.xml.transform.TransformerException;
import net.sf.saxon.Controller;
import net.sf.saxon.ParameterSet;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.instruct.Instruction;
import net.sf.saxon.instruct.InstructionDetails;
import net.sf.saxon.instruct.TailCall;
import net.sf.saxon.instruct.WithParam;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.sort.FixedSortKeyDefinition;
import net.sf.saxon.sort.SortKeyDefinition;
import net.sf.saxon.sort.SortedIterator;
import net.sf.saxon.trans.Mode;
import net.sf.saxon.value.Value;

public class ApplyTemplates
extends Instruction {
    private Expression select;
    private SortKeyDefinition[] sortKeys = null;
    private WithParam[] actualParams = null;
    private boolean useCurrentMode = false;
    private boolean useTailRecursion = false;
    private Mode mode;

    public ApplyTemplates(Expression expression, SortKeyDefinition[] sortKeyDefinitionArray, WithParam[] withParamArray, boolean bl, boolean bl2, Mode mode) {
        this.select = expression;
        this.sortKeys = sortKeyDefinitionArray;
        this.actualParams = withParamArray;
        this.useCurrentMode = bl;
        this.useTailRecursion = bl2 && sortKeyDefinitionArray == null;
        this.mode = mode;
    }

    public String getInstructionName() {
        return "xsl:apply-templates";
    }

    public InstructionDetails getInstructionDetails(Controller controller) {
        InstructionDetails instructionDetails = super.getInstructionDetails(controller);
        instructionDetails.setMode(this.mode.getModeName());
        return instructionDetails;
    }

    public void process(XPathContext xPathContext) throws TransformerException {
        this.apply(xPathContext, false);
    }

    public TailCall processLeavingTail(XPathContext xPathContext) throws TransformerException {
        return this.apply(xPathContext, this.useTailRecursion);
    }

    private TailCall apply(XPathContext xPathContext, boolean bl) throws TransformerException {
        SequenceIterator sequenceIterator;
        Object object;
        Mode mode = this.mode;
        Controller controller = xPathContext.getController();
        if (this.useCurrentMode) {
            mode = controller.getCurrentMode();
        }
        ParameterSet parameterSet = null;
        if (this.actualParams != null) {
            parameterSet = new ParameterSet();
            int n = 0;
            while (n < this.actualParams.length) {
                parameterSet.put(this.actualParams[n].getVariableFingerprint(), this.actualParams[n].getSelectValue(xPathContext));
                ++n;
            }
        }
        if (bl) {
            return new ApplyTemplatesPackage(ExpressionTool.lazyEvaluate(this.select, xPathContext), mode, parameterSet, controller.saveContext());
        }
        SequenceIterator sequenceIterator2 = controller.getCurrentIterator();
        if (this.select == null) {
            if (sequenceIterator2 == null) {
                throw new TransformerException("There is no context item");
            }
            object = sequenceIterator2.current();
            if (!(object instanceof NodeInfo)) {
                throw new TransformerException("The context item is not a node");
            }
            sequenceIterator = ((NodeInfo)object).iterateAxis((byte)3);
        } else {
            sequenceIterator = this.select.iterate(xPathContext);
        }
        if (!sequenceIterator.hasNext()) {
            return null;
        }
        if (this.sortKeys != null) {
            object = new FixedSortKeyDefinition[this.sortKeys.length];
            XPathContext xPathContext2 = controller.newXPathContext();
            int n = 0;
            while (n < this.sortKeys.length) {
                object[n] = this.sortKeys[n].reduce(xPathContext2);
                ++n;
            }
            sequenceIterator = new SortedIterator(xPathContext2, sequenceIterator, (FixedSortKeyDefinition[])object);
        }
        object = controller.applyTemplates(sequenceIterator, mode, parameterSet);
        while (object != null) {
            object = object.processLeavingTail(controller.newXPathContext());
        }
        return null;
    }

    private static class ApplyTemplatesPackage
    implements TailCall {
        private Value selectedNodes;
        private Mode mode;
        private ParameterSet params;
        private Object[] executionContext;

        public ApplyTemplatesPackage(Value value, Mode mode, ParameterSet parameterSet, Object[] objectArray) {
            this.selectedNodes = value;
            this.mode = mode;
            this.params = parameterSet;
            this.executionContext = objectArray;
        }

        public TailCall processLeavingTail(XPathContext xPathContext) throws TransformerException {
            Controller controller = xPathContext.getController();
            Object[] objectArray = controller.saveContext();
            controller.restoreContext(this.executionContext);
            TailCall tailCall = controller.applyTemplates(this.selectedNodes.iterate(xPathContext), this.mode, this.params);
            controller.restoreContext(objectArray);
            return tailCall;
        }
    }
}

