/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.instruct;

import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.xml.transform.TransformerException;
import net.sf.saxon.Controller;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.Matches;
import net.sf.saxon.instruct.Block;
import net.sf.saxon.instruct.Instruction;
import net.sf.saxon.instruct.RegexIterator;
import net.sf.saxon.instruct.TailCall;
import net.sf.saxon.om.SequenceIterator;

public class AnalyzeString
extends Instruction {
    private Expression select;
    private Expression regex;
    private Expression flags;
    private Block matching;
    private Block nonMatching;
    private Pattern pattern;

    public AnalyzeString(Expression expression, Expression expression2, Expression expression3, Block block, Block block2, Pattern pattern) {
        this.select = expression;
        this.regex = expression2;
        this.flags = expression3;
        this.matching = block;
        this.nonMatching = block2;
        this.pattern = pattern;
    }

    public String getInstructionName() {
        return "xsl:analyze-string";
    }

    public TailCall processLeavingTail(XPathContext xPathContext) throws TransformerException {
        Controller controller = xPathContext.getController();
        SequenceIterator sequenceIterator = controller.getCurrentIterator();
        RegexIterator regexIterator = controller.getCurrentRegexIterator();
        boolean bl = controller.isTracing();
        String string = this.select.evaluateAsString(xPathContext);
        Pattern pattern = this.pattern;
        if (pattern == null) {
            int n = Matches.setFlags(this.flags.evaluateAsString(xPathContext));
            try {
                pattern = Pattern.compile(this.regex.evaluateAsString(xPathContext), n);
            }
            catch (PatternSyntaxException patternSyntaxException) {
                throw new TransformerException(patternSyntaxException);
            }
        }
        RegexIterator regexIterator2 = new RegexIterator(string, pattern);
        controller.setCurrentIterator(regexIterator2);
        controller.setCurrentRegexIterator(regexIterator2);
        XPathContext xPathContext2 = xPathContext.newContext();
        xPathContext2.setCurrentIterator(regexIterator2);
        while (regexIterator2.hasNext()) {
            regexIterator2.next();
            if (regexIterator2.isMatching()) {
                if (this.matching == null) continue;
                this.matching.process(xPathContext2);
                continue;
            }
            if (this.nonMatching == null) continue;
            this.nonMatching.process(xPathContext2);
        }
        controller.setCurrentIterator(sequenceIterator);
        controller.setCurrentRegexIterator(regexIterator);
        return null;
    }
}

