/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.MappingFunction;
import net.sf.saxon.expr.MappingIterator;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.Matches;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.EmptyIterator;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.Value;
import net.sf.saxon.xpath.XPathException;

public class Tokenize
extends SystemFunction
implements MappingFunction {
    private Pattern regexp;

    public Expression simplify() throws XPathException {
        Expression expression = this.simplifyArguments(true);
        if (!(expression instanceof Value)) {
            this.regexp = Matches.tryToCompile(this.argument, 1, 2);
        }
        return expression;
    }

    public SequenceIterator iterate(XPathContext xPathContext) throws XPathException {
        StringValue stringValue = (StringValue)this.argument[0].evaluateItem(xPathContext);
        if (stringValue == null) {
            return EmptyIterator.getInstance();
        }
        String string = stringValue.getStringValue();
        Pattern pattern = this.regexp;
        if (pattern == null) {
            String string2;
            stringValue = (StringValue)this.argument[1].evaluateItem(xPathContext);
            if (stringValue == null) {
                return EmptyIterator.getInstance();
            }
            String string3 = stringValue.getStringValue();
            if (this.getNumberOfArguments() == 2) {
                string2 = "";
            } else {
                stringValue = (StringValue)this.argument[2].evaluateItem(xPathContext);
                if (stringValue == null) {
                    return EmptyIterator.getInstance();
                }
                string2 = stringValue.getStringValue();
            }
            try {
                pattern = Pattern.compile(string3, Matches.setFlags(string2));
            }
            catch (PatternSyntaxException patternSyntaxException) {
                throw new XPathException.Dynamic(patternSyntaxException);
            }
        }
        if (pattern.matcher("").matches()) {
            return new MappingIterator(stringValue.iterateCharacters(), this, null, null);
        }
        return new TokenIterator(string, pattern);
    }

    public Object map(Item item, XPathContext xPathContext, Object object) {
        long l = ((IntegerValue)item).getValue();
        if (l < 65536L) {
            return new StringValue("" + (char)l);
        }
        StringBuffer stringBuffer = new StringBuffer(2);
        stringBuffer.append((char)((l -= 65536L) / 1024L + 55296L));
        stringBuffer.append((char)(l % 1024L + 56320L));
        return new StringValue(stringBuffer);
    }

    public static void main(String[] stringArray) throws Exception {
        String string = stringArray[0];
        String[] stringArray2 = Pattern.compile(stringArray[1]).split(string, 0);
        System.out.println("results");
        int n = 0;
        while (n < stringArray2.length) {
            System.out.println("[" + stringArray2[n] + "]");
            ++n;
        }
        System.out.println("end results");
    }

    public static class TokenIterator
    implements SequenceIterator {
        private String input;
        private Pattern pattern;
        private Matcher matcher;
        private String current;
        private String next;
        private int position = 0;
        private int prevEnd = 0;

        public TokenIterator(String string, Pattern pattern) {
            this.input = string;
            this.pattern = pattern;
            this.matcher = pattern.matcher(string);
            this.prevEnd = 0;
            this.advance();
        }

        private void advance() {
            if (this.prevEnd < 0) {
                this.next = null;
                return;
            }
            if (this.matcher.find()) {
                this.next = this.input.substring(this.prevEnd, this.matcher.start());
                this.prevEnd = this.matcher.end();
            } else {
                this.next = this.input.substring(this.prevEnd);
                this.prevEnd = -1;
            }
        }

        public boolean hasNext() {
            return this.next != null;
        }

        public Item next() {
            this.current = this.next;
            this.advance();
            ++this.position;
            return new StringValue(this.current);
        }

        public Item current() {
            return new StringValue(this.current);
        }

        public int position() {
            return this.position;
        }

        public SequenceIterator getAnother() {
            return new TokenIterator(this.input, this.pattern);
        }
    }
}

