/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.expr.ContextItemExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.FunctionCall;
import net.sf.saxon.expr.RoleLocator;
import net.sf.saxon.expr.RootExpression;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.TypeChecker;
import net.sf.saxon.functions.Aggregate;
import net.sf.saxon.functions.Available;
import net.sf.saxon.functions.BaseURI;
import net.sf.saxon.functions.BooleanFn;
import net.sf.saxon.functions.Compare;
import net.sf.saxon.functions.Component;
import net.sf.saxon.functions.Concat;
import net.sf.saxon.functions.Contains;
import net.sf.saxon.functions.ContextItem;
import net.sf.saxon.functions.Current;
import net.sf.saxon.functions.CurrentDateTime;
import net.sf.saxon.functions.CurrentGroup;
import net.sf.saxon.functions.Data;
import net.sf.saxon.functions.DeepEqual;
import net.sf.saxon.functions.DefaultCollation;
import net.sf.saxon.functions.DistinctNodes;
import net.sf.saxon.functions.DistinctValues;
import net.sf.saxon.functions.Doc;
import net.sf.saxon.functions.Document;
import net.sf.saxon.functions.Error;
import net.sf.saxon.functions.EscapeURI;
import net.sf.saxon.functions.Evaluate;
import net.sf.saxon.functions.Existence;
import net.sf.saxon.functions.ForceCase;
import net.sf.saxon.functions.FormatDate;
import net.sf.saxon.functions.FormatNumber2;
import net.sf.saxon.functions.Id;
import net.sf.saxon.functions.InScopeNamespaces;
import net.sf.saxon.functions.IndexOf;
import net.sf.saxon.functions.Input;
import net.sf.saxon.functions.Insert;
import net.sf.saxon.functions.Key;
import net.sf.saxon.functions.Lang;
import net.sf.saxon.functions.Last;
import net.sf.saxon.functions.Matches;
import net.sf.saxon.functions.Minimax;
import net.sf.saxon.functions.NamePart;
import net.sf.saxon.functions.NamespaceForPrefix;
import net.sf.saxon.functions.NormalizeSpace;
import net.sf.saxon.functions.NumberFn;
import net.sf.saxon.functions.Parse;
import net.sf.saxon.functions.Position;
import net.sf.saxon.functions.QNameFn;
import net.sf.saxon.functions.RegexGroup;
import net.sf.saxon.functions.Remove;
import net.sf.saxon.functions.Replace;
import net.sf.saxon.functions.ResolveQName;
import net.sf.saxon.functions.ResolveURI;
import net.sf.saxon.functions.Root;
import net.sf.saxon.functions.Rounding;
import net.sf.saxon.functions.SequenceCompare;
import net.sf.saxon.functions.Serialize;
import net.sf.saxon.functions.Sort;
import net.sf.saxon.functions.StandardFunction;
import net.sf.saxon.functions.StringFn;
import net.sf.saxon.functions.StringJoin;
import net.sf.saxon.functions.StringLength;
import net.sf.saxon.functions.StringPad;
import net.sf.saxon.functions.SubSequence;
import net.sf.saxon.functions.Substring;
import net.sf.saxon.functions.SystemProperty;
import net.sf.saxon.functions.Tokenize;
import net.sf.saxon.functions.Trace;
import net.sf.saxon.functions.Translate;
import net.sf.saxon.functions.TreatFn;
import net.sf.saxon.functions.Unicode;
import net.sf.saxon.functions.Unordered;
import net.sf.saxon.functions.UnparsedEntity;
import net.sf.saxon.functions.UnparsedText;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.xpath.XPathException;

public abstract class SystemFunction
extends FunctionCall {
    private StandardFunction.Entry details;
    protected int operation;

    public static FunctionCall makeSystemFunction(String string) throws XPathException {
        StandardFunction.Entry entry = StandardFunction.getFunction(string);
        if (entry == null) {
            return null;
        }
        Class clazz = entry.implementationClass;
        try {
            SystemFunction systemFunction = (SystemFunction)clazz.newInstance();
            systemFunction.setDetails(entry);
            return systemFunction;
        }
        catch (Exception exception) {
            throw new XPathException.Static(exception);
        }
    }

    private void setDetails(StandardFunction.Entry entry) {
        this.details = entry;
        this.operation = this.details.opcode;
    }

    protected StandardFunction.Entry getDetails() {
        return this.details;
    }

    public void checkArguments(StaticContext staticContext) throws XPathException {
        this.checkArgumentCount(this.details.minArguments, this.details.maxArguments);
        int n = 0;
        while (n < this.getNumberOfArguments()) {
            this.checkArgument(n, staticContext);
            ++n;
        }
    }

    private void checkArgument(int n, StaticContext staticContext) throws XPathException {
        RoleLocator roleLocator = new RoleLocator(0, this.getName(), n);
        this.argument[n] = TypeChecker.staticTypeCheck(this.argument[n], this.getRequiredType(n), staticContext.isInBackwardsCompatibleMode(), roleLocator);
        this.argument[n] = this.argument[n].simplify();
    }

    private String ordinal(int n) {
        switch (n + 1) {
            case 1: {
                return "first";
            }
            case 2: {
                return "second";
            }
            case 3: {
                return "third";
            }
        }
        return n + "th";
    }

    protected SequenceType getRequiredType(int n) {
        return this.details.argumentTypes[n];
    }

    public String getName() {
        return this.details.name;
    }

    public int getItemType() {
        int n = this.details.itemType;
        if (n == 999999) {
            try {
                return this.argument[0].getItemType();
            }
            catch (Exception exception) {
                return 88;
            }
        }
        return n;
    }

    public int computeCardinality() {
        if (this.details == null) {
            System.err.println("No details for " + this.getClass() + " at " + this);
        }
        return this.details.cardinality;
    }

    protected final void useContextItemAsDefault() throws XPathException {
        if (this.getNumberOfArguments() == 0) {
            this.argument = new Expression[1];
            this.argument[0] = new ContextItemExpression();
            ExpressionTool.copyLocationInfo(this, this.argument[0]);
        }
    }

    protected final void addContextDocumentArgument(int n, String string) throws XPathException {
        if (this.getNumberOfArguments() > n) {
            return;
        }
        if (this.getNumberOfArguments() != n) {
            throw new XPathException.Static("Too few arguments in call to " + this.getName() + "() function");
        }
        Expression[] expressionArray = new Expression[n + 1];
        int n2 = 0;
        while (n2 < this.getNumberOfArguments()) {
            expressionArray[n2] = this.argument[n2];
            ++n2;
        }
        expressionArray[n] = new RootExpression();
        this.argument = expressionArray;
        this.setDetails(StandardFunction.getFunction(string));
    }

    public void display(int n) {
        System.err.println(ExpressionTool.indent(n) + "function " + this.getName());
        int n2 = 0;
        while (n2 < this.getNumberOfArguments()) {
            this.argument[n2].display(n + 1);
            ++n2;
        }
    }

    public static void main(String[] stringArray) throws Exception {
        SystemFunction systemFunction = new Aggregate();
        systemFunction = new Available();
        systemFunction = new BaseURI();
        systemFunction = new BooleanFn();
        systemFunction = new Compare();
        systemFunction = new Component();
        systemFunction = new Concat();
        systemFunction = new Contains();
        systemFunction = new ContextItem();
        systemFunction = new Current();
        systemFunction = new CurrentDateTime();
        systemFunction = new CurrentGroup();
        systemFunction = new Data();
        systemFunction = new DeepEqual();
        systemFunction = new DefaultCollation();
        systemFunction = new DistinctNodes();
        systemFunction = new DistinctValues();
        systemFunction = new Doc();
        systemFunction = new Document();
        systemFunction = new Error();
        systemFunction = new EscapeURI();
        systemFunction = new Evaluate();
        systemFunction = new Existence();
        systemFunction = new ForceCase();
        systemFunction = new FormatDate();
        systemFunction = new FormatNumber2();
        systemFunction = new Id();
        systemFunction = new IndexOf();
        systemFunction = new Input();
        systemFunction = new InScopeNamespaces();
        systemFunction = new Insert();
        systemFunction = new Key();
        systemFunction = new Lang();
        systemFunction = new Last();
        systemFunction = new Matches();
        systemFunction = new Minimax();
        systemFunction = new NamePart();
        systemFunction = new NamespaceForPrefix();
        systemFunction = new NormalizeSpace();
        systemFunction = new NumberFn();
        systemFunction = new Parse();
        systemFunction = new Position();
        systemFunction = new QNameFn();
        systemFunction = new RegexGroup();
        systemFunction = new Remove();
        systemFunction = new Replace();
        systemFunction = new ResolveQName();
        systemFunction = new ResolveURI();
        systemFunction = new Root();
        systemFunction = new Rounding();
        systemFunction = new SequenceCompare();
        systemFunction = new Serialize();
        systemFunction = new Sort();
        systemFunction = new StringFn();
        systemFunction = new StringJoin();
        systemFunction = new StringLength();
        systemFunction = new StringPad();
        systemFunction = new SubSequence();
        systemFunction = new Substring();
        systemFunction = new SystemProperty();
        systemFunction = new Tokenize();
        systemFunction = new Trace();
        systemFunction = new Translate();
        systemFunction = new TreatFn();
        systemFunction = new Unicode();
        systemFunction = new Unordered();
        systemFunction = new UnparsedEntity();
        systemFunction = new UnparsedText();
        System.err.println(systemFunction);
    }
}

