/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.Controller;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.functions.XSLTFunction;
import net.sf.saxon.instruct.NamespaceContext;
import net.sf.saxon.om.Name;
import net.sf.saxon.om.QNameException;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.sort.FixedSortKeyDefinition;
import net.sf.saxon.sort.SortKeyDefinition;
import net.sf.saxon.sort.SortedIterator;
import net.sf.saxon.style.ExpressionContext;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.xpath.XPathException;

public class Sort
extends SystemFunction
implements XSLTFunction {
    private NamespaceContext nsContext = null;
    private String keyURI;
    private String keyLocalName;

    public void checkArguments(StaticContext staticContext) throws XPathException {
        super.checkArguments(staticContext);
        if (this.argument[1] instanceof StringValue) {
            String string = ((StringValue)this.argument[1]).getStringValue();
            if (!Name.isQName(string)) {
                this.dynamicError("Sort key '" + string + "' is not a valid QName");
            }
            try {
                String[] stringArray = Name.getQNameParts(string);
                this.keyLocalName = stringArray[1];
                this.keyURI = staticContext.getURIForPrefix(stringArray[0]);
            }
            catch (QNameException qNameException) {
                throw new XPathException.Static("Invalid sort key name. " + qNameException.getMessage());
            }
        } else {
            this.nsContext = ((ExpressionContext)staticContext).getNamespaceContext();
        }
    }

    public int computeCardinality() {
        return this.argument[0].getCardinality();
    }

    public int computeSpecialProperties() {
        int n = 0;
        Expression expression = this.argument[0];
        if ((expression.getSpecialProperties() & 0x10000) != 0) {
            n |= 0x10000;
        }
        return n;
    }

    public Expression preEvaluate(StaticContext staticContext) {
        return this;
    }

    public SequenceIterator iterate(XPathContext xPathContext) throws XPathException {
        Object[] objectArray;
        Object object;
        Controller controller = xPathContext.getController();
        String string = this.keyURI;
        Object object2 = this.keyLocalName;
        if (object2 == null) {
            object = this.argument[1].evaluateItem(xPathContext).getStringValue();
            if (!Name.isQName((String)object)) {
                this.dynamicError("Sort key '" + (String)object + "' is not a valid QName");
                return null;
            }
            try {
                objectArray = Name.getQNameParts((String)object);
                object2 = objectArray[1];
                string = this.nsContext.getURIForPrefix((String)objectArray[0], false, xPathContext.getController().getNamePool());
            }
            catch (QNameException qNameException) {
                this.dynamicError("Invalid sort key name. " + qNameException.getMessage());
            }
        }
        if ((object = controller.getSortSpecification(string, (String)object2)) == null) {
            this.dynamicError("Sort key '" + (String)object2 + "' has not been defined");
            return null;
        }
        objectArray = new FixedSortKeyDefinition[((SortKeyDefinition[])object).length];
        XPathContext xPathContext2 = controller.newXPathContext();
        int n = 0;
        while (n < ((SortKeyDefinition[])object).length) {
            objectArray[n] = object[n].reduce(xPathContext2);
            ++n;
        }
        SequenceIterator sequenceIterator = this.argument[0].iterate(xPathContext);
        return new SortedIterator(xPathContext.newContext(), sequenceIterator, (FixedSortKeyDefinition[])objectArray);
    }
}

