/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Name;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.QNameException;
import net.sf.saxon.value.QNameValue;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.xpath.XPathException;

public class ResolveQName
extends SystemFunction {
    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        String[] stringArray;
        StringValue stringValue = (StringValue)this.argument[0].evaluateItem(xPathContext);
        String string = stringValue.getStringValue();
        try {
            stringArray = Name.getQNameParts(string);
        }
        catch (QNameException qNameException) {
            this.dynamicError(qNameException.getMessage());
            return null;
        }
        if (stringArray[0].equals("")) {
            return new QNameValue(null, stringArray[1]);
        }
        NodeInfo nodeInfo = (NodeInfo)this.argument[1].evaluateItem(xPathContext);
        AxisIterator axisIterator = nodeInfo.iterateAxis((byte)8);
        while (axisIterator.hasNext()) {
            NodeInfo nodeInfo2 = (NodeInfo)axisIterator.next();
            String string2 = nodeInfo2.getLocalName();
            if (!string2.equals(stringArray[0])) continue;
            return new QNameValue(nodeInfo2.getStringValue(), stringArray[1]);
        }
        this.dynamicError("Namespace prefix '" + stringArray[0] + "' is not in scope for the selected element");
        return null;
    }
}

