/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.xpath.XPathException;

public class Insert
extends SystemFunction {
    public SequenceIterator iterate(XPathContext xPathContext) throws XPathException {
        SequenceIterator sequenceIterator = this.argument[0].iterate(xPathContext);
        IntegerValue integerValue = (IntegerValue)this.argument[1].evaluateItem(xPathContext);
        int n = (int)integerValue.getValue();
        SequenceIterator sequenceIterator2 = this.argument[2].iterate(xPathContext);
        return new InsertIterator(sequenceIterator, sequenceIterator2, n);
    }

    private class InsertIterator
    implements SequenceIterator {
        private SequenceIterator base;
        private SequenceIterator insert;
        private int insertPosition;
        private int position = 0;
        private Item nextItem = null;
        private Item current = null;
        private boolean inserting = false;

        public InsertIterator(SequenceIterator sequenceIterator, SequenceIterator sequenceIterator2, int n) throws XPathException {
            this.base = sequenceIterator;
            this.insert = sequenceIterator2;
            this.insertPosition = n < 1 ? 1 : n;
            this.inserting = n == 1;
            this.advance();
        }

        private void advance() throws XPathException {
            if (this.inserting) {
                if (this.insert.hasNext()) {
                    this.nextItem = this.insert.next();
                } else {
                    this.inserting = false;
                    this.nextItem = this.base.hasNext() ? this.base.next() : null;
                }
            } else if (this.position == this.insertPosition - 1 && this.insert.hasNext()) {
                this.inserting = true;
                this.nextItem = this.insert.next();
            } else {
                this.nextItem = this.base.hasNext() ? this.base.next() : null;
            }
        }

        public boolean hasNext() {
            return this.nextItem != null;
        }

        public Item next() throws XPathException {
            this.current = this.nextItem;
            ++this.position;
            this.advance();
            return this.current;
        }

        public Item current() {
            return this.current;
        }

        public int position() {
            return this.position;
        }

        public SequenceIterator getAnother() throws XPathException {
            return new InsertIterator(this.base.getAnother(), this.insert.getAnother(), this.insertPosition);
        }
    }
}

