/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.MappingFunction;
import net.sf.saxon.expr.MappingIterator;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.StringTokenIterator;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.EmptyIterator;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SingletonIterator;
import net.sf.saxon.sort.DocumentOrderIterator;
import net.sf.saxon.sort.LocalOrderComparer;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.xpath.XPathException;

public class Id
extends SystemFunction
implements MappingFunction {
    private boolean isSingletonId = false;

    public Expression simplify() throws XPathException {
        Id id = (Id)super.simplify();
        id.addContextDocumentArgument(1, "id+");
        return id;
    }

    public void checkArguments(StaticContext staticContext) throws XPathException {
        super.checkArguments(staticContext);
        this.argument[0] = ExpressionTool.unsorted(this.argument[0], false);
        this.isSingletonId = !Cardinality.allowsMany(this.argument[0].getCardinality());
    }

    public Expression preEvaluate(StaticContext staticContext) {
        return this;
    }

    public int computeSpecialProperties() {
        return 196608;
    }

    public SequenceIterator iterate(XPathContext xPathContext) throws XPathException {
        Item item = this.argument[1].evaluateItem(xPathContext);
        if (!(item instanceof DocumentInfo)) {
            this.dynamicError("In the id() function, the context node must be in a tree whose root is a document node");
            return null;
        }
        DocumentInfo documentInfo = (DocumentInfo)item;
        if (this.isSingletonId) {
            StringValue stringValue = (StringValue)this.argument[0].evaluateItem(xPathContext);
            if (stringValue == null) {
                return EmptyIterator.getInstance();
            }
            String string = stringValue.getStringValue();
            if (string.indexOf(32) >= 0 || string.indexOf(9) >= 0 || string.indexOf(10) >= 0 || string.indexOf(13) >= 0) {
                StringTokenIterator stringTokenIterator = new StringTokenIterator(string);
                MappingIterator mappingIterator = new MappingIterator(stringTokenIterator, this, null, documentInfo);
                return new DocumentOrderIterator(mappingIterator, LocalOrderComparer.getInstance());
            }
            return new SingletonIterator(documentInfo.selectID(string));
        }
        SequenceIterator sequenceIterator = this.argument[0].iterate(xPathContext);
        MappingIterator mappingIterator = new MappingIterator(sequenceIterator, this, null, documentInfo);
        return new DocumentOrderIterator(mappingIterator, LocalOrderComparer.getInstance());
    }

    public Object map(Item item, XPathContext xPathContext, Object object) throws XPathException {
        String string = item.getStringValue().trim();
        DocumentInfo documentInfo = (DocumentInfo)object;
        if (string.indexOf(32) >= 0 || string.indexOf(9) >= 0 || string.indexOf(10) >= 0 || string.indexOf(13) >= 0) {
            StringTokenIterator stringTokenIterator = new StringTokenIterator(string);
            return new MappingIterator(stringTokenIterator, this, null, object);
        }
        return documentInfo.selectID(string);
    }
}

