/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.functions.XSLTFunction;
import net.sf.saxon.instruct.NamespaceContext;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SingletonIterator;
import net.sf.saxon.style.ExpressionContext;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.ObjectValue;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.xpath.StandaloneContext;
import net.sf.saxon.xpath.Variable;
import net.sf.saxon.xpath.XPathException;

public class Evaluate
extends SystemFunction
implements XSLTFunction {
    StandaloneContext staticContext;
    public static final int EVALUATE = 0;
    public static final int EXPRESSION = 1;
    public static final int EVAL = 2;

    protected SequenceType getRequiredType(int n) {
        if (n == 0) {
            return super.getRequiredType(n);
        }
        return SequenceType.ANY_SEQUENCE;
    }

    public void checkArguments(StaticContext staticContext) throws XPathException {
        super.checkArguments(staticContext);
        if (!(staticContext instanceof ExpressionContext)) {
            throw new XPathException.Static(this.getName() + " is available only within XSLT");
        }
        if (this.operation != 2) {
            NamespaceContext namespaceContext = ((ExpressionContext)staticContext).getNamespaceContext();
            NamePool namePool = staticContext.getNamePool();
            this.staticContext = new StandaloneContext(namePool);
            int[] nArray = namespaceContext.getNamespaceCodes();
            int n = 0;
            while (n < nArray.length) {
                String string = namePool.getPrefixFromNamespaceCode(nArray[n]);
                String string2 = namePool.getURIFromNamespaceCode(nArray[n]);
                this.staticContext.declareNamespace(string, string2);
                ++n;
            }
        }
    }

    public Expression preEvaluate(StaticContext staticContext) {
        return this;
    }

    private PreparedExpression prepareExpression(XPathContext xPathContext) throws XPathException {
        if (this.operation == 2) {
            ObjectValue objectValue = (ObjectValue)this.argument[0].evaluateItem(xPathContext);
            Object object = objectValue.getObject();
            if (!(object instanceof PreparedExpression)) {
                this.dynamicError("First argument to saxon:eval must be an expression prepared using saxon:expression");
                return null;
            }
            return (PreparedExpression)object;
        }
        StringValue stringValue = (StringValue)this.argument[0].evaluateItem(xPathContext);
        PreparedExpression preparedExpression = new PreparedExpression();
        preparedExpression.variables = new Variable[10];
        int n = 1;
        while (n < 10) {
            preparedExpression.variables[n - 1] = this.staticContext.declareVariable("p" + n, EmptySequence.getInstance());
            ++n;
        }
        Expression expression = ExpressionTool.make(stringValue.getStringValue(), this.staticContext);
        preparedExpression.expression = expression = expression.analyze(this.staticContext);
        return preparedExpression;
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        PreparedExpression preparedExpression = this.prepareExpression(xPathContext);
        if (this.operation == 1) {
            return new ObjectValue(preparedExpression);
        }
        int n = 1;
        while (n < this.getNumberOfArguments()) {
            preparedExpression.variables[n - 1].setValue(this.argument[n].evaluateItem(xPathContext));
            ++n;
        }
        return preparedExpression.expression.evaluateItem(xPathContext);
    }

    public SequenceIterator iterate(XPathContext xPathContext) throws XPathException {
        PreparedExpression preparedExpression = this.prepareExpression(xPathContext);
        if (this.operation == 1) {
            return new SingletonIterator(new ObjectValue(preparedExpression));
        }
        int n = 1;
        while (n < this.getNumberOfArguments()) {
            preparedExpression.variables[n - 1].setValue(this.argument[n].evaluateItem(xPathContext));
            ++n;
        }
        return preparedExpression.expression.iterate(xPathContext);
    }

    public int getIntrinsicDependencies() {
        return 30;
    }

    protected static class PreparedExpression {
        public Expression expression;
        public Variable[] variables;

        protected PreparedExpression() {
        }
    }
}

