/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import java.util.Comparator;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.sort.AtomicComparer;
import net.sf.saxon.sort.CodepointCollator;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.xpath.XPathException;

public abstract class CollatingFunction
extends SystemFunction {
    public Expression preEvaluate(StaticContext staticContext) {
        return this;
    }

    protected AtomicComparer getAtomicComparer(int n, XPathContext xPathContext) throws XPathException {
        return new AtomicComparer(this.getCollator(n, xPathContext));
    }

    protected Comparator getCollator(int n, XPathContext xPathContext) throws XPathException {
        int n2 = this.getNumberOfArguments();
        if (n2 > n) {
            StringValue stringValue = (StringValue)this.argument[n].evaluateItem(xPathContext);
            String string = stringValue.getStringValue();
            return xPathContext.getCollation(string);
        }
        Comparator comparator = xPathContext.getDefaultCollation();
        return comparator == null ? CodepointCollator.getInstance() : comparator;
    }
}

