/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.exslt;

import java.util.ArrayList;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.SequenceExtent;
import net.sf.saxon.value.SequenceValue;
import net.sf.saxon.value.Value;
import net.sf.saxon.xpath.XPathException;

public abstract class Math {
    public static double max(SequenceIterator sequenceIterator) throws XPathException {
        double d = Double.NEGATIVE_INFINITY;
        while (sequenceIterator.hasNext()) {
            double d2 = Value.stringToNumber(sequenceIterator.next().getStringValue());
            if (Double.isNaN(d2)) {
                return d2;
            }
            if (!(d2 > d)) continue;
            d = d2;
        }
        return d;
    }

    public static double min(SequenceIterator sequenceIterator) throws XPathException {
        double d = Double.POSITIVE_INFINITY;
        while (sequenceIterator.hasNext()) {
            double d2 = Value.stringToNumber(sequenceIterator.next().getStringValue());
            if (Double.isNaN(d2)) {
                return d2;
            }
            if (!(d2 < d)) continue;
            d = d2;
        }
        return d;
    }

    public static SequenceValue highest(XPathContext xPathContext, SequenceIterator sequenceIterator) throws XPathException {
        double d = Double.NEGATIVE_INFINITY;
        ArrayList<Item> arrayList = new ArrayList<Item>();
        while (sequenceIterator.hasNext()) {
            Item item = sequenceIterator.next();
            double d2 = Value.stringToNumber(item.getStringValue());
            if (Double.isNaN(d2)) {
                return EmptySequence.getInstance();
            }
            if (d2 == d) {
                arrayList.add(item);
                continue;
            }
            if (!(d2 > d)) continue;
            d = d2;
            arrayList.clear();
            arrayList.add(item);
        }
        return new SequenceExtent(arrayList);
    }

    public static SequenceValue lowest(XPathContext xPathContext, SequenceIterator sequenceIterator) throws XPathException {
        double d = Double.POSITIVE_INFINITY;
        ArrayList<Item> arrayList = new ArrayList<Item>();
        while (sequenceIterator.hasNext()) {
            Item item = sequenceIterator.next();
            double d2 = Value.stringToNumber(item.getStringValue());
            if (Double.isNaN(d2)) {
                return EmptySequence.getInstance();
            }
            if (d2 == d) {
                arrayList.add(item);
                continue;
            }
            if (!(d2 < d)) continue;
            d = d2;
            arrayList.clear();
            arrayList.add(item);
        }
        return new SequenceExtent(arrayList);
    }

    public static double abs(double d) throws XPathException {
        return java.lang.Math.abs(d);
    }

    public static double sqrt(double d) throws XPathException {
        return java.lang.Math.sqrt(d);
    }

    public static double power(double d, double d2) throws XPathException {
        return java.lang.Math.pow(d, d2);
    }

    public static double constant(String string, double d) throws XPathException {
        String string2 = "";
        if (string.equals("PI")) {
            string2 = "3.1415926535897932384626433832795028841971693993751";
        } else if (string.equals("E")) {
            string2 = "2.71828182845904523536028747135266249775724709369996";
        } else if (string.equals("SQRRT2")) {
            string2 = "1.41421356237309504880168872420969807856967187537694";
        } else if (string.equals("LN2")) {
            string2 = "0.69314718055994530941723212145817656807550013436025";
        } else if (string.equals("LN10")) {
            string2 = "2.302585092994046";
        } else if (string.equals("LOG2E")) {
            string2 = "1.4426950408889633";
        } else if (string.equals("SQRT1_2")) {
            string2 = "0.7071067811865476";
        } else {
            throw new XPathException.Dynamic("Unknown math constant " + string);
        }
        int n = (int)d;
        String string3 = string2.substring(0, n + 2);
        double d2 = new Double(string3);
        return d2;
    }

    public static double log(double d) throws XPathException {
        return java.lang.Math.log(d);
    }

    public static double random() throws XPathException {
        return java.lang.Math.random();
    }

    public static double sin(double d) throws XPathException {
        return java.lang.Math.sin(d);
    }

    public static double cos(double d) throws XPathException {
        return java.lang.Math.cos(d);
    }

    public static double tan(double d) throws XPathException {
        return java.lang.Math.tan(d);
    }

    public static double asin(double d) throws XPathException {
        return java.lang.Math.asin(d);
    }

    public static double acos(double d) throws XPathException {
        return java.lang.Math.acos(d);
    }

    public static double atan(double d) throws XPathException {
        return java.lang.Math.atan(d);
    }

    public static double atan2(double d, double d2) throws XPathException {
        return java.lang.Math.atan2(d, d2);
    }

    public static double exp(double d) throws XPathException {
        return java.lang.Math.exp(d);
    }
}

