/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.expr.ComputedExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.MappingFunction;
import net.sf.saxon.expr.MappingIterator;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.value.Type;
import net.sf.saxon.value.UntypedAtomicValue;
import net.sf.saxon.xpath.XPathException;

public final class UntypedAtomicConverter
extends ComputedExpression
implements MappingFunction {
    private Expression sequence;
    private int requiredItemType;

    public UntypedAtomicConverter(Expression expression, int n) {
        this.sequence = expression;
        this.requiredItemType = n;
    }

    public Expression simplify() throws XPathException {
        this.sequence = this.sequence.simplify();
        return this;
    }

    public Expression analyze(StaticContext staticContext) throws XPathException {
        this.sequence = this.sequence.analyze(staticContext);
        int n = this.sequence.getItemType();
        if (Type.isSubType(n, 0)) {
            return this;
        }
        if (n == 90 || n == 88 || n == 125) {
            return this;
        }
        return this.sequence;
    }

    public Expression promote(PromotionOffer promotionOffer) throws XPathException {
        this.sequence = this.sequence.promote(promotionOffer);
        return this;
    }

    public Expression[] getSubExpressions() {
        Expression[] expressionArray = new Expression[]{this.sequence};
        return expressionArray;
    }

    public SequenceIterator iterate(XPathContext xPathContext) throws XPathException {
        SequenceIterator sequenceIterator = this.sequence.iterate(xPathContext);
        return new MappingIterator(sequenceIterator, this, null, null);
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        Item item = this.sequence.evaluateItem(xPathContext);
        if (item == null) {
            return null;
        }
        if (item instanceof UntypedAtomicValue) {
            return ((UntypedAtomicValue)item).convert(this.requiredItemType);
        }
        return item;
    }

    public Object map(Item item, XPathContext xPathContext, Object object) throws XPathException {
        if (item instanceof UntypedAtomicValue) {
            return ((UntypedAtomicValue)item).convert(this.requiredItemType);
        }
        return item;
    }

    public int getItemType() {
        return this.sequence.getItemType();
    }

    public int computeCardinality() {
        return this.sequence.getCardinality();
    }

    public void display(int n) {
        System.err.println(ExpressionTool.indent(n) + "convert untyped atomic items to " + Type.getTypeName(this.requiredItemType));
        this.sequence.display(n + 1);
    }
}

