/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sf.saxon.expr.Binding;
import net.sf.saxon.expr.BindingReference;
import net.sf.saxon.expr.VariableDeclaration;
import net.sf.saxon.expr.VariableReference;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.Type;
import net.sf.saxon.value.Value;

public class RangeVariableDeclaration
implements VariableDeclaration {
    private int variableFingerprint;
    private SequenceType requiredType;
    private String variableName;
    private List references = new ArrayList();

    public void setVariableFingerprint(int n) {
        this.variableFingerprint = n;
    }

    public int getVariableFingerprint() {
        return this.variableFingerprint;
    }

    public SequenceType getRequiredType() {
        return this.requiredType;
    }

    public void setRequiredType(SequenceType sequenceType) {
        this.requiredType = sequenceType;
    }

    public void setVariableName(String string) {
        this.variableName = string;
    }

    public String getVariableName() {
        return this.variableName;
    }

    public void registerReference(BindingReference bindingReference) {
        this.references.add(bindingReference);
    }

    public void fixupReferences(Binding binding) {
        Iterator iterator = this.references.iterator();
        while (iterator.hasNext()) {
            BindingReference bindingReference = (BindingReference)iterator.next();
            bindingReference.setStaticType(this.requiredType, null, 0);
            bindingReference.fixup(binding);
        }
    }

    public void refineTypeInformation(int n, Value value, int n2) {
        Iterator iterator = this.references.iterator();
        while (iterator.hasNext()) {
            int n3;
            BindingReference bindingReference = (BindingReference)iterator.next();
            if (!(bindingReference instanceof VariableReference)) continue;
            int n4 = n3 = ((VariableReference)bindingReference).getItemType();
            if (Type.isSubType(n, n3)) {
                n4 = n;
            }
            SequenceType sequenceType = new SequenceType(n4, 88, ((VariableReference)bindingReference).getCardinality());
            bindingReference.setStaticType(sequenceType, value, n2);
        }
    }
}

