/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.expr.Assignation;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.Tokenizer;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.Value;
import net.sf.saxon.xpath.XPathException;

class QuantifiedExpression
extends Assignation {
    private int operator;

    QuantifiedExpression() {
    }

    public void setOperator(int n) {
        this.operator = n;
    }

    public int computeCardinality() {
        return 512;
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        return BooleanValue.get(this.effectiveBooleanValue(xPathContext));
    }

    public boolean effectiveBooleanValue(XPathContext xPathContext) throws XPathException {
        SequenceIterator sequenceIterator = this.sequence.iterate(xPathContext);
        boolean bl = this.operator == 31;
        while (sequenceIterator.hasNext()) {
            xPathContext.setLocalVariable(this.slotNumber, Value.asValue(sequenceIterator.next()));
            if (bl != this.action.effectiveBooleanValue(xPathContext)) continue;
            return bl;
        }
        return !bl;
    }

    public int getItemType() {
        return 102;
    }

    public SequenceType getRequiredType() {
        return new SequenceType(this.sequence.getItemType(), 88, 512);
    }

    public void display(int n) {
        System.err.println(ExpressionTool.indent(n) + Tokenizer.tokens[this.operator] + " $" + this.getVariableName() + " in");
        this.sequence.display(n + 1);
        System.err.println(ExpressionTool.indent(n) + "satisfies");
        this.action.display(n + 1);
    }
}

