/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import java.util.Comparator;
import net.sf.saxon.expr.BinaryExpression;
import net.sf.saxon.expr.ComputedExpression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.sort.AtomicComparer;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.xpath.XPathException;

public class MinimaxComparison
extends BinaryExpression {
    private AtomicComparer comparer;

    public MinimaxComparison(ComputedExpression computedExpression, int n, ComputedExpression computedExpression2) {
        super(computedExpression, n, computedExpression2);
    }

    public void setComparator(AtomicComparer atomicComparer) {
        this.comparer = atomicComparer;
    }

    public int getItemType() {
        return 102;
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        return BooleanValue.get(this.effectiveBooleanValue(xPathContext));
    }

    public boolean effectiveBooleanValue(XPathContext xPathContext) throws XPathException {
        AtomicValue[] atomicValueArray = MinimaxComparison.getRange(this.operands[0].iterate(xPathContext), this.comparer);
        AtomicValue[] atomicValueArray2 = MinimaxComparison.getRange(this.operands[1].iterate(xPathContext), this.comparer);
        if (atomicValueArray == null) {
            return false;
        }
        if (atomicValueArray2 == null) {
            return false;
        }
        switch (this.operator) {
            case 47: {
                return this.comparer.compare(atomicValueArray[0], atomicValueArray2[1]) < 0;
            }
            case 49: {
                return this.comparer.compare(atomicValueArray[0], atomicValueArray2[1]) <= 0;
            }
            case 46: {
                return this.comparer.compare(atomicValueArray[1], atomicValueArray2[0]) > 0;
            }
            case 48: {
                return this.comparer.compare(atomicValueArray[1], atomicValueArray2[0]) >= 0;
            }
        }
        throw new UnsupportedOperationException("Unknown operator " + this.operator);
    }

    private static AtomicValue[] getRange(SequenceIterator sequenceIterator, Comparator comparator) throws XPathException {
        AtomicValue[] atomicValueArray = null;
        while (sequenceIterator.hasNext()) {
            AtomicValue atomicValue = (AtomicValue)sequenceIterator.next();
            if (atomicValueArray == null) {
                atomicValueArray = new AtomicValue[]{atomicValue, atomicValue};
                continue;
            }
            if (comparator.compare(atomicValue, atomicValueArray[0]) < 0) {
                atomicValueArray[0] = atomicValue;
            }
            if (comparator.compare(atomicValue, atomicValueArray[1]) <= 0) continue;
            atomicValueArray[1] = atomicValue;
        }
        return atomicValueArray;
    }
}

