/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.expr.MappingFunction;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.xpath.XPathException;

public final class MappingIterator
implements SequenceIterator {
    private SequenceIterator base;
    private MappingFunction action;
    private XPathContext context;
    private Object info;
    private SequenceIterator results = null;
    private Item nextItem = null;
    private Item current = null;
    private int position = 0;
    private boolean pending;

    public MappingIterator(SequenceIterator sequenceIterator, MappingFunction mappingFunction, XPathContext xPathContext, Object object) throws XPathException {
        this.base = sequenceIterator;
        this.action = mappingFunction;
        this.context = xPathContext;
        this.info = object;
        this.pending = true;
    }

    private void advance() throws XPathException {
        block4: {
            block5: {
                while (true) {
                    if (this.results != null) {
                        if (this.results.hasNext()) {
                            this.nextItem = this.results.next();
                            break block4;
                        }
                        this.results = null;
                    }
                    if (!this.base.hasNext()) break block5;
                    Item item = this.base.next();
                    Object object = this.action.map(item, this.context, this.info);
                    if (object == null) continue;
                    if (object instanceof Item) {
                        this.nextItem = (Item)object;
                        this.results = null;
                        break block4;
                    }
                    this.results = (SequenceIterator)object;
                    if (this.results.hasNext()) break;
                }
                this.nextItem = this.results.next();
                break block4;
            }
            this.results = null;
            this.nextItem = null;
        }
    }

    public boolean hasNext() throws XPathException {
        if (this.pending) {
            this.advance();
            this.pending = false;
        }
        return this.nextItem != null;
    }

    public Item next() throws XPathException {
        this.current = this.nextItem;
        ++this.position;
        this.pending = true;
        return this.current;
    }

    public Item current() {
        return this.current;
    }

    public int position() {
        return this.position;
    }

    public SequenceIterator getAnother() throws XPathException {
        SequenceIterator sequenceIterator = this.base.getAnother();
        XPathContext xPathContext = this.context;
        if (xPathContext != null) {
            xPathContext = xPathContext.newContext();
            xPathContext.setCurrentIterator(sequenceIterator);
        }
        return new MappingIterator(sequenceIterator, this.action, xPathContext, this.info);
    }
}

