/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.expr.Assignation;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.VariableReference;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.Value;
import net.sf.saxon.xpath.XPathException;

public class LetExpression
extends Assignation {
    public SequenceIterator iterate(XPathContext xPathContext) throws XPathException {
        Value value = ExpressionTool.lazyEvaluate(this.sequence, xPathContext);
        xPathContext.setLocalVariable(this.slotNumber, value);
        return this.action.iterate(xPathContext);
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        Value value = ExpressionTool.lazyEvaluate(this.sequence, xPathContext);
        xPathContext.setLocalVariable(this.slotNumber, value);
        return this.action.evaluateItem(xPathContext);
    }

    public int getItemType() {
        return this.action.getItemType();
    }

    public SequenceType getRequiredType() {
        return new SequenceType(this.sequence.getItemType(), 88, this.sequence.getCardinality());
    }

    public int computeCardinality() {
        return this.action.getCardinality();
    }

    public int computeSpecialProperties() {
        return this.action.getSpecialProperties();
    }

    public boolean markTailFunctionCalls() {
        return ExpressionTool.markTailFunctionCalls(this.action);
    }

    public Expression promote(PromotionOffer promotionOffer) throws XPathException {
        Expression expression = promotionOffer.accept(this);
        if (expression != null) {
            return expression;
        }
        this.sequence = this.sequence.promote(promotionOffer);
        if (promotionOffer.action == 12 || promotionOffer.action == 13) {
            this.action = this.action.promote(promotionOffer);
        }
        if (this.sequence instanceof VariableReference) {
            PromotionOffer promotionOffer2 = new PromotionOffer();
            promotionOffer2.action = 12;
            promotionOffer2.binding = this;
            promotionOffer2.containingExpression = this.sequence;
            this.action = this.action.promote(promotionOffer2);
            return this.action;
        }
        return this;
    }

    public void display(int n) {
        System.err.println(ExpressionTool.indent(n) + "let $" + this.getVariableName() + " :=");
        this.sequence.display(n + 1);
        System.err.println(ExpressionTool.indent(n) + "return");
        this.action.display(n + 1);
    }
}

