/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.expr.ComputedExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.Type;
import net.sf.saxon.value.Value;
import net.sf.saxon.xpath.XPathException;

public final class InstanceOfExpression
extends ComputedExpression {
    Expression source;
    int targetType;
    int targetCardinality;
    int targetContentType;

    public InstanceOfExpression(Expression expression, SequenceType sequenceType) throws XPathException {
        this.source = expression;
        this.targetType = sequenceType.getPrimaryType();
        this.targetCardinality = sequenceType.getCardinality();
        this.targetContentType = sequenceType.getContentType();
    }

    public Expression simplify() throws XPathException {
        this.source = this.source.simplify();
        return this;
    }

    public Expression analyze(StaticContext staticContext) throws XPathException {
        this.source = this.source.analyze(staticContext);
        if (this.source instanceof Value) {
            return (BooleanValue)this.evaluateItem(null);
        }
        if (Cardinality.subsumes(this.targetCardinality, this.source.getCardinality()) && Type.isSubType(this.source.getItemType(), this.targetType)) {
            if (this.targetContentType == 88) {
                return BooleanValue.get(true);
            }
            return this;
        }
        return this;
    }

    public Expression promote(PromotionOffer promotionOffer) throws XPathException {
        this.source = this.source.promote(promotionOffer);
        return this;
    }

    public Expression[] getSubExpressions() {
        Expression[] expressionArray = new Expression[]{this.source};
        return expressionArray;
    }

    public int computeCardinality() {
        return 512;
    }

    public int getItemType() {
        return 102;
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        return BooleanValue.get(this.effectiveBooleanValue(xPathContext));
    }

    public boolean effectiveBooleanValue(XPathContext xPathContext) throws XPathException {
        SequenceIterator sequenceIterator = this.source.iterate(xPathContext);
        int n = 0;
        while (sequenceIterator.hasNext()) {
            Item item = sequenceIterator.next();
            ++n;
            if (!Type.isSubType(item.getItemType(), this.targetType)) {
                return false;
            }
            if (this.targetContentType != 88 && !Type.isSubType(item.getTypedValue().getItemType(), this.targetContentType)) {
                return false;
            }
            if (n != 2 || Cardinality.allowsMany(this.targetCardinality)) continue;
            return false;
        }
        return n != 0 || (this.targetCardinality & 0x100) != 0;
    }

    public void display(int n) {
        System.err.println(ExpressionTool.indent(n) + "instance of");
        this.source.display(n + 1);
        System.err.println(ExpressionTool.indent(n + 1) + Type.getTypeName(this.targetType) + Cardinality.getOccurrenceIndicator(this.targetCardinality));
    }
}

