/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import java.util.Comparator;
import net.sf.saxon.expr.BinaryExpression;
import net.sf.saxon.expr.CastExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.RoleLocator;
import net.sf.saxon.expr.SingletonComparison;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.Tokenizer;
import net.sf.saxon.expr.TypeChecker;
import net.sf.saxon.expr.ValueComparison;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.Item;
import net.sf.saxon.sort.AtomicComparer;
import net.sf.saxon.sort.CodepointCollator;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.SequenceExtent;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.Type;
import net.sf.saxon.value.UntypedAtomicValue;
import net.sf.saxon.value.Value;
import net.sf.saxon.xpath.XPathException;

public class GeneralComparison
extends BinaryExpression {
    private int singletonOperator;
    private AtomicComparer comparer;
    private boolean backwardsCompatible = false;

    public GeneralComparison(Expression expression, int n, Expression expression2) {
        super(expression, n, expression2);
    }

    public void setDetails(Expression expression, int n, Expression expression2) {
        super.setDetails(expression, n, expression2);
        this.singletonOperator = GeneralComparison.getSingletonOperator(n);
    }

    public Expression analyze(StaticContext staticContext) throws XPathException {
        int n;
        int n2;
        this.backwardsCompatible = staticContext.isInBackwardsCompatibleMode();
        this.operands[0] = this.operands[0].analyze(staticContext);
        this.operands[1] = this.operands[1].analyze(staticContext);
        this.operands[0] = ExpressionTool.unsorted(this.operands[0], false);
        this.operands[1] = ExpressionTool.unsorted(this.operands[1], false);
        this.issueWarnings(this.operands[0].getItemType(), this.operands[1].getItemType(), staticContext);
        SequenceType sequenceType = new SequenceType(90, 88, 1792);
        RoleLocator roleLocator = new RoleLocator(1, Tokenizer.tokens[this.operator], 0);
        this.operands[0] = TypeChecker.staticTypeCheck(this.operands[0], sequenceType, false, roleLocator);
        RoleLocator roleLocator2 = new RoleLocator(1, Tokenizer.tokens[this.operator], 1);
        this.operands[1] = TypeChecker.staticTypeCheck(this.operands[1], sequenceType, false, roleLocator2);
        int n3 = this.operands[0].getItemType();
        int n4 = this.operands[1].getItemType();
        int n5 = this.operands[0].getCardinality();
        int n6 = this.operands[1].getCardinality();
        if (!this.backwardsCompatible && n3 != 90 && n3 != 125 && n4 != 90 && n4 != 125 && (n2 = Type.getPrimitiveType(n3)) != (n = Type.getPrimitiveType(n4))) {
            throw new XPathException.Type("Cannot compare " + Type.getTypeName(n3) + " to " + Type.getTypeName(n4));
        }
        if (!(n5 != 512 || n6 != 512 || this.backwardsCompatible && n3 != n4)) {
            Expression expression = this.operands[0];
            Expression expression2 = this.operands[1];
            if (n3 == 125) {
                if (n4 == 125) {
                    expression = new CastExpression(this.operands[0], 101, false);
                    expression2 = new CastExpression(this.operands[1], 101, false);
                } else {
                    expression = Type.isSubType(n4, 91) ? new CastExpression(this.operands[0], 105, false) : new CastExpression(this.operands[0], n4, false);
                }
            } else if (n4 == 125) {
                expression2 = Type.isSubType(n3, 91) ? new CastExpression(this.operands[1], 105, false) : new CastExpression(this.operands[1], n3, false);
            }
            return new ValueComparison(expression, this.singletonOperator, expression2).simplify().analyze(staticContext);
        }
        Comparator comparator = staticContext.getCollation(staticContext.getDefaultCollationName());
        if (comparator == null) {
            comparator = CodepointCollator.getInstance();
        }
        this.comparer = new AtomicComparer(comparator);
        if (!Cardinality.allowsMany(n5) && !Cardinality.allowsMany(n6)) {
            SingletonComparison singletonComparison = new SingletonComparison(this.operands[0], this.singletonOperator, this.operands[1]);
            singletonComparison.setComparator(this.comparer);
            return singletonComparison.analyze(staticContext);
        }
        if (!Cardinality.allowsMany(n5)) {
            GeneralComparison generalComparison = new GeneralComparison(this.operands[1], Value.inverse(this.singletonOperator), this.operands[0]);
            generalComparison.comparer = this.comparer;
            return generalComparison.analyze(staticContext);
        }
        if (this.operands[0] instanceof Value && this.operands[1] instanceof Value) {
            return (BooleanValue)this.evaluateItem(null);
        }
        return this;
    }

    private void issueWarnings(int n, int n2, StaticContext staticContext) {
        if (Type.isSubType(n, 0) && Type.isSubType(n2, 102)) {
            staticContext.issueWarning("Comparison of a node-set to a boolean has changed since XPath 1.0");
        }
        if (Type.isSubType(n, 102) && Type.isSubType(n2, 0)) {
            staticContext.issueWarning("Comparison of a boolean to a node-set has changed since XPath 1.0");
        }
        if ((Type.isSubType(n, 0) || Type.isSubType(n, 101)) && (Type.isSubType(n2, 0) || Type.isSubType(n2, 101)) && (this.operator == 12 || this.operator == 14 || this.operator == 11 || this.operator == 13)) {
            staticContext.issueWarning("Less-than and greater-than comparisons between strings have changed since XPath 1.0");
        }
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        return BooleanValue.get(this.effectiveBooleanValue(xPathContext));
    }

    /*
     * Unable to fully structure code
     */
    public boolean effectiveBooleanValue(XPathContext var1_1) throws XPathException {
        var2_2 = this.operands[0].iterate(var1_1);
        var3_3 = this.operands[1].iterate(var1_1);
        var4_4 = new SequenceExtent(var3_3);
        var5_5 = var4_4.getLength();
        if (var5_5 == 0) {
            return false;
        }
        if (var5_5 != 1) ** GOTO lbl28
        var6_6 = (AtomicValue)var4_4.itemAt(0);
        while (var2_2.hasNext()) {
            var7_8 = (AtomicValue)var2_2.next();
            try {
                if (!GeneralComparison.compare(var7_8, this.singletonOperator, var6_6, this.comparer, this.backwardsCompatible)) continue;
                return true;
            }
            catch (XPathException.Type var8_10) {
                this.typeError(var8_10.getMessage());
            }
        }
        return false;
lbl-1000:
        // 1 sources

        {
            var6_7 = (AtomicValue)var2_2.next();
            var7_9 = var4_4.iterate(null);
            while (var7_9.hasNext()) {
                var8_11 = (AtomicValue)var7_9.next();
                try {
                    if (!GeneralComparison.compare(var6_7, this.singletonOperator, var8_11, this.comparer, this.backwardsCompatible)) continue;
                    return true;
                }
                catch (XPathException.Type var9_12) {
                    this.typeError(var9_12.getMessage());
                }
            }
lbl28:
            // 2 sources

            ** while (var2_2.hasNext())
        }
lbl29:
        // 1 sources

        return false;
    }

    protected static boolean compare(AtomicValue atomicValue, int n, AtomicValue atomicValue2, AtomicComparer atomicComparer, boolean bl) throws XPathException {
        AtomicValue atomicValue3 = atomicValue;
        AtomicValue atomicValue4 = atomicValue2;
        if (atomicValue instanceof UntypedAtomicValue) {
            if (atomicValue2 instanceof NumericValue) {
                atomicValue3 = atomicValue.convert(105);
            } else if (!(atomicValue2 instanceof UntypedAtomicValue)) {
                atomicValue3 = atomicValue.convert(atomicValue2.getItemType());
            }
        }
        if (atomicValue2 instanceof UntypedAtomicValue) {
            if (atomicValue instanceof NumericValue) {
                atomicValue4 = atomicValue2.convert(105);
            } else if (!(atomicValue instanceof UntypedAtomicValue)) {
                atomicValue4 = atomicValue2.convert(atomicValue.getItemType());
            }
        }
        if (bl && (atomicValue3 instanceof NumericValue || atomicValue4 instanceof NumericValue)) {
            atomicValue3 = atomicValue3.convert(105);
            atomicValue4 = atomicValue4.convert(105);
        }
        return ValueComparison.compare(atomicValue3, n, atomicValue4, atomicComparer);
    }

    public int getItemType() {
        return 102;
    }

    private static int getSingletonOperator(int n) {
        switch (n) {
            case 6: {
                return 44;
            }
            case 13: {
                return 48;
            }
            case 22: {
                return 45;
            }
            case 12: {
                return 47;
            }
            case 11: {
                return 46;
            }
            case 14: {
                return 49;
            }
        }
        return n;
    }

    protected String displayOperator() {
        return "many-to-many " + super.displayOperator();
    }
}

