/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import net.sf.saxon.Controller;
import net.sf.saxon.Loader;
import net.sf.saxon.event.Builder;
import net.sf.saxon.event.Sender;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.FunctionCall;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.EmptyIterator;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.Closure;
import net.sf.saxon.value.DecimalValue;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.FloatValue;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.ObjectValue;
import net.sf.saxon.value.SequenceExtent;
import net.sf.saxon.value.SequenceIntent;
import net.sf.saxon.value.SingletonNode;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.Type;
import net.sf.saxon.value.Value;
import net.sf.saxon.xpath.XPathException;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FunctionProxy
extends FunctionCall {
    private Class theClass;
    private transient ArrayList candidateMethods = new ArrayList();
    private XPathException theException = null;
    private String name;
    private Class resultClass = null;
    private boolean debug = false;
    private boolean usesFocus = false;
    private static final Class[] NO_PARAMS = new Class[0];
    static /* synthetic */ Class class$net$sf$saxon$expr$XPathContext;
    static /* synthetic */ Class class$net$sf$saxon$value$Value;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$net$sf$saxon$value$StringValue;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$net$sf$saxon$value$BooleanValue;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$net$sf$saxon$value$DoubleValue;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$net$sf$saxon$value$FloatValue;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$net$sf$saxon$value$IntegerValue;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$net$sf$saxon$value$SequenceValue;
    static /* synthetic */ Class class$net$sf$saxon$om$SequenceIterator;
    static /* synthetic */ Class class$org$w3c$dom$NodeList;
    static /* synthetic */ Class class$net$sf$saxon$om$NodeInfo;
    static /* synthetic */ Class class$org$w3c$dom$Node;
    static /* synthetic */ Class class$javax$xml$transform$Source;
    static /* synthetic */ Class class$java$util$List;
    static /* synthetic */ Class class$net$sf$saxon$value$Closure;
    static /* synthetic */ Class class$net$sf$saxon$functions$Extensions;
    static /* synthetic */ Class class$net$sf$saxon$exslt$Common;
    static /* synthetic */ Class class$net$sf$saxon$exslt$Sets;
    static /* synthetic */ Class class$net$sf$saxon$exslt$Math;
    static /* synthetic */ Class class$net$sf$saxon$exslt$Date;

    public void setDebug(boolean bl) {
        this.debug = bl;
    }

    public boolean setFunctionName(Class clazz, String string) {
        int n;
        boolean bl;
        Method[] methodArray;
        int n2;
        boolean bl2 = false;
        if (this.debug) {
            System.err.println("Looking for method " + string + " in Java class " + clazz);
            System.err.println("Number of actual arguments = " + this.getNumberOfArguments());
        }
        this.name = string;
        int n3 = n2 = this.getNumberOfArguments();
        this.theClass = clazz;
        if (this.name.equals("new")) {
            int n4;
            if (this.debug) {
                System.err.println("Looking for a constructor");
            }
            if (Modifier.isAbstract(n4 = this.theClass.getModifiers())) {
                this.theException = new XPathException.Static("Class " + this.theClass + " is abstract");
            } else if (Modifier.isInterface(n4)) {
                this.theException = new XPathException.Static(this.theClass + " is an interface");
            } else if (Modifier.isPrivate(n4)) {
                this.theException = new XPathException.Static("Class " + this.theClass + " is private");
            } else if (Modifier.isProtected(n4)) {
                this.theException = new XPathException.Static("Class " + this.theClass + " is protected");
            }
            if (this.theException != null) {
                if (this.debug) {
                    System.err.println("Cannot construct an instance: " + this.theException.getMessage());
                }
                return false;
            }
            this.resultClass = this.theClass;
            Constructor<?>[] constructorArray = this.theClass.getConstructors();
            int n5 = 0;
            while (n5 < constructorArray.length) {
                bl2 = true;
                Constructor<?> constructor = constructorArray[n5];
                if (this.debug) {
                    System.err.println("Found a constructor with " + constructor.getParameterTypes().length + " arguments");
                }
                if (constructor.getParameterTypes().length == n2) {
                    this.candidateMethods.add(constructor);
                }
                ++n5;
            }
            if (bl2) {
                return true;
            }
            this.theException = new XPathException.Static("No constructor with " + n2 + (n2 == 1 ? " parameter" : " parameters") + " found in class " + this.theClass.getName());
            if (this.debug) {
                System.err.println(this.theException.getMessage());
            }
            return false;
        }
        if (this.name.indexOf(45) >= 0) {
            methodArray = new StringBuffer();
            bl = false;
            n = 0;
            while (n < this.name.length()) {
                char c = this.name.charAt(n);
                if (c == '-') {
                    bl = true;
                } else {
                    if (bl) {
                        methodArray.append(Character.toUpperCase(c));
                    } else {
                        methodArray.append(c);
                    }
                    bl = false;
                }
                ++n;
            }
            this.name = methodArray.toString();
            if (this.debug) {
                System.err.println("Seeking a method with adjusted name " + this.name);
            }
        }
        methodArray = this.theClass.getMethods();
        bl = true;
        n = 0;
        while (n < methodArray.length) {
            Method method = methodArray[n];
            if (this.debug) {
                if (method.getName().equals(this.name)) {
                    System.err.println("Trying method " + method.getName() + ": name matches");
                    if (!Modifier.isPublic(method.getModifiers())) {
                        System.err.println(" -- but the method is not public");
                    }
                } else {
                    System.err.println("Trying method " + method.getName() + ": name does not match");
                }
            }
            if (method.getName().equals(this.name) && Modifier.isPublic(method.getModifiers())) {
                bl2 = true;
                if (bl) {
                    if (this.resultClass == null) {
                        this.resultClass = method.getReturnType();
                    } else {
                        bl = method.getReturnType() == this.resultClass;
                    }
                }
                Class<?>[] classArray = method.getParameterTypes();
                boolean bl3 = Modifier.isStatic(method.getModifiers());
                if (this.debug) {
                    System.err.println("Method is " + (bl3 ? "" : "not ") + "static");
                }
                int n6 = n3 = bl3 ? n2 : n2 - 1;
                if (n3 >= 0) {
                    if (this.debug) {
                        System.err.println("Method has " + classArray.length + " argument" + (classArray.length == 1 ? "" : "s") + "; expecting " + n3);
                    }
                    if (classArray.length == n3 && (n3 == 0 || classArray[0] != (class$net$sf$saxon$expr$XPathContext == null ? FunctionProxy.class$("net.sf.saxon.expr.XPathContext") : class$net$sf$saxon$expr$XPathContext))) {
                        if (this.debug) {
                            System.err.println("Found a candidate method:");
                            System.err.println("    " + method);
                        }
                        this.candidateMethods.add(method);
                    }
                    if (classArray.length == n3 + 1 && classArray[0] == (class$net$sf$saxon$expr$XPathContext == null ? FunctionProxy.class$("net.sf.saxon.expr.XPathContext") : class$net$sf$saxon$expr$XPathContext)) {
                        if (this.debug) {
                            System.err.println("Method is a candidate because first argument is XPathContext");
                        }
                        this.candidateMethods.add(method);
                        this.usesFocus = true;
                    }
                }
            }
            ++n;
        }
        Field[] fieldArray = this.theClass.getFields();
        int n7 = 0;
        while (n7 < fieldArray.length) {
            Field field = fieldArray[n7];
            if (this.debug) {
                if (field.getName().equals(this.name)) {
                    System.err.println("Trying field " + field.getName() + ": name matches");
                    if (!Modifier.isPublic(field.getModifiers())) {
                        System.err.println(" -- but the field is not public");
                    }
                } else {
                    System.err.println("Trying field " + field.getName() + ": name does not match");
                }
            }
            if (field.getName().equals(this.name) && Modifier.isPublic(field.getModifiers())) {
                bl2 = true;
                if (bl) {
                    if (this.resultClass == null) {
                        this.resultClass = field.getType();
                    } else {
                        bl = field.getType() == this.resultClass;
                    }
                }
                boolean bl4 = Modifier.isStatic(field.getModifiers());
                if (this.debug) {
                    System.err.println("Field is " + (bl4 ? "" : "not ") + "static");
                }
                int n8 = n3 = bl4 ? n2 : n2 - 1;
                if (n3 == 0) {
                    if (this.debug) {
                        System.err.println("Found a candidate field:");
                        System.err.println("    " + field);
                    }
                    this.candidateMethods.add(field);
                }
            }
            ++n7;
        }
        if (!bl) {
            this.resultClass = null;
        }
        if (bl2) {
            return true;
        }
        this.theException = new XPathException.Static("No method or field matching " + this.name + " with " + n3 + (n3 == 1 ? " parameter" : " parameters") + " found in class " + this.theClass.getName());
        if (this.debug) {
            System.err.println(this.theException.getMessage());
        }
        return false;
    }

    public Expression preEvaluate(StaticContext staticContext) {
        return this;
    }

    public void checkArguments(StaticContext staticContext) throws XPathException {
    }

    public int getItemType() {
        if (this.resultClass == null || this.resultClass == (class$net$sf$saxon$value$Value == null ? (class$net$sf$saxon$value$Value = FunctionProxy.class$("net.sf.saxon.value.Value")) : class$net$sf$saxon$value$Value)) {
            return 88;
        }
        if (this.resultClass.toString().equals("void")) {
            return 88;
        }
        if (this.resultClass == (class$java$lang$String == null ? (class$java$lang$String = FunctionProxy.class$("java.lang.String")) : class$java$lang$String) || this.resultClass == (class$net$sf$saxon$value$StringValue == null ? (class$net$sf$saxon$value$StringValue = FunctionProxy.class$("net.sf.saxon.value.StringValue")) : class$net$sf$saxon$value$StringValue)) {
            return 101;
        }
        if (this.resultClass == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = FunctionProxy.class$("java.lang.Boolean")) : class$java$lang$Boolean) || this.resultClass == Boolean.TYPE || this.resultClass == (class$net$sf$saxon$value$BooleanValue == null ? (class$net$sf$saxon$value$BooleanValue = FunctionProxy.class$("net.sf.saxon.value.BooleanValue")) : class$net$sf$saxon$value$BooleanValue)) {
            return 102;
        }
        if (this.resultClass == (class$java$lang$Double == null ? (class$java$lang$Double = FunctionProxy.class$("java.lang.Double")) : class$java$lang$Double) || this.resultClass == Double.TYPE || this.resultClass == (class$net$sf$saxon$value$DoubleValue == null ? (class$net$sf$saxon$value$DoubleValue = FunctionProxy.class$("net.sf.saxon.value.DoubleValue")) : class$net$sf$saxon$value$DoubleValue)) {
            return 105;
        }
        if (this.resultClass == (class$java$lang$Float == null ? (class$java$lang$Float = FunctionProxy.class$("java.lang.Float")) : class$java$lang$Float) || this.resultClass == Float.TYPE || this.resultClass == (class$net$sf$saxon$value$FloatValue == null ? (class$net$sf$saxon$value$FloatValue = FunctionProxy.class$("net.sf.saxon.value.FloatValue")) : class$net$sf$saxon$value$FloatValue)) {
            return 104;
        }
        if (this.resultClass == (class$java$lang$Long == null ? (class$java$lang$Long = FunctionProxy.class$("java.lang.Long")) : class$java$lang$Long) || this.resultClass == Long.TYPE || this.resultClass == (class$net$sf$saxon$value$IntegerValue == null ? (class$net$sf$saxon$value$IntegerValue = FunctionProxy.class$("net.sf.saxon.value.IntegerValue")) : class$net$sf$saxon$value$IntegerValue) || this.resultClass == (class$java$lang$Integer == null ? (class$java$lang$Integer = FunctionProxy.class$("java.lang.Integer")) : class$java$lang$Integer) || this.resultClass == Integer.TYPE || this.resultClass == (class$java$lang$Short == null ? (class$java$lang$Short = FunctionProxy.class$("java.lang.Short")) : class$java$lang$Short) || this.resultClass == Short.TYPE || this.resultClass == (class$java$lang$Byte == null ? (class$java$lang$Byte = FunctionProxy.class$("java.lang.Byte")) : class$java$lang$Byte) || this.resultClass == Byte.TYPE) {
            return 200;
        }
        if ((class$net$sf$saxon$value$SequenceValue == null ? (class$net$sf$saxon$value$SequenceValue = FunctionProxy.class$("net.sf.saxon.value.SequenceValue")) : class$net$sf$saxon$value$SequenceValue).isAssignableFrom(this.resultClass) || (class$net$sf$saxon$om$SequenceIterator == null ? (class$net$sf$saxon$om$SequenceIterator = FunctionProxy.class$("net.sf.saxon.om.SequenceIterator")) : class$net$sf$saxon$om$SequenceIterator).isAssignableFrom(this.resultClass)) {
            return 88;
        }
        if ((class$org$w3c$dom$NodeList == null ? (class$org$w3c$dom$NodeList = FunctionProxy.class$("org.w3c.dom.NodeList")) : class$org$w3c$dom$NodeList).isAssignableFrom(this.resultClass) || (class$net$sf$saxon$om$NodeInfo == null ? (class$net$sf$saxon$om$NodeInfo = FunctionProxy.class$("net.sf.saxon.om.NodeInfo")) : class$net$sf$saxon$om$NodeInfo).isAssignableFrom(this.resultClass) || (class$org$w3c$dom$Node == null ? (class$org$w3c$dom$Node = FunctionProxy.class$("org.w3c.dom.Node")) : class$org$w3c$dom$Node).isAssignableFrom(this.resultClass) || (class$javax$xml$transform$Source == null ? (class$javax$xml$transform$Source = FunctionProxy.class$("javax.xml.transform.Source")) : class$javax$xml$transform$Source).isAssignableFrom(this.resultClass)) {
            return 0;
        }
        return 88;
    }

    public int computeCardinality() {
        if (this.resultClass == null) {
            return 1792;
        }
        if ((class$net$sf$saxon$value$SequenceValue == null ? (class$net$sf$saxon$value$SequenceValue = FunctionProxy.class$("net.sf.saxon.value.SequenceValue")) : class$net$sf$saxon$value$SequenceValue).isAssignableFrom(this.resultClass) || (class$net$sf$saxon$om$SequenceIterator == null ? (class$net$sf$saxon$om$SequenceIterator = FunctionProxy.class$("net.sf.saxon.om.SequenceIterator")) : class$net$sf$saxon$om$SequenceIterator).isAssignableFrom(this.resultClass) || (class$org$w3c$dom$NodeList == null ? (class$org$w3c$dom$NodeList = FunctionProxy.class$("org.w3c.dom.NodeList")) : class$org$w3c$dom$NodeList).isAssignableFrom(this.resultClass) || (class$java$util$List == null ? (class$java$util$List = FunctionProxy.class$("java.util.List")) : class$java$util$List).isAssignableFrom(this.resultClass) || (class$net$sf$saxon$value$Closure == null ? (class$net$sf$saxon$value$Closure = FunctionProxy.class$("net.sf.saxon.value.Closure")) : class$net$sf$saxon$value$Closure).isAssignableFrom(this.resultClass) || (class$javax$xml$transform$Source == null ? (class$javax$xml$transform$Source = FunctionProxy.class$("javax.xml.transform.Source")) : class$javax$xml$transform$Source).isAssignableFrom(this.resultClass)) {
            return 1792;
        }
        if (this.resultClass.isPrimitive()) {
            if (this.resultClass.equals(Void.TYPE)) {
                return 768;
            }
            return 512;
        }
        return 768;
    }

    public String getName() {
        return this.name;
    }

    public Expression analyze(StaticContext staticContext) throws XPathException {
        int n;
        super.analyze(staticContext);
        if (this.debug) {
            System.err.println("Attempting to bind method for external function " + this.name);
        }
        if (this.candidateMethods.size() > 1) {
            n = 1;
            int n2 = 0;
            while (n2 < this.getNumberOfArguments()) {
                int n3 = this.argument[n2].getItemType();
                if (n3 == 90 || n3 == 130 || n3 == 88 || Type.isNodeType(n3)) {
                    n = 0;
                    break;
                }
                ++n2;
            }
            if (n != 0) {
                Value[] valueArray = new Value[this.getNumberOfArguments()];
                int n4 = 0;
                while (n4 < this.getNumberOfArguments()) {
                    switch (this.argument[n4].getItemType()) {
                        case 102: {
                            valueArray[n4] = BooleanValue.TRUE;
                            break;
                        }
                        case 103: {
                            valueArray[n4] = new DecimalValue("1.0");
                            break;
                        }
                        case 200: {
                            valueArray[n4] = new IntegerValue(1L);
                            break;
                        }
                        case 104: {
                            valueArray[n4] = new FloatValue(1.0f);
                            break;
                        }
                        case 105: {
                            valueArray[n4] = new DoubleValue(1.0);
                            break;
                        }
                        case 101: {
                            valueArray[n4] = StringValue.EMPTY_STRING;
                            break;
                        }
                        case 0: {
                            valueArray[n4] = new SingletonNode(null);
                        }
                    }
                    ++n4;
                }
                try {
                    AccessibleObject accessibleObject = this.getBestFit(valueArray);
                    this.candidateMethods = new ArrayList();
                    this.candidateMethods.add(accessibleObject);
                }
                catch (XPathException xPathException) {
                    this.theException = xPathException;
                }
            }
        }
        if (this.debug) {
            n = this.candidateMethods.size();
            System.err.println("There " + (n == 1 ? "is " : "are ") + n + " candidate method" + (n == 1 ? "" : "s"));
        }
        return this;
    }

    public int getIntrinsicDependencies() {
        if (this.usesFocus) {
            return 14;
        }
        return 0;
    }

    public AccessibleObject getBestFit(Value[] valueArray) throws XPathException {
        int[] nArray;
        int n;
        int n2;
        if (this.candidateMethods == null) {
            this.candidateMethods = new ArrayList();
            this.setFunctionName(this.theClass, this.name);
        }
        if ((n2 = this.candidateMethods.size()) == 0) {
            this.dynamicError("There is no suitable method matching the arguments of function " + this.name);
            return null;
        }
        if (n2 == 1) {
            return (AccessibleObject)this.candidateMethods.get(0);
        }
        if (this.debug) {
            System.err.println("Finding best fit method for " + this.name + " with arguments:");
            int n3 = 0;
            while (n3 < valueArray.length) {
                valueArray[n3].display(10);
                ++n3;
            }
        }
        boolean[] blArray = new boolean[n2];
        int n4 = 0;
        while (n4 < n2) {
            blArray[n4] = false;
            ++n4;
        }
        if (this.debug) {
            n = 0;
            while (n < n2) {
                nArray = this.getConversionPreferences(valueArray, this.candidateMethods.get(n));
                System.err.println("Trying option " + n + ": " + this.candidateMethods.get(n).toString());
                String string = "[";
                int n5 = 0;
                while (n5 < nArray.length) {
                    if (n5 != 0) {
                        string = string + ", ";
                    }
                    string = string + nArray[n5];
                    ++n5;
                }
                string = string + "]";
                System.err.println("Conversion preferences are " + string);
                ++n;
            }
        }
        n = 0;
        while (n < n2 - 1) {
            nArray = this.getConversionPreferences(valueArray, this.candidateMethods.get(n));
            if (!blArray[n]) {
                int n6 = n + 1;
                while (n6 < n2) {
                    if (!blArray[n6]) {
                        int[] nArray2 = this.getConversionPreferences(valueArray, this.candidateMethods.get(n6));
                        int n7 = 0;
                        while (n7 < nArray2.length) {
                            if (nArray[n7] > nArray2[n7] && !blArray[n]) {
                                blArray[n] = true;
                                if (this.debug) {
                                    System.err.println("Eliminating option " + n);
                                }
                            }
                            if (nArray[n7] < nArray2[n7] && !blArray[n6]) {
                                blArray[n6] = true;
                                if (this.debug) {
                                    System.err.println("Eliminating option " + n6);
                                }
                            }
                            ++n7;
                        }
                    }
                    ++n6;
                }
            }
            ++n;
        }
        int n8 = 0;
        AccessibleObject accessibleObject = null;
        int n9 = 0;
        while (n9 < n2) {
            if (!blArray[n9]) {
                accessibleObject = (AccessibleObject)this.candidateMethods.get(n9);
                ++n8;
            }
            ++n9;
        }
        if (this.debug) {
            System.err.println("Number of candidate methods remaining: " + n8);
        }
        if (n8 == 0) {
            this.dynamicError("There are " + n2 + " candidate Java methods matching function " + this.name + ", but none is a unique best match");
            return null;
        }
        if (n8 > 1) {
            this.dynamicError("There are several Java methods that match function " + this.name + " equally well");
            return null;
        }
        return accessibleObject;
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        Object object = this.call(xPathContext);
        if (object == null) {
            return null;
        }
        Value value = FunctionProxy.convertJavaObjectToXPath(object, xPathContext.getController());
        return Value.asItem(value, xPathContext);
    }

    public SequenceIterator iterate(XPathContext xPathContext) throws XPathException {
        if (this.resultClass == (class$net$sf$saxon$om$SequenceIterator == null ? (class$net$sf$saxon$om$SequenceIterator = FunctionProxy.class$("net.sf.saxon.om.SequenceIterator")) : class$net$sf$saxon$om$SequenceIterator)) {
            return (SequenceIterator)this.call(xPathContext);
        }
        Object object = this.call(xPathContext);
        if (object == null) {
            return EmptyIterator.getInstance();
        }
        Value value = FunctionProxy.convertJavaObjectToXPath(object, xPathContext.getController());
        return value.iterate(xPathContext);
    }

    private Object call(XPathContext xPathContext) throws XPathException {
        if (this.theException != null) {
            throw this.theException;
        }
        Value[] valueArray = new Value[this.getNumberOfArguments()];
        int n = 0;
        while (n < this.getNumberOfArguments()) {
            valueArray[n] = ExpressionTool.lazyEvaluate(this.argument[n], xPathContext);
            ++n;
        }
        AccessibleObject accessibleObject = this.getBestFit(valueArray);
        if (this.debug) {
            System.err.println("Calling extension function " + accessibleObject);
        }
        if (accessibleObject instanceof Constructor) {
            Constructor constructor = (Constructor)accessibleObject;
            Class[] classArray = constructor.getParameterTypes();
            Object[] objectArray = new Object[classArray.length];
            this.setupParams(valueArray, objectArray, classArray, 0, 0);
            try {
                Object t = constructor.newInstance(objectArray);
                return t;
            }
            catch (InstantiationException instantiationException) {
                throw new XPathException.Dynamic("Cannot instantiate class", instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new XPathException.Dynamic("Constructor access is illegal", illegalAccessException);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new XPathException.Dynamic("Argument is of wrong type", illegalArgumentException);
            }
            catch (NullPointerException nullPointerException) {
                throw new XPathException.Dynamic("Object is null");
            }
            catch (InvocationTargetException invocationTargetException) {
                Throwable throwable = invocationTargetException.getTargetException();
                if (throwable instanceof XPathException) {
                    throw (XPathException)throwable;
                }
                if (this.debug || xPathContext.getController().isTracing()) {
                    invocationTargetException.getTargetException().printStackTrace();
                }
                throw new XPathException.Dynamic("Exception in extension function " + this.getName() + ": " + invocationTargetException.getTargetException().toString(), throwable);
            }
        }
        if (accessibleObject instanceof Method) {
            Object[] objectArray;
            int n2;
            Object object;
            boolean bl;
            Method method = (Method)accessibleObject;
            boolean bl2 = Modifier.isStatic(method.getModifiers());
            Class[] classArray = method.getParameterTypes();
            boolean bl3 = classArray.length > 0 && classArray[0] == (class$net$sf$saxon$expr$XPathContext == null ? (class$net$sf$saxon$expr$XPathContext = FunctionProxy.class$("net.sf.saxon.expr.XPathContext")) : class$net$sf$saxon$expr$XPathContext) ? true : (bl = false);
            if (bl2) {
                object = null;
            } else {
                n2 = this.getNumberOfArguments();
                if (n2 == 0) {
                    this.dynamicError("Must supply an argument for an instance-level extension function");
                    return null;
                }
                objectArray = valueArray[0];
                object = objectArray.convertToJava(this.theClass);
            }
            n2 = classArray.length - (bl ? 1 : 0) + (bl2 ? 0 : 1);
            this.checkArgumentCount(n2, n2);
            objectArray = new Object[classArray.length];
            if (bl) {
                objectArray[0] = xPathContext;
            }
            this.setupParams(valueArray, objectArray, classArray, bl ? 1 : 0, bl2 ? 0 : 1);
            try {
                Object object2 = method.invoke(object, objectArray);
                if (method.getReturnType().toString().equals("void")) {
                    return EmptySequence.getInstance();
                }
                return object2;
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new XPathException.Dynamic("Method access is illegal", illegalAccessException);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new XPathException.Dynamic("Argument is of wrong type", illegalArgumentException);
            }
            catch (NullPointerException nullPointerException) {
                throw new XPathException.Dynamic("Object is null", nullPointerException);
            }
            catch (InvocationTargetException invocationTargetException) {
                Throwable throwable = invocationTargetException.getTargetException();
                if (throwable instanceof XPathException) {
                    throw (XPathException)throwable;
                }
                if (this.debug || xPathContext.getController().isTracing()) {
                    invocationTargetException.getTargetException().printStackTrace();
                }
                throw new XPathException.Dynamic("Exception in extension function " + invocationTargetException.getTargetException().toString(), throwable);
            }
        }
        if (accessibleObject instanceof Field) {
            Object object;
            Field field = (Field)accessibleObject;
            boolean bl = Modifier.isStatic(field.getModifiers());
            if (bl) {
                object = null;
            } else {
                int n3 = this.getNumberOfArguments();
                if (n3 == 0) {
                    this.dynamicError("Must supply an argument for an instance-level extension function");
                    return null;
                }
                Value value = valueArray[0];
                object = value.convertToJava(this.theClass);
            }
            this.checkArgumentCount(0, 0);
            try {
                Object object3 = field.get(object);
                return object3;
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new XPathException.Dynamic("Field access is illegal", illegalAccessException);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new XPathException.Dynamic("Argument is of wrong type", illegalArgumentException);
            }
        }
        throw new AssertionError((Object)("property " + accessibleObject + " was neither constructor, method, nor field"));
    }

    public static Class getVendorExtensionClass(String string) {
        if (string.equals("http://saxon.sf.net/")) {
            return class$net$sf$saxon$functions$Extensions == null ? (class$net$sf$saxon$functions$Extensions = FunctionProxy.class$("net.sf.saxon.functions.Extensions")) : class$net$sf$saxon$functions$Extensions;
        }
        if (string.equals("http://exslt.org/common")) {
            return class$net$sf$saxon$exslt$Common == null ? (class$net$sf$saxon$exslt$Common = FunctionProxy.class$("net.sf.saxon.exslt.Common")) : class$net$sf$saxon$exslt$Common;
        }
        if (string.equals("http://exslt.org/sets")) {
            return class$net$sf$saxon$exslt$Sets == null ? (class$net$sf$saxon$exslt$Sets = FunctionProxy.class$("net.sf.saxon.exslt.Sets")) : class$net$sf$saxon$exslt$Sets;
        }
        if (string.equals("http://exslt.org/math")) {
            return class$net$sf$saxon$exslt$Math == null ? (class$net$sf$saxon$exslt$Math = FunctionProxy.class$("net.sf.saxon.exslt.Math")) : class$net$sf$saxon$exslt$Math;
        }
        if (string.equals("http://exslt.org/dates-and-times")) {
            return class$net$sf$saxon$exslt$Date == null ? (class$net$sf$saxon$exslt$Date = FunctionProxy.class$("net.sf.saxon.exslt.Date")) : class$net$sf$saxon$exslt$Date;
        }
        return null;
    }

    public static Class getImplicitJavaClass(String string) {
        try {
            if (string.startsWith("java:")) {
                return Loader.getClass(string.substring(5));
            }
            int n = string.lastIndexOf(47);
            if (n < 0) {
                return Loader.getClass(string);
            }
            if (n == string.length() - 1) {
                return null;
            }
            return Loader.getClass(string.substring(n + 1));
        }
        catch (TransformerException transformerException) {
            return null;
        }
    }

    public static Value convertJavaObjectToXPath(Object object, Controller controller) throws XPathException {
        if (object == null) {
            return null;
        }
        if (object instanceof String) {
            return new StringValue((String)object);
        }
        if (object instanceof Character) {
            return new StringValue(object.toString());
        }
        if (object instanceof Boolean) {
            return BooleanValue.get((Boolean)object);
        }
        if (object instanceof Double) {
            return new DoubleValue((Double)object);
        }
        if (object instanceof Float) {
            return new FloatValue(((Float)object).floatValue());
        }
        if (object instanceof Short) {
            return new IntegerValue(((Short)object).shortValue(), 205);
        }
        if (object instanceof Integer) {
            return new IntegerValue(((Integer)object).intValue(), 204);
        }
        if (object instanceof Long) {
            return new IntegerValue((Long)object, 203);
        }
        if (object instanceof Byte) {
            return new IntegerValue(((Byte)object).byteValue(), 206);
        }
        if (object instanceof Closure) {
            return ExpressionTool.eagerEvaluate((Closure)object, null);
        }
        if (object instanceof Value) {
            return (Value)object;
        }
        if (object instanceof NodeInfo) {
            return new SingletonNode((NodeInfo)object);
        }
        if (object instanceof SequenceIterator) {
            return new SequenceIntent((SequenceIterator)object);
        }
        if (object instanceof List) {
            Item[] itemArray = new Item[((List)object).size()];
            int n = 0;
            Iterator iterator = ((List)object).iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (e instanceof NodeInfo) {
                    itemArray[n++] = (NodeInfo)e;
                    continue;
                }
                Value value = FunctionProxy.convertJavaObjectToXPath(e, controller);
                if (value == null) continue;
                if (value instanceof Item) {
                    itemArray[n++] = (Item)((Object)value);
                    continue;
                }
                throw new XPathException.Dynamic("Returned List contains an object that cannot be converted to an Item (" + e.getClass() + ")");
            }
            return new SequenceExtent(itemArray);
        }
        if (object instanceof Object[]) {
            Item[] itemArray = new Item[((Object[])object).length];
            int n = 0;
            int n2 = 0;
            while (n2 < ((Object[])object).length) {
                Object object2 = ((Object[])object)[n2];
                if (object2 instanceof NodeInfo) {
                    itemArray[n++] = (NodeInfo)object2;
                } else {
                    Value value = FunctionProxy.convertJavaObjectToXPath(object2, controller);
                    if (value != null) {
                        if (value instanceof Item) {
                            itemArray[n++] = (Item)((Object)value);
                        } else {
                            throw new XPathException.Dynamic("Returned array contains an object that cannot be converted to an Item (" + object2.getClass() + ")");
                        }
                    }
                }
                ++n2;
            }
            return new SequenceExtent(itemArray);
        }
        if (object instanceof Source && controller != null) {
            try {
                Builder builder = controller.makeBuilder();
                new Sender(controller.getConfiguration()).send((Source)object, builder, controller.getNamePool(), false);
                return new SingletonNode(builder.getCurrentDocument());
            }
            catch (TransformerException transformerException) {
                throw new XPathException.Dynamic(transformerException);
            }
        }
        if (object instanceof NodeList) {
            NodeList nodeList = (NodeList)object;
            Item[] itemArray = new NodeInfo[nodeList.getLength()];
            int n = 0;
            while (n < nodeList.getLength()) {
                if (!(nodeList.item(n) instanceof NodeInfo)) {
                    throw new XPathException.Dynamic("Supplied NodeList contains non-Saxon DOM Nodes");
                }
                itemArray[n] = (NodeInfo)((Object)nodeList.item(n));
                ++n;
            }
            return new SequenceExtent(itemArray);
        }
        if (object instanceof Node) {
            throw new XPathException.Dynamic("Supplied Java object is a non-Saxon DOM Node");
        }
        return new ObjectValue(object);
    }

    private int[] getConversionPreferences(Value[] valueArray, Object object) {
        int n;
        Class<?>[] classArray;
        int n2;
        if (object instanceof Constructor) {
            n2 = 0;
            classArray = ((Constructor)object).getParameterTypes();
        } else if (object instanceof Method) {
            n = Modifier.isStatic(((Method)object).getModifiers());
            n2 = n != 0 ? 0 : 1;
            classArray = ((Method)object).getParameterTypes();
        } else if (object instanceof Field) {
            n = Modifier.isStatic(((Field)object).getModifiers());
            n2 = n != 0 ? 0 : 1;
            classArray = NO_PARAMS;
        } else {
            throw new AssertionError((Object)("property " + object + " was neither constructor, method, nor field"));
        }
        n = this.getNumberOfArguments() - n2;
        int[] nArray = new int[n];
        int n3 = 0;
        if (classArray.length > 0 && classArray[0] == (class$net$sf$saxon$expr$XPathContext == null ? (class$net$sf$saxon$expr$XPathContext = FunctionProxy.class$("net.sf.saxon.expr.XPathContext")) : class$net$sf$saxon$expr$XPathContext)) {
            n3 = 1;
        }
        int n4 = 0;
        while (n4 < n) {
            nArray[n4] = valueArray[n4 + n2].conversionPreference(classArray[n4 + n3]);
            ++n4;
        }
        return nArray;
    }

    private void setupParams(Value[] valueArray, Object[] objectArray, Class[] classArray, int n, int n2) throws XPathException {
        int n3 = n;
        int n4 = n2;
        while (n4 < this.getNumberOfArguments()) {
            objectArray[n3] = valueArray[n4].convertToJava(classArray[n3]);
            ++n3;
            ++n4;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

