/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.expr.ComputedExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.RoleLocator;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.TypeChecker;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.Item;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.Type;
import net.sf.saxon.xpath.XPathException;

public final class CastExpression
extends ComputedExpression {
    private Expression source;
    private int targetType;
    private boolean allowEmpty = false;

    public CastExpression(Expression expression, SequenceType sequenceType) throws XPathException {
        this.source = expression;
        this.targetType = sequenceType.getPrimaryType();
        if (Cardinality.allowsMany(sequenceType.getCardinality())) {
            throw new XPathException.Static("Target of cast must not be a sequence type");
        }
        if (Type.isSubType(sequenceType.getPrimaryType(), 0)) {
            throw new XPathException.Static("Target of cast must not be a node type");
        }
    }

    public CastExpression(Expression expression, int n, boolean bl) throws XPathException {
        this.source = expression;
        this.targetType = n;
        this.allowEmpty = bl;
        if (Type.isSubType(n, 0)) {
            throw new XPathException.Static("Target of cast must not be a node type");
        }
    }

    public Expression simplify() throws XPathException {
        this.source = this.source.simplify();
        if (this.source instanceof AtomicValue) {
            return ((AtomicValue)this.source).convert(this.targetType);
        }
        return this;
    }

    public Expression analyze(StaticContext staticContext) throws XPathException {
        this.source = this.source.analyze(staticContext);
        SequenceType sequenceType = new SequenceType(90, 88, this.getCardinality());
        RoleLocator roleLocator = new RoleLocator(2, "cast as", 0);
        this.source = TypeChecker.staticTypeCheck(this.source, sequenceType, false, roleLocator);
        if (Type.isSubType(this.source.getItemType(), this.targetType)) {
            return this.source;
        }
        if (this.source instanceof AtomicValue) {
            return (AtomicValue)this.evaluateItem(null);
        }
        return this;
    }

    public Expression promote(PromotionOffer promotionOffer) throws XPathException {
        this.source = this.source.promote(promotionOffer);
        return this;
    }

    public Expression[] getSubExpressions() {
        Expression[] expressionArray = new Expression[]{this.source};
        return expressionArray;
    }

    public int computeCardinality() {
        return this.allowEmpty ? 768 : 512;
    }

    public int getItemType() {
        return this.targetType;
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        AtomicValue atomicValue = (AtomicValue)this.source.evaluateItem(xPathContext);
        if (atomicValue == null) {
            return null;
        }
        try {
            return atomicValue.convert(this.targetType);
        }
        catch (XPathException xPathException) {
            this.dynamicError(xPathException.getMessage());
            return null;
        }
    }

    public void display(int n) {
        System.err.println(ExpressionTool.indent(n) + "cast as " + Type.getTypeName(this.targetType));
        this.source.display(n + 1);
    }
}

