/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.expr.Binding;
import net.sf.saxon.expr.ComputedExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.LetExpression;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.QuantifiedExpression;
import net.sf.saxon.expr.RangeVariableDeclaration;
import net.sf.saxon.expr.RoleLocator;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.TypeChecker;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.Value;
import net.sf.saxon.xpath.XPathException;

public abstract class Assignation
extends ComputedExpression
implements Binding {
    protected int slotNumber = -1;
    protected Expression sequence;
    protected Expression action;
    protected String variableName;
    private transient RangeVariableDeclaration declaration;

    public void setVariableDeclaration(RangeVariableDeclaration rangeVariableDeclaration) {
        this.declaration = rangeVariableDeclaration;
        this.variableName = rangeVariableDeclaration.getVariableName();
    }

    public void setAction(Expression expression) {
        this.action = expression;
        this.declaration.fixupReferences(this);
    }

    public void setSequence(Expression expression) {
        this.sequence = expression;
    }

    public void setSlotNumber(int n) {
        this.slotNumber = n;
    }

    public Expression simplify() throws XPathException {
        this.sequence = this.sequence.simplify();
        this.action = this.action.simplify();
        return this;
    }

    public Expression analyze(StaticContext staticContext) throws XPathException {
        Object object;
        if (this.declaration == null) {
            return this;
        }
        this.sequence = this.sequence.analyze(staticContext);
        if (this instanceof QuantifiedExpression) {
            this.sequence = ExpressionTool.unsorted(this.sequence, false);
        }
        if (this instanceof LetExpression) {
            object = new RoleLocator(3, this.getVariableName(), 0);
            this.sequence = TypeChecker.staticTypeCheck(this.sequence, this.declaration.getRequiredType(), false, (RoleLocator)object);
            int n = this.sequence.getItemType();
            this.declaration.refineTypeInformation(n, this.sequence instanceof Value ? (Value)this.sequence : null, this.sequence.getSpecialProperties());
        } else {
            object = this.declaration.getRequiredType();
            SequenceType sequenceType = new SequenceType(((SequenceType)object).getPrimaryType(), ((SequenceType)object).getContentType(), 1792);
            RoleLocator roleLocator = new RoleLocator(3, this.getVariableName(), 0);
            this.sequence = TypeChecker.staticTypeCheck(this.sequence, sequenceType, false, roleLocator);
            int n = this.sequence.getItemType();
            this.declaration.refineTypeInformation(n, null, this.sequence.getSpecialProperties());
        }
        this.declaration = null;
        this.action = this.action.analyze(staticContext);
        if (!(this instanceof LetExpression)) {
            object = new PromotionOffer();
            ((PromotionOffer)object).containingExpression = this;
            ((PromotionOffer)object).action = 11;
            ((PromotionOffer)object).binding = this;
            this.action = this.action.promote((PromotionOffer)object);
            if (((PromotionOffer)object).containingExpression instanceof LetExpression) {
                ((PromotionOffer)object).containingExpression = ((PromotionOffer)object).containingExpression.analyze(staticContext);
            }
            return ((PromotionOffer)object).containingExpression;
        }
        return this;
    }

    public Expression promote(PromotionOffer promotionOffer) throws XPathException {
        Expression expression = promotionOffer.accept(this);
        if (expression != null) {
            return expression;
        }
        this.sequence = this.sequence.promote(promotionOffer);
        if (promotionOffer.action == 12 || promotionOffer.action == 13) {
            this.action = this.action.promote(promotionOffer);
        }
        return this;
    }

    public Expression[] getSubExpressions() {
        Expression[] expressionArray = new Expression[]{this.sequence, this.action};
        return expressionArray;
    }

    public SequenceType getRequiredType() {
        return new SequenceType(this.sequence.getItemType(), 88, 512);
    }

    public String getVariableName() {
        if (this.variableName == null) {
            return "zz:var" + this.hashCode();
        }
        return this.variableName;
    }

    public Value evaluateVariable(XPathContext xPathContext) throws XPathException {
        return xPathContext.evaluateLocalVariable(this.slotNumber);
    }
}

