/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.event;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.TransformerException;
import net.sf.saxon.event.ComplexContentOutputter;
import net.sf.saxon.event.NamespaceReducer;
import net.sf.saxon.event.Outputter;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.TextFragment;
import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.Orphan;
import net.sf.saxon.tinytree.TinyBuilder;
import net.sf.saxon.tinytree.TinyDocumentImpl;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.SequenceExtent;
import net.sf.saxon.value.Value;

public final class SequenceOutputter
extends Outputter {
    private List list = new ArrayList();
    private NamePool namePool;
    private String systemId;
    private Receiver tree = null;
    private TinyBuilder builder = null;
    private int level = 0;
    private boolean inStartTag = false;

    public void setNamePool(NamePool namePool) {
        this.namePool = namePool;
    }

    public NamePool getNamePool() {
        return this.namePool;
    }

    public void setSystemId(String string) {
        this.systemId = string;
    }

    public String getSystemId() {
        return this.systemId;
    }

    public void setErrorListener(ErrorListener errorListener) {
    }

    public Properties getOutputProperties() {
        return TextFragment.getProperties();
    }

    public final void startDocument() throws TransformerException {
    }

    public void startElement(int n, int n2, int n3) throws TransformerException {
        if (this.inStartTag) {
            this.startContent();
        }
        if (this.tree == null) {
            this.builder = new TinyBuilder();
            this.builder.setNamePool(this.namePool);
            NamespaceReducer namespaceReducer = new NamespaceReducer();
            namespaceReducer.setUnderlyingReceiver(this.builder);
            namespaceReducer.setNamePool(this.namePool);
            ComplexContentOutputter complexContentOutputter = new ComplexContentOutputter();
            complexContentOutputter.setNamePool(this.namePool);
            complexContentOutputter.setReceiver(namespaceReducer);
            this.tree = complexContentOutputter;
            this.tree.setSystemId(this.systemId);
            this.tree.setNamePool(this.namePool);
            this.tree.startDocument();
            this.tree.startElement(n, n2, n3);
        } else {
            this.tree.startElement(n, n2, n3);
        }
        ++this.level;
        this.inStartTag = true;
        this.previousAtomic = false;
    }

    public void endElement() throws TransformerException {
        if (this.inStartTag) {
            this.startContent();
        }
        --this.level;
        if (this.level == 0) {
            this.tree.endElement();
            this.tree.endDocument();
            DocumentInfo documentInfo = this.builder.getCurrentDocument();
            this.tree = null;
            this.builder = null;
            AxisIterator axisIterator = documentInfo.iterateAxis((byte)3);
            if (axisIterator.hasNext()) {
                NodeInfo nodeInfo = (NodeInfo)axisIterator.next();
                ((TinyDocumentImpl)documentInfo).setRootNode(nodeInfo);
                this.append(nodeInfo);
            }
        } else {
            this.tree.endElement();
        }
        this.previousAtomic = false;
    }

    public void namespace(int n, int n2) throws TransformerException {
        if (this.tree == null) {
            Orphan orphan = new Orphan(this.namePool);
            orphan.setNodeKind((short)13);
            orphan.setNameCode(this.namePool.allocate("", "", this.namePool.getPrefixFromNamespaceCode(n)));
            orphan.setStringValue(this.namePool.getURIFromNamespaceCode(n));
            this.append(orphan);
        } else {
            this.tree.namespace(n, n2);
        }
        this.previousAtomic = false;
    }

    public void attribute(int n, int n2, String string, int n3) throws TransformerException {
        if (this.tree == null) {
            Orphan orphan = new Orphan(this.namePool);
            orphan.setNodeKind((short)2);
            orphan.setNameCode(n);
            orphan.setStringValue(string);
            orphan.setTypeAnnotation(n2);
            this.append(orphan);
        } else {
            this.tree.attribute(n, n2, string, n3);
        }
        this.previousAtomic = false;
    }

    public void startContent() throws TransformerException {
        this.inStartTag = false;
        this.tree.startContent();
        this.previousAtomic = false;
    }

    public void characters(CharSequence charSequence, int n) throws TransformerException {
        if (charSequence == null) {
            return;
        }
        if (charSequence.length() == 0) {
            return;
        }
        if (this.inStartTag) {
            this.startContent();
        }
        if (this.tree == null) {
            Orphan orphan = new Orphan(this.namePool);
            orphan.setNodeKind((short)3);
            orphan.setStringValue(charSequence);
            this.append(orphan);
        } else {
            this.tree.characters(charSequence, n);
        }
        this.previousAtomic = false;
    }

    public void comment(CharSequence charSequence, int n) throws TransformerException {
        if (this.inStartTag) {
            this.startContent();
        }
        if (this.tree == null) {
            Orphan orphan = new Orphan(this.namePool);
            orphan.setNodeKind((short)8);
            orphan.setStringValue(charSequence);
            this.append(orphan);
        } else {
            this.tree.comment(charSequence, n);
        }
        this.previousAtomic = false;
    }

    public void processingInstruction(String string, CharSequence charSequence, int n) throws TransformerException {
        if (this.inStartTag) {
            this.startContent();
        }
        if (this.tree == null) {
            Orphan orphan = new Orphan(this.namePool);
            orphan.setNameCode(this.namePool.allocate("", "", string));
            orphan.setNodeKind((short)7);
            orphan.setStringValue(charSequence);
            this.append(orphan);
        } else {
            this.tree.processingInstruction(string, charSequence, n);
        }
        this.previousAtomic = false;
    }

    public void endDocument() throws TransformerException {
        this.previousAtomic = false;
    }

    public void append(Item item) throws TransformerException {
        if (this.tree != null && this.previousAtomic && item instanceof AtomicValue) {
            this.tree.characters(" ", 0);
        }
        this.previousAtomic = item instanceof AtomicValue;
        if (this.tree == null) {
            this.list.add(item);
        } else if (item instanceof AtomicValue) {
            this.tree.characters(item.getStringValue(), 0);
        } else {
            ((NodeInfo)item).copy(this.tree, 2, true);
        }
    }

    public Value getSequence() {
        switch (this.list.size()) {
            case 0: {
                return EmptySequence.getInstance();
            }
            case 1: {
                Item item = (Item)this.list.get(0);
                return Value.asValue(item);
            }
        }
        return new SequenceExtent(this.list);
    }

    public Item getFirstItem() {
        if (this.list.size() == 0) {
            return null;
        }
        return (Item)this.list.get(0);
    }
}

