/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.event;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.xml.transform.Result;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stream.StreamResult;
import net.sf.saxon.OutputURIResolver;
import net.sf.saxon.event.Builder;
import net.sf.saxon.event.CDATAFilter;
import net.sf.saxon.event.CharacterMapExpander;
import net.sf.saxon.event.ContentHandlerProxy;
import net.sf.saxon.event.DOMEmitter;
import net.sf.saxon.event.Emitter;
import net.sf.saxon.event.HTMLEmitter;
import net.sf.saxon.event.HTMLIndenter;
import net.sf.saxon.event.ProxyReceiver;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.TEXTEmitter;
import net.sf.saxon.event.UncommittedEmitter;
import net.sf.saxon.event.XHTMLEmitter;
import net.sf.saxon.event.XMLEmitter;
import net.sf.saxon.event.XMLIndenter;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.tinytree.TinyBuilder;
import net.sf.saxon.tree.DocumentImpl;
import net.sf.saxon.tree.TreeBuilder;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class ResultWrapper {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Receiver getReceiver(Result result, OutputURIResolver outputURIResolver, NamePool namePool, Properties properties, HashMap hashMap) throws TransformerException {
        if (result instanceof Emitter) {
            ((Emitter)result).setOutputProperties(properties);
            return (Emitter)result;
        }
        if (result instanceof Receiver) {
            return (Receiver)result;
        }
        if (result instanceof SAXResult) {
            ContentHandlerProxy contentHandlerProxy = new ContentHandlerProxy();
            contentHandlerProxy.setUnderlyingContentHandler(((SAXResult)result).getHandler());
            contentHandlerProxy.setNamePool(namePool);
            return contentHandlerProxy;
        }
        if (result instanceof StreamResult) {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            Emitter emitter = null;
            CharacterMapExpander characterMapExpander = null;
            String string = properties.getProperty("method");
            String string2 = properties.getProperty("{http://saxon.sf.net/}use-character-maps");
            if (string2 != null && hashMap != null) {
                object4 = new ArrayList();
                object3 = new StringTokenizer(string2);
                while (((StringTokenizer)object3).hasMoreTokens()) {
                    object2 = ((StringTokenizer)object3).nextToken();
                    int n = ResultWrapper.getFingerprintForExpandedName((String)object2, namePool);
                    HashMap hashMap2 = (HashMap)hashMap.get(new Integer(n));
                    if (hashMap2 == null) {
                        throw new TransformerException("Character map '" + (String)object2 + "' has not been defined");
                    }
                    object4.add(hashMap2);
                }
                if (object4.size() > 0) {
                    characterMapExpander = new CharacterMapExpander();
                    characterMapExpander.setCharacterMaps((List)object4);
                }
            }
            if (string == null) {
                emitter = new UncommittedEmitter();
                emitter.setNamePool(namePool);
                object = emitter;
            } else if (string.equals("html")) {
                emitter = new HTMLEmitter();
                emitter.setNamePool(namePool);
                object = emitter;
                if (!"no".equals(properties.getProperty("indent"))) {
                    object4 = new HTMLIndenter();
                    ((ProxyReceiver)object4).setUnderlyingReceiver((Receiver)object);
                    ((ProxyReceiver)object4).setNamePool(namePool);
                    ((HTMLIndenter)object4).setOutputProperties(properties);
                    object = object4;
                }
                if (characterMapExpander != null) {
                    characterMapExpander.setUnderlyingReceiver((Receiver)object);
                    object = characterMapExpander;
                }
            } else if (string.equals("xml")) {
                emitter = new XMLEmitter();
                emitter.setNamePool(namePool);
                object = emitter;
                if ("yes".equals(properties.getProperty("indent"))) {
                    object4 = new XMLIndenter();
                    ((ProxyReceiver)object4).setUnderlyingReceiver((Receiver)object);
                    ((ProxyReceiver)object4).setNamePool(namePool);
                    ((XMLIndenter)object4).setOutputProperties(properties);
                    object = object4;
                }
                if (characterMapExpander != null) {
                    characterMapExpander.setUnderlyingReceiver((Receiver)object);
                    object = characterMapExpander;
                }
                if ((object4 = properties.getProperty("cdata-section-elements")) != null && ((String)object4).length() > 0) {
                    object3 = new CDATAFilter();
                    ((ProxyReceiver)object3).setUnderlyingReceiver((Receiver)object);
                    ((ProxyReceiver)object3).setNamePool(namePool);
                    ((CDATAFilter)object3).setOutputProperties(properties);
                    object = object3;
                }
            } else if (string.equals("xhtml")) {
                emitter = new XHTMLEmitter();
                emitter.setNamePool(namePool);
                object = emitter;
                if ("yes".equals(properties.getProperty("indent"))) {
                    object4 = new HTMLIndenter();
                    ((ProxyReceiver)object4).setUnderlyingReceiver((Receiver)object);
                    ((ProxyReceiver)object4).setNamePool(namePool);
                    ((HTMLIndenter)object4).setOutputProperties(properties);
                    object = object4;
                }
                if (characterMapExpander != null) {
                    characterMapExpander.setUnderlyingReceiver((Receiver)object);
                    object = characterMapExpander;
                }
                if ((object4 = properties.getProperty("cdata-section-elements")) != null && ((String)object4).length() > 0) {
                    object3 = new CDATAFilter();
                    ((ProxyReceiver)object3).setUnderlyingReceiver((Receiver)object);
                    ((ProxyReceiver)object3).setNamePool(namePool);
                    ((CDATAFilter)object3).setOutputProperties(properties);
                    object = object3;
                }
            } else if (string.equals("text")) {
                emitter = new TEXTEmitter();
                emitter.setNamePool(namePool);
                object = emitter;
            } else {
                int n = string.indexOf(125);
                object3 = string.substring(n + 1);
                int n2 = ((String)object3).indexOf(58);
                object3 = ((String)object3).substring(n2 + 1);
                emitter = Emitter.makeEmitter((String)object3);
                emitter.setNamePool(namePool);
                object = emitter;
            }
            if (emitter == null) return object;
            emitter.setOutputProperties(properties);
            StreamResult streamResult = (StreamResult)result;
            if (streamResult.getWriter() != null) {
                emitter.setWriter(streamResult.getWriter());
                return object;
            } else if (streamResult.getOutputStream() != null) {
                emitter.setOutputStream(streamResult.getOutputStream());
                return object;
            } else {
                object3 = streamResult.getSystemId();
                object2 = outputURIResolver.resolve((String)object3, "");
                if (!(object2 instanceof StreamResult)) throw new TransformerException("The systemId supplied in a StreamResult must resolve to another StreamResult");
                StreamResult streamResult2 = (StreamResult)object2;
                if (streamResult2.getWriter() != null) {
                    emitter.setWriter(streamResult2.getWriter());
                    return object;
                } else {
                    if (streamResult2.getOutputStream() == null) throw new TransformerException("The systemId supplied in a StreamResult must resolve to a Writer or OutputStream");
                    emitter.setOutputStream(streamResult2.getOutputStream());
                }
            }
            return object;
        }
        if (!(result instanceof DOMResult)) throw new IllegalArgumentException("Unknown type of result: " + result.getClass());
        Node node = ((DOMResult)result).getNode();
        if (node != null) {
            if (node instanceof NodeInfo) {
                if (!(node instanceof DocumentInfo)) throw new TransformerException("Cannot add to an existing Saxon document");
                DocumentInfo documentInfo = (DocumentInfo)((Object)node);
                if (node.getFirstChild() != null) {
                    throw new TransformerException("Target document must be empty");
                }
                Builder builder = documentInfo instanceof DocumentImpl ? new TreeBuilder() : new TinyBuilder();
                builder.setRootNode(documentInfo);
                builder.setSystemId(result.getSystemId());
                builder.setNamePool(namePool);
                return builder;
            }
            DOMEmitter dOMEmitter = new DOMEmitter();
            dOMEmitter.setNode(node);
            return dOMEmitter;
        }
        TinyBuilder tinyBuilder = new TinyBuilder();
        tinyBuilder.setSystemId(result.getSystemId());
        tinyBuilder.setNamePool(namePool);
        tinyBuilder.createDocument();
        Document document = (Document)((Object)tinyBuilder.getCurrentDocument());
        ((DOMResult)result).setNode(document);
        return tinyBuilder;
    }

    private static int getFingerprintForExpandedName(String string, NamePool namePool) {
        String string2;
        String string3;
        if (string.charAt(0) == '{') {
            int n = string.indexOf(125);
            if (n < 0) {
                throw new IllegalArgumentException("No closing '}' in parameter name");
            }
            string3 = string.substring(1, n);
            if (n == string.length()) {
                throw new IllegalArgumentException("Missing local part in parameter name");
            }
            string2 = string.substring(n + 1);
        } else {
            string3 = "";
            string2 = string;
        }
        return namePool.allocate("", string3, string2);
    }
}

