/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.event;

import java.util.ArrayList;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.sax.SAXSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.StandardURIResolver;
import net.sf.saxon.event.ProxyReceiver;
import net.sf.saxon.om.ProcInstParser;

public class PIGrabber
extends ProxyReceiver {
    private Configuration config = null;
    private String reqMedia = null;
    private String reqTitle = null;
    private String baseURI = null;
    private URIResolver uriResolver = null;
    private ArrayList stylesheets = new ArrayList();
    private boolean terminated = false;

    public void setFactory(Configuration configuration) {
        this.config = configuration;
    }

    public void setCriteria(String string, String string2, String string3) {
        this.reqMedia = string;
        this.reqTitle = string2;
    }

    public void setBaseURI(String string) {
        this.baseURI = string;
    }

    public void setURIResolver(URIResolver uRIResolver) {
        this.uriResolver = uRIResolver;
    }

    public void startDocument() {
    }

    public void startElement(int n, int n2, int n3) throws TransformerException {
        this.terminated = true;
        throw new TransformerException("#start#");
    }

    public boolean isTerminated() {
        return this.terminated;
    }

    public void processingInstruction(String string, CharSequence charSequence, int n) throws TransformerException {
        if (string.equals("xml-stylesheet")) {
            String string2 = charSequence.toString();
            String string3 = ProcInstParser.getPseudoAttribute(string2, "media");
            String string4 = ProcInstParser.getPseudoAttribute(string2, "title");
            String string5 = ProcInstParser.getPseudoAttribute(string2, "type");
            String string6 = ProcInstParser.getPseudoAttribute(string2, "alternate");
            if (string5 == null) {
                return;
            }
            if ((string5.equals("text/xml") || string5.equals("application/xml") || string5.equals("text/xsl") || string5.equals("applicaton/xsl")) && (this.reqMedia == null || string3 == null || this.reqMedia.equals(string3)) && (string4 == null && (string6 == null || string6.equals("no")) || this.reqTitle == null || string4 != null && string4.equals(this.reqTitle))) {
                String string7 = ProcInstParser.getPseudoAttribute(string2, "href");
                if (string7 == null) {
                    throw new TransformerException("xml-stylesheet PI has no href attribute");
                }
                if (string4 == null && (string6 == null || string6.equals("no"))) {
                    this.stylesheets.add(0, string7);
                } else {
                    this.stylesheets.add(string7);
                }
            }
        }
    }

    public Source[] getAssociatedStylesheets() throws TransformerException {
        if (this.stylesheets.size() == 0) {
            return null;
        }
        if (this.uriResolver == null) {
            this.uriResolver = new StandardURIResolver(this.config);
        }
        Source[] sourceArray = new SAXSource[this.stylesheets.size()];
        int n = 0;
        while (n < this.stylesheets.size()) {
            String string = (String)this.stylesheets.get(n);
            Source source = this.uriResolver.resolve(string, this.baseURI);
            if (source == null) {
                source = new StandardURIResolver(this.config).resolve(string, this.baseURI);
            }
            sourceArray[n] = source;
            ++n;
        }
        return sourceArray;
    }
}

