/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.event;

import java.io.IOException;
import javax.xml.transform.TransformerException;
import net.sf.saxon.charcode.UnicodeCharacterSet;
import net.sf.saxon.event.HTMLTagHashSet;
import net.sf.saxon.event.XMLEmitter;

public class HTMLEmitter
extends XMLEmitter {
    private static final int REP_NATIVE = 0;
    private static final int REP_ENTITY = 1;
    private static final int REP_DECIMAL = 2;
    private static final int REP_HEX = 3;
    private int nonASCIIRepresentation = 1;
    private int excludedRepresentation = 2;
    private String mediaType = "text/html";
    private int inScript;
    private boolean started = false;
    private String elementName;
    private short uriCode;
    private boolean escapeURIAttributes = true;
    static HTMLTagHashSet emptyTags = new HTMLTagHashSet(31);
    private static HTMLTagHashSet booleanAttributes;
    private static HTMLTagHashSet booleanCombinations;
    private static HTMLTagHashSet urlAttributes;
    private static HTMLTagHashSet urlCombinations;
    private static String[] latin1Entities;

    private static int representationCode(String string) {
        if (string.equalsIgnoreCase("native")) {
            return 0;
        }
        if (string.equalsIgnoreCase("entity")) {
            return 1;
        }
        if (string.equalsIgnoreCase("decimal")) {
            return 2;
        }
        if (string.equalsIgnoreCase("hex")) {
            return 3;
        }
        return 1;
    }

    private static void setEmptyTag(String string) {
        emptyTags.add(string);
    }

    protected static boolean isEmptyTag(String string) {
        return emptyTags.contains(string);
    }

    private static void setBooleanAttribute(String string, String string2) {
        booleanAttributes.add(string2);
        booleanCombinations.add(string + "+" + string2);
    }

    private static boolean isBooleanAttribute(String string, String string2, String string3) {
        if (!string2.equalsIgnoreCase(string3)) {
            return false;
        }
        if (!booleanAttributes.contains(string2)) {
            return false;
        }
        return booleanCombinations.contains(string + "+" + string2);
    }

    private static void setUrlAttribute(String string, String string2) {
        urlAttributes.add(string2);
        urlCombinations.add(string + "+" + string2);
    }

    public static boolean isUrlAttribute(String string, String string2) {
        if (!urlAttributes.contains(string2)) {
            return false;
        }
        return urlCombinations.contains(string + "+" + string2);
    }

    public void startDocument() throws TransformerException {
        String string;
        String string2;
        if (this.started) {
            return;
        }
        this.started = true;
        String string3 = this.outputProperties.getProperty("media-type");
        if (string3 != null) {
            this.mediaType = string3;
        }
        if ("yes".equals(string2 = this.outputProperties.getProperty("{http://saxon.sf.net/}byte-order-mark"))) {
            try {
                this.writer.write(65279);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.escapeURIAttributes = !"no".equals(string = this.outputProperties.getProperty("{http://saxon.sf.net/}escape-uri-attibutes"));
        String string4 = this.outputProperties.getProperty("doctype-system");
        String string5 = this.outputProperties.getProperty("doctype-public");
        if (string4 != null || string5 != null) {
            this.writeDocType("html", string4, string5);
        }
        this.empty = false;
        this.inScript = -1000000;
        String string6 = this.outputProperties.getProperty("{http://saxon.sf.net/}character-representation");
        if (string6 != null) {
            String string7;
            String string8;
            int n = string6.indexOf(59);
            if (n < 0) {
                string8 = string6;
                string7 = string6;
            } else {
                string8 = string6.substring(0, n).trim();
                string7 = string6.substring(n + 1).trim();
            }
            this.nonASCIIRepresentation = HTMLEmitter.representationCode(string8);
            this.excludedRepresentation = HTMLEmitter.representationCode(string7);
            if (this.excludedRepresentation == 0) {
                this.excludedRepresentation = 1;
            }
        }
    }

    public void startElement(int n, int n2, int n3) throws TransformerException {
        super.startElement(n, n2, n3);
        this.uriCode = this.namePool.getURICode(n);
        this.elementName = (String)this.elementStack.peek();
        if (this.uriCode == 0 && (this.elementName.equalsIgnoreCase("script") || this.elementName.equalsIgnoreCase("style"))) {
            this.inScript = 0;
        }
        ++this.inScript;
    }

    public void startContent() throws TransformerException {
        block3: {
            String string;
            this.closeStartTag(null, false);
            if (this.uriCode != 0 || !this.elementName.equalsIgnoreCase("head") || "no".equals(string = this.outputProperties.getProperty("{http://saxon.sf.net/}include-content-type"))) break block3;
            String string2 = this.outputProperties.getProperty("encoding");
            if (string2 == null) {
                string2 = "UTF-8";
            }
            try {
                this.writer.write("\n      <meta http-equiv=\"Content-Type\" content=\"" + this.mediaType + "; charset=" + string2 + "\">\n   ");
            }
            catch (IOException iOException) {}
        }
    }

    protected void writeAttribute(int n, String string, String string2, int n2) throws TransformerException {
        try {
            if (this.uriCode == 0) {
                if (HTMLEmitter.isBooleanAttribute(this.elementName, string, string2)) {
                    this.writer.write(string);
                    return;
                }
                if (this.escapeURIAttributes && HTMLEmitter.isUrlAttribute(this.elementName, string) && (n2 & 1) == 0) {
                    super.writeAttribute(n, string, HTMLEmitter.escapeURL(string2), 0);
                    return;
                }
            }
            super.writeAttribute(n, string, string2, n2);
        }
        catch (IOException iOException) {
            throw new TransformerException(iOException);
        }
    }

    protected void writeEscape(CharSequence charSequence, boolean bl) throws IOException {
        int n = 0;
        boolean[] blArray = bl ? XMLEmitter.specialInAtt : XMLEmitter.specialInText;
        while (n < charSequence.length()) {
            int n2 = n;
            while (n2 < charSequence.length() && (charSequence.charAt(n2) < '\u0080' ? !blArray[charSequence.charAt(n2)] : this.characterSet.inCharset(charSequence.charAt(n2)) && this.nonASCIIRepresentation == 0 && charSequence.charAt(n2) != '\u00a0')) {
                ++n2;
            }
            this.writer.write(charSequence.subSequence(n, n2).toString());
            if (n2 == charSequence.length()) {
                return;
            }
            char c = charSequence.charAt(n2);
            if (c < '\u007f') {
                if (bl) {
                    if (c == '<') {
                        this.writer.write(60);
                    } else if (c == '>') {
                        this.writer.write("&gt;");
                    } else if (c == '&') {
                        if (n2 + 1 < charSequence.length() && charSequence.charAt(n2 + 1) == '{') {
                            this.writer.write(38);
                        } else {
                            this.writer.write("&amp;");
                        }
                    } else if (c == '\"') {
                        this.writer.write("&#34;");
                    } else if (c == '\n') {
                        this.writer.write("&#xA;");
                    }
                } else if (c == '<') {
                    this.writer.write("&lt;");
                } else if (c == '>') {
                    this.writer.write("&gt;");
                } else if (c == '&') {
                    this.writer.write("&amp;");
                }
            } else if (c == '\u00a0') {
                this.writer.write("&nbsp;");
            } else if (c >= '\ud800' && c <= '\udbff') {
                int n3 = (c - 55296) * 1024 + (charSequence.charAt(n2 + 1) - 56320) + 65536;
                this.outputCharacterReference(n3);
                ++n2;
            } else if (this.characterSet.inCharset(c)) {
                switch (this.nonASCIIRepresentation) {
                    case 0: {
                        this.writer.write(c);
                        break;
                    }
                    case 1: {
                        if (c > '\u00a0' && c <= '\u00ff') {
                            this.writer.write(38);
                            this.writer.write(latin1Entities[c - 160]);
                            this.writer.write(59);
                            break;
                        }
                    }
                    case 2: {
                        this.preferHex = false;
                        this.outputCharacterReference(c);
                        break;
                    }
                    case 3: {
                        this.preferHex = true;
                    }
                    default: {
                        this.outputCharacterReference(c);
                        break;
                    }
                }
            } else {
                this.preferHex = this.excludedRepresentation == 3;
                this.outputCharacterReference(c);
            }
            n = ++n2;
        }
    }

    public void endElement() throws TransformerException {
        String string = (String)this.elementStack.peek();
        --this.inScript;
        if (this.inScript == 0) {
            this.inScript = -1000000;
        }
        if (HTMLEmitter.isEmptyTag(string) && this.uriCode == 0) {
            this.elementStack.pop();
        } else {
            super.endElement();
        }
    }

    public void characters(CharSequence charSequence, int n) throws TransformerException {
        int n2 = n;
        if (this.inScript > 0) {
            n2 |= 1;
        }
        super.characters(charSequence, n2);
    }

    public void processingInstruction(String string, CharSequence charSequence, int n) throws TransformerException {
        try {
            this.writer.write("<?");
            this.writer.write(string);
            this.writer.write(32);
            this.writer.write(charSequence.toString());
            this.writer.write(62);
        }
        catch (IOException iOException) {
            throw new TransformerException(iOException);
        }
    }

    private static String escapeURL(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = "0123456789ABCDEF";
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (c < ' ' || c > '~') {
                byte[] byArray = new byte[4];
                int n2 = UnicodeCharacterSet.getUTF8Encoding(c, n + 1 < string.length() ? string.charAt(n + 1) : (char)' ', byArray);
                int n3 = 0;
                while (n3 < n2) {
                    int n4 = byArray[n3] >= 0 ? byArray[n3] : 256 + byArray[n3];
                    stringBuffer.append('%');
                    stringBuffer.append(string2.charAt(n4 / 16));
                    stringBuffer.append(string2.charAt(n4 % 16));
                    ++n3;
                }
            } else {
                stringBuffer.append(c);
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    static {
        HTMLEmitter.setEmptyTag("area");
        HTMLEmitter.setEmptyTag("base");
        HTMLEmitter.setEmptyTag("basefont");
        HTMLEmitter.setEmptyTag("br");
        HTMLEmitter.setEmptyTag("col");
        HTMLEmitter.setEmptyTag("frame");
        HTMLEmitter.setEmptyTag("hr");
        HTMLEmitter.setEmptyTag("img");
        HTMLEmitter.setEmptyTag("input");
        HTMLEmitter.setEmptyTag("isindex");
        HTMLEmitter.setEmptyTag("link");
        HTMLEmitter.setEmptyTag("meta");
        HTMLEmitter.setEmptyTag("param");
        booleanAttributes = new HTMLTagHashSet(31);
        booleanCombinations = new HTMLTagHashSet(53);
        HTMLEmitter.setBooleanAttribute("area", "nohref");
        HTMLEmitter.setBooleanAttribute("button", "disabled");
        HTMLEmitter.setBooleanAttribute("dir", "compact");
        HTMLEmitter.setBooleanAttribute("dl", "compact");
        HTMLEmitter.setBooleanAttribute("frame", "noresize");
        HTMLEmitter.setBooleanAttribute("hr", "noshade");
        HTMLEmitter.setBooleanAttribute("img", "ismap");
        HTMLEmitter.setBooleanAttribute("input", "checked");
        HTMLEmitter.setBooleanAttribute("input", "disabled");
        HTMLEmitter.setBooleanAttribute("input", "readonly");
        HTMLEmitter.setBooleanAttribute("menu", "compact");
        HTMLEmitter.setBooleanAttribute("object", "declare");
        HTMLEmitter.setBooleanAttribute("ol", "compact");
        HTMLEmitter.setBooleanAttribute("optgroup", "disabled");
        HTMLEmitter.setBooleanAttribute("option", "selected");
        HTMLEmitter.setBooleanAttribute("option", "disabled");
        HTMLEmitter.setBooleanAttribute("script", "defer");
        HTMLEmitter.setBooleanAttribute("select", "multiple");
        HTMLEmitter.setBooleanAttribute("select", "disabled");
        HTMLEmitter.setBooleanAttribute("td", "nowrap");
        HTMLEmitter.setBooleanAttribute("textarea", "disabled");
        HTMLEmitter.setBooleanAttribute("textarea", "readonly");
        HTMLEmitter.setBooleanAttribute("th", "nowrap");
        HTMLEmitter.setBooleanAttribute("ul", "compact");
        urlAttributes = new HTMLTagHashSet(47);
        urlCombinations = new HTMLTagHashSet(101);
        HTMLEmitter.setUrlAttribute("form", "action");
        HTMLEmitter.setUrlAttribute("body", "background");
        HTMLEmitter.setUrlAttribute("q", "cite");
        HTMLEmitter.setUrlAttribute("blockquote", "cite");
        HTMLEmitter.setUrlAttribute("del", "cite");
        HTMLEmitter.setUrlAttribute("ins", "cite");
        HTMLEmitter.setUrlAttribute("object", "classid");
        HTMLEmitter.setUrlAttribute("object", "codebase");
        HTMLEmitter.setUrlAttribute("applet", "codebase");
        HTMLEmitter.setUrlAttribute("object", "data");
        HTMLEmitter.setUrlAttribute("a", "href");
        HTMLEmitter.setUrlAttribute("a", "name");
        HTMLEmitter.setUrlAttribute("area", "href");
        HTMLEmitter.setUrlAttribute("link", "href");
        HTMLEmitter.setUrlAttribute("base", "href");
        HTMLEmitter.setUrlAttribute("img", "longdesc");
        HTMLEmitter.setUrlAttribute("frame", "longdesc");
        HTMLEmitter.setUrlAttribute("iframe", "longdesc");
        HTMLEmitter.setUrlAttribute("head", "profile");
        HTMLEmitter.setUrlAttribute("script", "src");
        HTMLEmitter.setUrlAttribute("input", "src");
        HTMLEmitter.setUrlAttribute("frame", "src");
        HTMLEmitter.setUrlAttribute("iframe", "src");
        HTMLEmitter.setUrlAttribute("img", "src");
        HTMLEmitter.setUrlAttribute("img", "usemap");
        HTMLEmitter.setUrlAttribute("input", "usemap");
        HTMLEmitter.setUrlAttribute("object", "usemap");
        latin1Entities = new String[]{"nbsp", "iexcl", "cent", "pound", "curren", "yen", "brvbar", "sect", "uml", "copy", "ordf", "laquo", "not", "shy", "reg", "macr", "deg", "plusmn", "sup2", "sup3", "acute", "micro", "para", "middot", "cedil", "sup1", "ordm", "raquo", "frac14", "frac12", "frac34", "iquest", "Agrave", "Aacute", "Acirc", "Atilde", "Auml", "Aring", "AElig", "Ccedil", "Egrave", "Eacute", "Ecirc", "Euml", "Igrave", "Iacute", "Icirc", "Iuml", "ETH", "Ntilde", "Ograve", "Oacute", "Ocirc", "Otilde", "Ouml", "times", "Oslash", "Ugrave", "Uacute", "Ucirc", "Uuml", "Yacute", "THORN", "szlig", "agrave", "aacute", "acirc", "atilde", "auml", "aring", "aelig", "ccedil", "egrave", "eacute", "ecirc", "euml", "igrave", "iacute", "icirc", "iuml", "eth", "ntilde", "ograve", "oacute", "ocirc", "otilde", "ouml", "divide", "oslash", "ugrave", "uacute", "ucirc", "uuml", "yacute", "thorn", "yuml"};
    }
}

