/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.event;

import java.util.HashMap;
import java.util.Iterator;
import javax.xml.transform.TransformerException;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.om.Name;
import net.sf.saxon.om.NamePool;
import org.w3c.dom.Attr;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Comment;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.xml.sax.Locator;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.NamespaceSupport;

public class DOMSender
implements Locator {
    private Receiver receiver;
    private NamePool namePool;
    private LexicalHandler lexicalHandler = null;
    private NamespaceSupport nsSupport = new NamespaceSupport();
    private AttributesImpl attlist = new AttributesImpl();
    private String[] parts = new String[3];
    private String[] elparts = new String[3];
    private HashMap nsDeclarations = new HashMap();
    protected Node root = null;
    protected String systemId;

    public void setReceiver(Receiver receiver) {
        this.receiver = receiver;
    }

    public void setNamePool(NamePool namePool) {
        this.namePool = namePool;
    }

    public void setStartNode(Node node) {
        this.root = node;
    }

    public void setSystemId(String string) {
        this.systemId = string;
    }

    public void send() throws TransformerException {
        if (this.root == null) {
            throw new TransformerException("DOMSender: no start node defined");
        }
        if (this.receiver == null) {
            throw new TransformerException("DOMSender: receiver defined");
        }
        this.receiver.setSystemId(this.systemId);
        this.receiver.setDocumentLocator(this);
        this.receiver.startDocument();
        if (this.root instanceof Element) {
            this.sendElement((Element)this.root);
        } else {
            this.walkNode(this.root);
        }
        this.receiver.endDocument();
    }

    private void sendElement(Element element) throws TransformerException {
        Element element2 = element;
        NamedNodeMap namedNodeMap = this.gatherNamespaces(element2, false);
        while (true) {
            this.gatherNamespaces(element2, true);
            Node node = element2.getParentNode();
            if (!(node instanceof Element)) break;
            element2 = (Element)node;
        }
        this.outputElement(element, namedNodeMap);
    }

    private void walkNode(Node node) throws TransformerException {
        if (node.hasChildNodes()) {
            NodeList nodeList = node.getChildNodes();
            int n = 0;
            while (n < nodeList.getLength()) {
                Node node2 = nodeList.item(n);
                switch (node2.getNodeType()) {
                    case 9: {
                        break;
                    }
                    case 1: {
                        Element element = (Element)node2;
                        NamedNodeMap namedNodeMap = this.gatherNamespaces(element, false);
                        this.outputElement(element, namedNodeMap);
                        this.nsSupport.popContext();
                        break;
                    }
                    case 2: {
                        break;
                    }
                    case 7: {
                        this.receiver.processingInstruction(((ProcessingInstruction)node2).getTarget(), ((ProcessingInstruction)node2).getData(), 0);
                        break;
                    }
                    case 8: {
                        String string;
                        if (this.lexicalHandler == null || (string = ((Comment)node2).getData()) == null) break;
                        this.receiver.comment(string, 0);
                        break;
                    }
                    case 3: 
                    case 4: {
                        String string = ((CharacterData)node2).getData();
                        if (string == null) break;
                        this.receiver.characters(string, 0);
                        break;
                    }
                    case 5: {
                        this.walkNode(node2);
                        break;
                    }
                }
                ++n;
            }
        }
    }

    private void outputElement(Element element, NamedNodeMap namedNodeMap) throws TransformerException {
        Object object;
        String[] stringArray = this.nsSupport.processName(element.getTagName(), this.elparts, false);
        if (stringArray == null) {
            throw new TransformerException("Undeclared namespace in " + element.getTagName());
        }
        String string = stringArray[0];
        String string2 = stringArray[1];
        String string3 = Name.getPrefix(stringArray[2]);
        int n = this.namePool.allocate(string3, string, string2);
        this.receiver.startElement(n, 0, 0);
        Iterator iterator = this.nsDeclarations.keySet().iterator();
        while (iterator.hasNext()) {
            String string4 = (String)iterator.next();
            object = (String)this.nsDeclarations.get(string4);
            this.receiver.namespace(this.namePool.allocateNamespaceCode(string4, (String)object), 0);
        }
        int n2 = 0;
        while (n2 < namedNodeMap.getLength()) {
            object = (Attr)namedNodeMap.item(n2);
            String string5 = object.getName();
            if (!string5.equals("xmlns") && !string5.startsWith("xmlns:")) {
                String[] stringArray2 = this.nsSupport.processName(string5, this.parts, true);
                if (stringArray2 == null) {
                    throw new TransformerException("Undeclared namespace in " + string5);
                }
                String string6 = stringArray2[0];
                String string7 = stringArray2[1];
                String string8 = Name.getPrefix(stringArray2[2]);
                int n3 = this.namePool.allocate(string8, string6, string7);
                this.receiver.attribute(n3, 0, object.getValue(), 0);
            }
            ++n2;
        }
        this.receiver.startContent();
        this.walkNode(element);
        this.receiver.endElement();
    }

    private NamedNodeMap gatherNamespaces(Element element, boolean bl) {
        Object object;
        if (!bl) {
            this.nsSupport.pushContext();
            this.attlist.clear();
            this.nsDeclarations.clear();
        }
        try {
            object = element.getPrefix();
            String string = element.getNamespaceURI();
            if (object == null) {
                object = "";
            }
            if (string == null) {
                string = "";
            }
            if (this.nsDeclarations.get(object) == null) {
                this.nsSupport.declarePrefix((String)object, string);
                this.nsDeclarations.put(object, string);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        object = element.getAttributes();
        int n = 0;
        while (n < object.getLength()) {
            String string;
            String string2;
            Attr attr = (Attr)object.item(n);
            String string3 = attr.getName();
            if (string3.equals("xmlns")) {
                if (this.nsDeclarations.get("") == null) {
                    string2 = attr.getValue();
                    this.nsSupport.declarePrefix("", string2);
                    this.nsDeclarations.put("", string2);
                }
            } else if (string3.startsWith("xmlns:")) {
                string2 = string3.substring(6);
                if (this.nsDeclarations.get(string2) == null) {
                    string = attr.getValue();
                    this.nsSupport.declarePrefix(string2, string);
                    this.nsDeclarations.put(string2, string);
                }
            } else if (string3.indexOf(58) >= 0) {
                try {
                    string2 = attr.getPrefix();
                    string = attr.getNamespaceURI();
                    if (this.nsDeclarations.get(string2) == null) {
                        this.nsSupport.declarePrefix(string2, string);
                        this.nsDeclarations.put(string2, string);
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            ++n;
        }
        return object;
    }

    public int getColumnNumber() {
        return -1;
    }

    public int getLineNumber() {
        return -1;
    }

    public String getPublicId() {
        return null;
    }

    public String getSystemId() {
        return this.systemId;
    }
}

