/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.event;

import java.util.HashMap;
import java.util.Properties;
import javax.xml.transform.Result;
import javax.xml.transform.TransformerException;
import net.sf.saxon.OutputURIResolver;
import net.sf.saxon.event.AnnotationRemover;
import net.sf.saxon.event.NamespaceReducer;
import net.sf.saxon.event.NoOpenStartTagException;
import net.sf.saxon.event.Outputter;
import net.sf.saxon.event.ProxyReceiver;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.ResultWrapper;
import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.xpath.XPathException;

public class ComplexContentOutputter
extends Outputter {
    private NamePool namePool;
    private Properties outputProperties;
    private OutputURIResolver outputURIResolver;
    private Receiver receiver;
    private int pendingStartTag = -1;
    private int[] pendingAttCode = new int[20];
    private int[] pendingAttType = new int[20];
    private String[] pendingAttValue = new String[20];
    private int[] pendingAttProp = new int[20];
    private int pendingAttListSize = 0;
    private int[] pendingNSList = new int[20];
    private int pendingNSListSize = 0;
    private int currentSimpleType = 0;
    private StringBuffer simpleContentBuffer = null;
    private boolean suppressAttributes = false;

    public void setNamePool(NamePool namePool) {
        this.namePool = namePool;
    }

    public NamePool getNamePool() {
        return this.namePool;
    }

    public void setSystemId(String string) {
    }

    public String getSystemId() {
        return null;
    }

    public void setOutputURIResolver(OutputURIResolver outputURIResolver) {
        this.outputURIResolver = outputURIResolver;
    }

    public void setOutputDestination(Properties properties, Result result, HashMap hashMap) throws TransformerException {
        Object object;
        this.setOutputProperties(properties);
        this.receiver = ResultWrapper.getReceiver(result, this.outputURIResolver, this.namePool, properties, hashMap);
        if (properties != null && "none".equals(object = properties.getProperty("{http://saxon.sf.net/}type-information"))) {
            AnnotationRemover annotationRemover = new AnnotationRemover();
            annotationRemover.setUnderlyingReceiver(this.receiver);
            annotationRemover.setNamePool(this.namePool);
            this.receiver = annotationRemover;
        }
        object = new NamespaceReducer();
        ((ProxyReceiver)object).setUnderlyingReceiver(this.receiver);
        ((NamespaceReducer)object).setNamePool(this.namePool);
        this.receiver = object;
        this.startDocument();
    }

    private void setOutputProperties(Properties properties) {
        this.outputProperties = properties;
    }

    public Properties getOutputProperties() {
        return this.outputProperties;
    }

    public void setReceiver(Receiver receiver) {
        this.receiver = receiver;
    }

    public void startDocument() throws TransformerException {
        this.receiver.startDocument();
        this.previousAtomic = false;
    }

    public void characters(CharSequence charSequence, int n) throws TransformerException {
        if (charSequence == null) {
            return;
        }
        int n2 = charSequence.length();
        if (n2 == 0) {
            return;
        }
        if (this.pendingStartTag != -1) {
            this.startContent();
        }
        this.receiver.characters(charSequence, n);
        if (this.simpleContentBuffer != null) {
            this.simpleContentBuffer.append((Object)charSequence);
        }
        this.previousAtomic = false;
    }

    public void startElement(int n, int n2, int n3) throws TransformerException {
        if (this.currentSimpleType != 0 && this.currentSimpleType != 94) {
            throw new TransformerException("An element created with a type annotation cannot have child elements");
        }
        if (n == -1) {
            this.suppressAttributes = true;
            return;
        }
        this.suppressAttributes = false;
        this.simpleContentBuffer = n2 == 0 || n2 == 94 ? null : new StringBuffer();
        if (this.pendingStartTag != -1) {
            this.startContent();
        }
        this.pendingAttListSize = 0;
        this.pendingNSListSize = 0;
        this.pendingStartTag = n;
        this.currentSimpleType = n2;
        this.previousAtomic = false;
    }

    public void namespace(int n, int n2) throws TransformerException {
        if (this.suppressAttributes) {
            return;
        }
        if (this.pendingStartTag == -1) {
            throw new NoOpenStartTagException("Cannot write a namespace declaration when there is no open start tag");
        }
        boolean bl = (n2 & 0x20) != 0;
        int n3 = 0;
        while (n3 < this.pendingNSListSize) {
            if (n == this.pendingNSList[n3]) {
                return;
            }
            if (n >> 16 == this.pendingNSList[n3] >> 16) {
                if (bl) {
                    throw new TransformerException("Cannot create two namespace nodes with the same name");
                }
                return;
            }
            ++n3;
        }
        if (n >> 16 == 0 && (n & 0xFFFF) != 0 && (this.namePool.allocateNamespaceCode(this.pendingStartTag) & 0xFFFF) == 0) {
            throw new TransformerException("Cannot output a namespace node for the default namespace when the element is in no namespace");
        }
        if (this.pendingNSListSize + 1 > this.pendingNSList.length) {
            int[] nArray = new int[this.pendingNSListSize * 2];
            System.arraycopy(this.pendingNSList, 0, nArray, 0, this.pendingNSListSize);
            this.pendingNSList = nArray;
        }
        this.pendingNSList[this.pendingNSListSize++] = n;
        this.previousAtomic = false;
    }

    public void attribute(int n, int n2, String string, int n3) throws TransformerException {
        if (this.suppressAttributes) {
            return;
        }
        if (this.pendingStartTag == -1) {
            throw new NoOpenStartTagException("Cannot write an attribute when there is no open start tag");
        }
        if (this.currentSimpleType != 0 && this.currentSimpleType != 94) {
            throw new TransformerException("An element created with a simple type annotation cannot have attributes");
        }
        int n4 = 0;
        while (n4 < this.pendingAttListSize) {
            if (this.pendingAttCode[n4] == n) {
                this.pendingAttType[n4] = n2;
                this.pendingAttValue[n4] = string;
                this.pendingAttProp[n4] = n3;
                return;
            }
            ++n4;
        }
        if (this.pendingAttListSize >= this.pendingAttCode.length) {
            int[] nArray = new int[this.pendingAttListSize * 2];
            int[] nArray2 = new int[this.pendingAttListSize * 2];
            String[] stringArray = new String[this.pendingAttListSize * 2];
            int[] nArray3 = new int[this.pendingAttListSize * 2];
            System.arraycopy(this.pendingAttCode, 0, nArray, 0, this.pendingAttListSize);
            System.arraycopy(this.pendingAttType, 0, nArray2, 0, this.pendingAttListSize);
            System.arraycopy(this.pendingAttValue, 0, stringArray, 0, this.pendingAttListSize);
            System.arraycopy(this.pendingAttProp, 0, nArray3, 0, this.pendingAttListSize);
            this.pendingAttCode = nArray;
            this.pendingAttType = nArray2;
            this.pendingAttValue = stringArray;
            this.pendingAttProp = nArray3;
        }
        this.pendingAttCode[this.pendingAttListSize] = n;
        this.pendingAttType[this.pendingAttListSize] = n2;
        this.pendingAttValue[this.pendingAttListSize] = string;
        this.pendingAttProp[this.pendingAttListSize] = n3;
        ++this.pendingAttListSize;
        this.previousAtomic = false;
    }

    private int checkProposedPrefix(int n, int n2) throws TransformerException {
        int n3 = this.namePool.allocateNamespaceCode(n);
        int n4 = n3 >> 16;
        int n5 = 0;
        while (n5 < this.pendingNSListSize) {
            if (n4 == this.pendingNSList[n5] >> 16) {
                if ((n3 & 0xFFFF) == (this.pendingNSList[n5] & 0xFFFF)) {
                    return n;
                }
                String string = this.getSubstitutePrefix(n3, n2);
                int n6 = this.namePool.allocate(string, this.namePool.getURI(n), this.namePool.getLocalName(n));
                this.namespace(this.namePool.allocateNamespaceCode(n6), 0);
                return n6;
            }
            ++n5;
        }
        this.namespace(n3, 0);
        return n;
    }

    private String getSubstitutePrefix(int n, int n2) {
        String string = this.namePool.getPrefixFromNamespaceCode(n);
        return string + "_" + n2;
    }

    public void endElement() throws TransformerException {
        if (this.pendingStartTag != -1) {
            this.startContent();
        }
        if (this.simpleContentBuffer != null) {
            try {
                new StringValue(this.simpleContentBuffer).convert(this.currentSimpleType);
            }
            catch (XPathException xPathException) {
                throw new TransformerException("Element content does not match type annotation", xPathException);
            }
        }
        this.receiver.endElement();
        this.currentSimpleType = 0;
        this.simpleContentBuffer = null;
        this.previousAtomic = false;
    }

    public void comment(CharSequence charSequence, int n) throws TransformerException {
        if (this.pendingStartTag != -1) {
            this.startContent();
        }
        this.receiver.comment(charSequence, n);
        this.previousAtomic = false;
    }

    public void processingInstruction(String string, CharSequence charSequence, int n) throws TransformerException {
        if (this.pendingStartTag != -1) {
            this.startContent();
        }
        this.receiver.processingInstruction(string, charSequence, n);
        this.previousAtomic = false;
    }

    public void append(Item item) throws TransformerException {
        if (item instanceof AtomicValue) {
            if (this.previousAtomic) {
                this.characters(" ", 0);
            }
            this.characters(item.getStringValue(), 0);
            this.previousAtomic = true;
        } else if (item instanceof DocumentInfo) {
            AxisIterator axisIterator = ((DocumentInfo)item).iterateAxis((byte)3);
            while (axisIterator.hasNext()) {
                this.append(axisIterator.next());
            }
        } else {
            ((NodeInfo)item).copy(this, 2, true);
            this.previousAtomic = false;
        }
    }

    public void endDocument() throws TransformerException {
        this.receiver.endDocument();
        this.previousAtomic = false;
    }

    public void startContent() throws TransformerException {
        int n;
        if (this.pendingStartTag == -1) {
            return;
        }
        int n2 = this.checkProposedPrefix(this.pendingStartTag, 0);
        this.receiver.startElement(n2, this.currentSimpleType, 0);
        int n3 = 0;
        while (n3 < this.pendingAttListSize) {
            n = this.pendingAttCode[n3];
            if ((n >> 20 & 0xFF) != 0) {
                n = this.checkProposedPrefix(n, n3 + 1);
            }
            this.receiver.attribute(n, this.pendingAttType[n3], this.pendingAttValue[n3], this.pendingAttProp[n3]);
            ++n3;
        }
        n = 0;
        while (n < this.pendingNSListSize) {
            this.receiver.namespace(this.pendingNSList[n], 0);
            ++n;
        }
        this.receiver.startContent();
        this.pendingAttListSize = 0;
        this.pendingNSListSize = 0;
        this.pendingStartTag = -1;
        this.previousAtomic = false;
    }
}

