/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.GZIPInputStream;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.Unpack;

public class GUnzip
extends Unpack {
    private static final String DEFAULT_EXTENSION = ".gz";

    protected String getDefaultExtension() {
        return DEFAULT_EXTENSION;
    }

    protected void extract() {
        if (this.source.lastModified() > this.dest.lastModified()) {
            this.log("Expanding " + this.source.getAbsolutePath() + " to " + this.dest.getAbsolutePath());
            FileOutputStream out = null;
            GZIPInputStream zIn = null;
            FileInputStream fis = null;
            try {
                out = new FileOutputStream(this.dest);
                fis = new FileInputStream(this.source);
                zIn = new GZIPInputStream(fis);
                byte[] buffer = new byte[8192];
                int count = 0;
                do {
                    out.write(buffer, 0, count);
                } while ((count = zIn.read(buffer, 0, buffer.length)) != -1);
            }
            catch (IOException ioe) {
                String msg = "Problem expanding gzip " + ioe.getMessage();
                throw new BuildException(msg, ioe, this.location);
            }
            finally {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException ioex) {}
                }
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException ioex) {}
                }
                if (zIn != null) {
                    try {
                        zIn.close();
                    }
                    catch (IOException ioex) {}
                }
            }
        }
    }
}

