#!/usr/bin/perl
#
# Convert Jena-pre2 RDQL tests to new RDF Query Tests and Results format
# see - http://www.w3.org/2003/03/rdfqr-tests/
#
# The script print on the STDOUT the Manifest into RDF/XML format
#
# Author: Alberto Reggiori <alberto@asemantics.com>
# Date: Thu Apr 10 12:15:21 CEST 2003

my $parseType = ($ARGV[0] =~ /(no-collection|collection-off)/i ) ? "" : " rdf:parseType='Collection'";

my $date = gmtime();

print <<EOFRDF;
<?xml version="1.0" encoding="UTF-8"?>

<!DOCTYPE rdf:RDF [ 
  <!ENTITY mf "http://www.w3.org/2003/03/rdfqr-tests/manifest.rdfs#">
  <!ENTITY tq "http://www.w3.org/2003/03/rdfqr-tests/query.rdfs#">
 ]>

<rdf:RDF
    xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#"
    xmlns:mf="&mf;"
    xmlns:tq="&tq;"
    xmlns:dc="http://purl.org/dc/elements/1.1/" >

<rdf:Description>
   <dc:author>Alberto Reggiori</dc:author>
   <dc:author>Andy Seaborne</dc:author>
   <dc:date>$date</dc:date>
   <mf:tests$parseType>

EOFRDF

open(ANDY,"rdql-tests.n3");
my $num=1;
while ( <ANDY> ) {
	next if( /^#/ or /^\s+$/ );
	# [ mf:name "test-T-01" ; mf:action <file:test-T-01> ; mf:result <file:result-T-01.n3> ] 
	next unless( /\[ mf:name "([^"]+)" ; mf:action <([^>]+)> ; mf:result <([^>]+)> \]/ );

	my ($name, $query, $result) = ($1,$2,$3);
	$query =~ s/file://g;
	$query_document = ( $query =~ /\.n3$/ ) ? 'N3' : ( $query =~ /\.nt$/ ) ? 'NT' : ( $query =~ /\.rdf$/ ) ? 'RDF-XML' : 'RDQL';
	$query_document .= '-Document';

	$result =~ s/file://g;
	$result_document = ( $result =~ /\.n3$/ ) ? 'N3' : ( $result =~ /\.nt$/ ) ? 'NT' : ( $result =~ /\.rdf$/ ) ? 'RDF-XML' : 'RDQL';
	$result_document .= '-Document';

	my @input;
	my @description;
	open(TT,"$query");
	while(<TT>) {
		next if ( /^\/\/ \(c\)/ );
		next if ( /^\/\/\s+comment\s+/i );
		if ( /^\/\/ (.*)
$/ ) {
			push @description, $1;
			};
		if ( /(FROM|SOURCE)\s+<([^>]+)>\s*[,]?\s+/i ) {
			push @input, $2;
			};
		};
	close(TT);
	my %input;
	map {
		s/file://g;
		unless( exists $input{ $_ } ) {
			$input{ $_ } = ( /\.n3$/ ) ? 'N3' : ( /\.nt$/ ) ? 'NT' : ( /\.rdf$/ ) ? 'RDF-XML' : 'RDQL';
			$input{ $_ } .= '-Document';
			};
	} @input;
	my $description = "\n". join("\n", @description) . "\n";

	my $size;
	open(RR,"$result");
	while(<RR>) {
		next if ( /^#/ );
		$size = $1
			if ( /rs:size "(\d+)" ;/ );
		};
	close(RR);

	my $status = ($size > 0 ) ? 'true' : 'false';

	my $label = $name;
	$label =~ s/-\d+$//g;

print <<EOFRDF;
      <mf:Test mf:num='$num'>
         <mf:name>$name</mf:name>
         <mf:description>$description</mf:description>
         <mf:status>$status</mf:status>
         <mf:author>Andy Seaborne</mf:author>
         <mf:submissionDate>$date</mf:submissionDate>
         <mf:label>$label</mf:label>
         <mf:input rdf:parseType='Resource'>
            <tq:queryDocument rdf:resource='file:queries/$query' 
                              rdf:type='&tq;$query_document' />
EOFRDF

	map {
		print <<EOFRDF;	
            <tq:inputDocument rdf:resource='file:inputs/$_' 
                              rdf:type='&tq;$input{$_}'/>
EOFRDF
	} keys %input;

print <<EOFRDF;
         </mf:input>
         <mf:output rdf:parseType='Resource'>
            <tq:outputDocument rdf:resource='file:results/$result'
                               rdf:type='&tq;$result_document'
                               tq:numberRows='$size'/>
         </mf:output>
      </mf:Test>
EOFRDF
	$num++;
	};

close(ANDY);

print <<EOFRDF;

   </mf:tests>
</rdf:Description>

</rdf:RDF>
EOFRDF
